/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.DefineSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigItemTransferBase;

public final class DefineItemTransfer
extends ConfigItemTransferBase {
    private static DefineItemTransfer instance = new DefineItemTransfer();
    private static final String TYPE_NAME = "TITAN-DefineSectionItem-transfer-format";
    private static final int TYPEID = DefineItemTransfer.registerType((String)"TITAN-DefineSectionItem-transfer-format");

    public static DefineItemTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        DefineSectionHandler.Definition[] items = (DefineSectionHandler.Definition[])object;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(items.length);
            for (int i = 0; i < items.length; ++i) {
                out.writeUTF(this.convertToString(items[i].getRoot()));
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        if (bytes != null) {
            super.javaToNative(bytes, transferData);
        }
    }

    protected DefineSectionHandler.Definition[] nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            DefineSectionHandler.Definition[] items = new DefineSectionHandler.Definition[n];
            for (int i = 0; i < n; ++i) {
                items[i] = new DefineSectionHandler.Definition();
                ParserRuleContext root = new ParserRuleContext();
                items[i].setRoot((ParseTree)root);
                String hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                String name = in.readUTF();
                AddedParseTree nameNode = new AddedParseTree(name);
                items[i].setDefinitionName((ParseTree)nameNode);
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)nameNode);
                hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(":="));
                hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                String value = in.readUTF();
                AddedParseTree valueNode = new AddedParseTree(value);
                items[i].setDefinitionValue((ParseTree)valueNode);
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)valueNode);
            }
            return items;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return new DefineSectionHandler.Definition[0];
        }
    }
}

