/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;

public class TextHoverControl
extends AbstractInformationControl {
    private Browser fBrowser;
    private boolean fIsURL;

    public TextHoverControl(Shell parent) {
        super(parent, true);
        this.create();
    }

    protected void createContent(Composite parent) {
        try {
            this.fBrowser = new Browser((Composite)this.getShell(), 322);
            Color color = parent.getDisplay().getSystemColor(7);
            this.fBrowser.setBackgroundMode(2);
            this.fBrowser.setBackground(color);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    public void setInformation(String content) {
        this.fBrowser.setBounds(this.getShell().getClientArea());
        if (this.fIsURL) {
            this.fBrowser.setUrl(content);
        } else {
            this.fBrowser.setText(content);
        }
    }

    public Point computeSizeHint() {
        int widthHint = -1;
        return this.getShell().computeSize(-1, -1, true);
    }

    public boolean hasContents() {
        return this.fBrowser.getText().length() > 0;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new TextHoverControl(parent);
            }
        };
    }

    public void setInput(Object input) {
        String inputString;
        this.fIsURL = false;
        if (input instanceof IHTMLHoverInfo) {
            IHTMLHoverInfo inputInfo = (IHTMLHoverInfo)input;
            inputString = inputInfo.getHTMLString();
            this.fIsURL = inputInfo.isURL();
        } else {
            inputString = input instanceof String ? (String)input : input.toString();
        }
        this.setInformation(inputString);
    }

    public static interface IHTMLHoverInfo {
        public boolean isURL();

        public String getHTMLString();
    }
}

