/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.Activator;

public final class ColorManager {
    private static final Map<String, Color> COLOR_TABLE = new HashMap<String, Color>(10);
    private static final Map<String, Token> TOKEN_TABLE = new HashMap<String, Token>();

    public Color getForegroundColor(String aName) {
        Color color = COLOR_TABLE.get(aName);
        if (color == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)aName);
            color = rgb == null ? Display.getCurrent().getSystemColor(24) : new Color((Device)Display.getCurrent(), rgb);
            COLOR_TABLE.put(aName, color);
        }
        return color;
    }

    public Color getBackgroundColor(String aName) {
        Color color = COLOR_TABLE.get(aName);
        if (color == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)aName);
            color = rgb == null ? Display.getCurrent().getSystemColor(1) : new Color((Device)Display.getCurrent(), rgb);
            COLOR_TABLE.put(aName, color);
        }
        return color;
    }

    public TextAttribute createAttributeFromPreference(String key) {
        Color foregroundColor = this.getForegroundColor(key + ".foreground");
        Color backgroundColor = Activator.getDefault().getPreferenceStore().getBoolean(key + ".usebackgroundcolor") ? this.getBackgroundColor(key + ".background") : null;
        boolean isBold = Activator.getDefault().getPreferenceStore().getBoolean(key + ".bold");
        return new TextAttribute(foregroundColor, backgroundColor, isBold ? 1 : 0);
    }

    public Token createTokenFromPreference(String key) {
        if (TOKEN_TABLE.containsKey(key)) {
            return TOKEN_TABLE.get(key);
        }
        Token temp = new Token((Object)this.createAttributeFromPreference(key));
        TOKEN_TABLE.put(key, temp);
        return temp;
    }

    public void update(String key) {
        String baseKey = null;
        if (key.endsWith(".foreground")) {
            baseKey = key.substring(0, key.length() - ".foreground".length());
        } else if (key.endsWith(".background")) {
            baseKey = key.substring(0, key.length() - ".background".length());
        } else if (key.endsWith(".usebackgroundcolor")) {
            baseKey = key.substring(0, key.length() - ".usebackgroundcolor".length());
        } else if (key.endsWith(".bold")) {
            baseKey = key.substring(0, key.length() - ".bold".length());
        }
        if (baseKey != null && TOKEN_TABLE.containsKey(baseKey)) {
            Token tempToken = TOKEN_TABLE.get(baseKey);
            COLOR_TABLE.remove(key);
            tempToken.setData((Object)this.createAttributeFromPreference(baseKey));
        }
    }
}

