/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.decorators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;

public final class DecoratorVisitor
implements IResourceVisitor {
    static final String TRUE_STRING = "true";
    static final String PREPROCESSABLE_EXTENSION = "ttcnpp";
    static final String INCLUDEABLE_EXTENSION = "ttcnin";
    private boolean hasCentralStorage = false;
    private boolean hasPreprocessable = false;
    private QualifiedName centralStorageQualifier = new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage");

    public boolean visit(IResource resource) {
        if (!resource.isAccessible()) {
            return false;
        }
        switch (resource.getType()) {
            case 1: {
                if (ResourceExclusionHelper.isDirectlyExcluded((IFile)resource) || !PREPROCESSABLE_EXTENSION.equals(resource.getFileExtension()) && !INCLUDEABLE_EXTENSION.equals(resource.getFileExtension())) break;
                this.hasPreprocessable = true;
                break;
            }
            case 2: {
                try {
                    if (ResourceExclusionHelper.isDirectlyExcluded((IFolder)resource)) {
                        return false;
                    }
                    if (!TRUE_STRING.equals(resource.getPersistentProperty(this.centralStorageQualifier))) break;
                    this.hasCentralStorage = true;
                    break;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean getHasCentralStorage() {
        return this.hasCentralStorage;
    }

    public boolean getHasPreprecessable() {
        return this.hasPreprocessable;
    }
}

