/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandler;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandlerFactory;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.IBaseAnalyzer;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionAlgorithm;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionMethodBase;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.ui.console.MessageConsoleStream;

public final class BrokenPartsViaReferences
extends SelectionMethodBase
implements IBaseAnalyzer {
    private static final long TIMELIMIT = 10000000000L;
    private static final float BROKEN_MODULE_LIMIT = 10.0f;
    private final CompilationTimeStamp timestamp;
    private final Map<Module, List<Assignment>> moduleAndBrokenAssignments = new HashMap<Module, List<Assignment>>();
    private boolean analyzeOnlyAssignments = false;

    public BrokenPartsViaReferences(SelectionAlgorithm selectionAlgorithm, CompilationTimeStamp timestamp) {
        super(selectionAlgorithm);
        this.timestamp = timestamp;
        this.header = "\n**Selection with Broken parts via references is started at:";
        this.footer = "**Selection with Broken parts via references is ended at:  ";
    }

    public Map<Module, List<Assignment>> getModuleAndBrokenDefs() {
        return this.moduleAndBrokenAssignments;
    }

    public boolean getAnalyzeOnlyDefinitions() {
        return this.analyzeOnlyAssignments;
    }

    @Override
    public void execute() {
        if (this.writeDebugInfo) {
            TITANDebugConsole.println(String.format(this.format, this.header, this.simpleDateFormat.format(new Date())));
        }
        this.start = System.nanoTime();
        ArrayList<Module> startModules = new ArrayList<Module>();
        Map<Module, List<Module>> invertedImports = this.buildInvertedImportStructure(this.allModules, startModules);
        this.computeAnalyzeOnlyDefinitionsFlag(this.allModules, startModules);
        if (this.analyzeOnlyAssignments) {
            Map<Module, List<AssignmentHandler>> result = this.collectBrokenParts(startModules, invertedImports);
            if (this.writeDebugInfo && System.nanoTime() - this.start < 10000000000L) {
                this.writeDebugInfo(result);
            }
            this.collectRealBrokenParts(result);
        }
        if (this.writeDebugInfo && System.nanoTime() - this.start > 10000000000L) {
            TITANDebugConsole.println("  Switching back to old selection format");
        }
        if (!this.analyzeOnlyAssignments || System.nanoTime() - this.start > 10000000000L) {
            this.analyzeOnlyAssignments = false;
            this.modulesToCheck.clear();
            this.moduleAndBrokenAssignments.clear();
            List<Module> modules = this.collectBrokenModulesViaInvertedImports(startModules, invertedImports);
            this.modulesToCheck.addAll(modules);
        }
        this.afterExecute();
        this.end = System.nanoTime() - this.start;
        if (this.writeDebugInfo) {
            TITANDebugConsole.println(String.format(this.format, this.footer, this.simpleDateFormat.format(new Date())));
            this.infoAfterExecute();
        }
    }

    public void computeAnalyzeOnlyDefinitionsFlag(List<Module> allModules, List<Module> startModules) {
        float brokenModulesRatio = (float)((double)startModules.size() * 100.0 / (double)allModules.size());
        if (Float.compare(brokenModulesRatio, 10.0f) < 0) {
            this.analyzeOnlyAssignments = true;
        }
    }

    protected Map<Module, List<Module>> buildInvertedImportStructure(List<Module> allModules, List<Module> startModules) {
        HashMap<Module, List<Module>> invertedImports = new HashMap<Module, List<Module>>();
        for (Module actualModule : allModules) {
            if (!(actualModule.getLastCompilationTimeStamp() != null && !actualModule.isCheckRoot() && this.semanticallyChecked.contains(actualModule.getName()) || startModules.contains(actualModule))) {
                startModules.add(actualModule);
            }
            if (!invertedImports.containsKey(actualModule)) {
                invertedImports.put(actualModule, new ArrayList());
            }
            for (Module actualImportedModule : actualModule.getImportedModules()) {
                if (invertedImports.containsKey(actualImportedModule)) {
                    List dependentModules = (List)invertedImports.get(actualImportedModule);
                    if (dependentModules.contains(actualModule)) continue;
                    dependentModules.add(actualModule);
                    continue;
                }
                ArrayList<Module> temp = new ArrayList<Module>();
                temp.add(actualModule);
                invertedImports.put(actualImportedModule, temp);
            }
        }
        return invertedImports;
    }

    protected List<Module> collectBrokenModulesViaInvertedImports(List<Module> startModules, Map<Module, List<Module>> invertedImports) {
        ArrayList<Module> startModulesCopy = new ArrayList<Module>(startModules);
        ArrayList<Module> result = new ArrayList<Module>();
        MessageConsoleStream stream = TITANDebugConsole.getConsole().newMessageStream();
        if (this.writeDebugInfo) {
            for (Module startModule : startModules) {
                TITANDebugConsole.println("  ** Module " + startModule.getName() + " can not be skipped as it was not yet analyzed.", stream);
            }
        }
        for (int s = 0; s < startModulesCopy.size(); ++s) {
            Module startModule;
            startModule = (Module)startModulesCopy.get(s);
            if (!result.contains(startModule)) {
                result.add(startModule);
            }
            List<Module> whereStartModuleUsed = invertedImports.get(startModule);
            for (int d = 0; d < whereStartModuleUsed.size(); ++d) {
                Module dependentModule = whereStartModuleUsed.get(d);
                if (startModulesCopy.contains(dependentModule)) continue;
                startModulesCopy.add(dependentModule);
                if (!this.writeDebugInfo) continue;
                TITANDebugConsole.println("  ** Module " + dependentModule.getName() + " can not be skipped as it depends on " + startModule.getName() + " which needs to be checked.", stream);
            }
            startModule.notCheckRoot();
            Assignments assignments = startModule.getAssignments();
            for (int d = 0; d < assignments.getNofAssignments(); ++d) {
                Assignment assignment = assignments.getAssignmentByIndex(d);
                assignment.notCheckRoot();
            }
        }
        return result;
    }

    protected Map<Module, List<AssignmentHandler>> collectBrokenParts(List<Module> startModules, Map<Module, List<Module>> invertedImports) {
        ArrayList<Module> startModulesCopy = new ArrayList<Module>(startModules);
        HashMap<Module, List<AssignmentHandler>> moduleAndBrokenAssignments = new HashMap<Module, List<AssignmentHandler>>();
        this.processStartModules(startModulesCopy, moduleAndBrokenAssignments);
        for (int i = 0; i < startModulesCopy.size() && System.nanoTime() - this.start < 10000000000L; ++i) {
            List startAssignments;
            Module startModule = (Module)startModulesCopy.get(i);
            if (moduleAndBrokenAssignments.containsKey(startModule)) {
                startAssignments = (List)moduleAndBrokenAssignments.get(startModule);
            } else {
                startAssignments = this.getAssignmentsFrom(startModule);
                moduleAndBrokenAssignments.put(startModule, startAssignments);
            }
            if (startAssignments.isEmpty()) continue;
            List<Module> whereStartModuleUsed = invertedImports.get(startModule);
            for (int j = 0; j < whereStartModuleUsed.size(); ++j) {
                List dependentAssignments;
                Module dependentModule = whereStartModuleUsed.get(j);
                if (moduleAndBrokenAssignments.containsKey(dependentModule)) {
                    dependentAssignments = (List)moduleAndBrokenAssignments.get(dependentModule);
                } else {
                    dependentAssignments = this.getAssignmentsFrom(dependentModule);
                    moduleAndBrokenAssignments.put(dependentModule, dependentAssignments);
                }
                ArrayList<AssignmentHandler> brokens = new ArrayList<AssignmentHandler>();
                ArrayList<AssignmentHandler> notBrokens = new ArrayList<AssignmentHandler>();
                for (int s = 0; s < startAssignments.size(); ++s) {
                    AssignmentHandler startAssignment = (AssignmentHandler)startAssignments.get(s);
                    if (!startAssignment.getIsContagious()) continue;
                    for (int d = 0; d < dependentAssignments.size(); ++d) {
                        AssignmentHandler dependentAssignment = (AssignmentHandler)dependentAssignments.get(d);
                        dependentAssignment.check(startAssignment);
                        if (!dependentAssignment.getIsInfected()) continue;
                        if (!startModulesCopy.contains(dependentModule)) {
                            startModulesCopy.add(dependentModule);
                        }
                        brokens.add(dependentAssignment);
                    }
                }
                for (int d = 0; d < dependentAssignments.size(); ++d) {
                    AssignmentHandler dependentAssignment = (AssignmentHandler)dependentAssignments.get(d);
                    if (dependentAssignment.getIsInfected()) continue;
                    notBrokens.add(dependentAssignment);
                }
                this.checkLocalAssignments(brokens, notBrokens);
                if (startModulesCopy.contains(dependentModule)) continue;
                moduleAndBrokenAssignments.remove(dependentModule);
            }
        }
        return moduleAndBrokenAssignments;
    }

    protected void collectRealBrokenParts(Map<Module, List<AssignmentHandler>> moduleAndAssignments) {
        for (Map.Entry<Module, List<AssignmentHandler>> entry : moduleAndAssignments.entrySet()) {
            ArrayList<Assignment> assignments = new ArrayList<Assignment>();
            for (AssignmentHandler assignmentHandler : entry.getValue()) {
                if (assignmentHandler.getIsInfected()) {
                    assignments.add(assignmentHandler.getAssignment());
                }
                assignmentHandler.assignment.notCheckRoot();
            }
            if (assignments.isEmpty()) continue;
            Module module = entry.getKey();
            this.moduleAndBrokenAssignments.put(module, assignments);
            this.modulesToCheck.add(module);
        }
    }

    public void processStartModules(List<Module> startModules, Map<Module, List<AssignmentHandler>> moduleAndBrokenAssignments) {
        for (Module startModule : startModules) {
            Iterable<AssignmentHandler> startAssignments;
            if (System.nanoTime() - this.start > 10000000000L) {
                return;
            }
            if (startModule instanceof TTCN3Module && startModule.getLastCompilationTimeStamp() != null && !startModule.isCheckRoot()) {
                startAssignments = startModule.getAssignments();
                ArrayList<AssignmentHandler> brokens = new ArrayList<AssignmentHandler>();
                ArrayList<AssignmentHandler> notBrokens = new ArrayList<AssignmentHandler>();
                for (int d = 0; d < ((Assignments)startAssignments).getNofAssignments(); ++d) {
                    Assignment startAssignment = ((Assignments)startAssignments).getAssignmentByIndex(d);
                    AssignmentHandler assignmentHandler = AssignmentHandlerFactory.getDefinitionHandler(startAssignment);
                    if (startAssignment.getLastTimeChecked() == null) {
                        startAssignment.check(this.timestamp);
                    }
                    startAssignment.accept(assignmentHandler);
                    if (startAssignment.isCheckRoot()) {
                        assignmentHandler.setIsInfected(true);
                        startAssignment.notCheckRoot();
                        assignmentHandler.addReason("Definition's infected, because of incremental parsing.");
                        brokens.add(assignmentHandler);
                        continue;
                    }
                    if (assignmentHandler.getIsInfected()) {
                        assignmentHandler.addReason("Definition contains an infected reference.");
                        brokens.add(assignmentHandler);
                        continue;
                    }
                    notBrokens.add(assignmentHandler);
                }
                if (!brokens.isEmpty()) {
                    this.checkLocalAssignments(brokens, notBrokens);
                    if (moduleAndBrokenAssignments.containsKey(startModule)) {
                        moduleAndBrokenAssignments.get(startModule).addAll(brokens);
                    } else {
                        moduleAndBrokenAssignments.put(startModule, brokens);
                    }
                }
            } else {
                if (startModule.getLastCompilationTimeStamp() == null) {
                    startModule.check(this.timestamp);
                }
                startAssignments = this.getAssignmentsFrom(startModule);
                for (AssignmentHandler assignmentHandler : startAssignments) {
                    assignmentHandler.initStartParts();
                    assignmentHandler.assignment.notCheckRoot();
                    assignmentHandler.addReason("Parent module's CompilationTimeStamp is null.");
                }
                if (moduleAndBrokenAssignments.containsKey(startModule)) {
                    moduleAndBrokenAssignments.get(startModule).addAll((Collection<AssignmentHandler>)startAssignments);
                } else {
                    moduleAndBrokenAssignments.put(startModule, (List<AssignmentHandler>)startAssignments);
                }
            }
            startModule.notCheckRoot();
        }
    }

    public List<AssignmentHandler> getAssignmentsFrom(Module module) {
        ArrayList<AssignmentHandler> assignmentHandlers = new ArrayList<AssignmentHandler>();
        Assignments assignments = module.getAssignments();
        for (int d = 0; d < assignments.getNofAssignments(); ++d) {
            Assignment assignment = assignments.getAssignmentByIndex(d);
            AssignmentHandler assignmentHandler = AssignmentHandlerFactory.getDefinitionHandler(assignment);
            assignment.accept(assignmentHandler);
            assignmentHandlers.add(assignmentHandler);
        }
        return assignmentHandlers;
    }

    protected void checkLocalAssignments(List<AssignmentHandler> brokens, List<AssignmentHandler> notBrokens) {
        if (brokens.isEmpty() || notBrokens.isEmpty()) {
            return;
        }
        HashMap<String, AssignmentHandler> brokenMap = new HashMap<String, AssignmentHandler>(brokens.size() + notBrokens.size());
        for (AssignmentHandler handler : brokens) {
            brokenMap.put(handler.getAssignment().getIdentifier().getDisplayName(), handler);
        }
        boolean proceed = true;
        while (proceed) {
            proceed = false;
            for (int i = notBrokens.size() - 1; i >= 0; --i) {
                AssignmentHandler notBroken = notBrokens.get(i);
                boolean found = false;
                for (String name : notBroken.getContagiousReferences()) {
                    if (!brokenMap.containsKey(name)) continue;
                    notBroken.check((AssignmentHandler)brokenMap.get(name));
                    found = true;
                    break;
                }
                if (!found) {
                    for (String name : notBroken.getNonContagiousReferences()) {
                        if (!brokenMap.containsKey(name)) continue;
                        notBroken.check((AssignmentHandler)brokenMap.get(name));
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                proceed = true;
                notBrokens.remove(i);
                brokens.add(notBroken);
                brokenMap.put(notBroken.getAssignment().getIdentifier().getDisplayName(), notBroken);
            }
        }
    }

    protected void writeDebugInfo(final Map<Module, List<AssignmentHandler>> moduleAndAssignments) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TITANDebugConsole.println("  Detailed info:");
                for (Map.Entry entry : moduleAndAssignments.entrySet()) {
                    List values = (List)entry.getValue();
                    TITANDebugConsole.println("    module: " + ((Module)entry.getKey()).getIdentifier().getDisplayName());
                    for (AssignmentHandler assignmentHandler : values) {
                        TITANDebugConsole.println("         " + assignmentHandler + " | " + assignmentHandler.getReasons());
                        if (!assignmentHandler.getIsInfected() && !assignmentHandler.getIsContagious()) continue;
                        TITANDebugConsole.println("            " + (assignmentHandler.getIsInfected() ? "[+]" : "[-]") + " : infected");
                        TITANDebugConsole.println("            " + (assignmentHandler.getIsContagious() ? "[+]" : "[-]") + " : contagious");
                        TITANDebugConsole.println("            nonContagious references: " + assignmentHandler.getNonContagiousReferences());
                        TITANDebugConsole.println("            contagious references: " + assignmentHandler.getContagiousReferences());
                        TITANDebugConsole.println("            infected references: " + assignmentHandler.getInfectedReferences());
                    }
                }
                TITANDebugConsole.println("  in dot format:");
                TITANDebugConsole.println("  digraph {");
                TITANDebugConsole.println("    rankdir=LR;");
                ArrayList modules = new ArrayList(moduleAndAssignments.keySet());
                Collections.sort(modules, new Comparator<Module>(){

                    @Override
                    public int compare(Module o1, Module o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Module module : modules) {
                    String moduleName = module.getName();
                    TITANDebugConsole.println("    subgraph cluster_" + moduleName + " {");
                    TITANDebugConsole.println("    label=\" " + module.getIdentifier().getDisplayName() + "\";");
                    List values = (List)moduleAndAssignments.get(module);
                    for (AssignmentHandler assignmentHandler : values) {
                        for (String reference : assignmentHandler.getInfectedReferences()) {
                            TITANDebugConsole.println("      " + assignmentHandler.getAssignment().getIdentifier().getDisplayName() + "->" + reference + ";");
                        }
                    }
                    TITANDebugConsole.println("    }");
                }
                TITANDebugConsole.println("  }");
            }
        });
    }
}

