/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IType;

public final class TypeCompatibilityInfo {
    private StringBuilder op1RefStr;
    private StringBuilder op2RefStr;
    private IType op1Type;
    private IType op2Type;
    private String errorStr;
    private boolean needsConversion;
    private String subtypeErrorStr = null;
    private boolean str1Element = false;
    private boolean str2Element = false;

    public TypeCompatibilityInfo(IType pOp1Type, IType pOp2Type, boolean pAddRefStr) {
        if (pOp1Type != null && pOp2Type != null) {
            this.needsConversion = false;
            this.op1Type = pOp1Type;
            this.op2Type = pOp2Type;
            this.op1RefStr = new StringBuilder();
            this.op2RefStr = new StringBuilder();
            if (pAddRefStr) {
                this.op1RefStr.append(this.op1Type.getTypename());
                this.op2RefStr.append(this.op2Type.getTypename());
            }
        }
    }

    public String getSubtypeError() {
        return this.subtypeErrorStr;
    }

    public void setSubtypeError(String errStr) {
        this.subtypeErrorStr = errStr;
    }

    public void setStr1Elem(boolean pStr1Elem) {
        this.str1Element = pStr1Elem;
    }

    public void setStr2Elem(boolean pStr2Elem) {
        this.str2Element = pStr2Elem;
    }

    public boolean getStr1Elem() {
        return this.str1Element;
    }

    public boolean getStr2Elem() {
        return this.str2Element;
    }

    public void appendOp1Ref(String pRef) {
        if (this.op1RefStr != null) {
            this.op1RefStr.append(pRef);
        }
    }

    public void appendOp2Ref(String pRef) {
        if (this.op2RefStr != null) {
            this.op2RefStr.append(pRef);
        }
    }

    public void setOp1Type(IType pType) {
        this.op1Type = pType;
    }

    public void setOp2Type(IType pType) {
        this.op2Type = pType;
    }

    public String getOp1RefStr() {
        return this.op1RefStr.toString();
    }

    public String getOp2RefStr() {
        return this.op2RefStr.toString();
    }

    public IType getOp1Type() {
        return this.op1Type;
    }

    public IType getOp2Type() {
        return this.op2Type;
    }

    public void setErrorStr(String pStr) {
        this.errorStr = pStr;
    }

    public String getErrorStr() {
        return this.errorStr;
    }

    public void setNeedsConversion(boolean pNeedsConversion) {
        this.needsConversion = pNeedsConversion;
    }

    public boolean getNeedsConversion() {
        return this.needsConversion;
    }

    public String toString() {
        StringBuilder returnValue = new StringBuilder("Type mismatch: ");
        String op1DisplayString = this.op1RefStr.toString();
        String op2DisplayString = this.op2RefStr.toString();
        String op1TypeName = null;
        String op2TypeName = null;
        if (this.op1Type != null) {
            op1TypeName = this.op1Type.getTypename();
        }
        if (this.op2Type != null) {
            op2TypeName = this.op2Type.getTypename();
        }
        returnValue.append('`').append(op1DisplayString).append('\'');
        if (op1TypeName != null && !op1DisplayString.equals(op1TypeName)) {
            returnValue.append(" of type ");
            returnValue.append('`');
            returnValue.append(op1TypeName);
            returnValue.append('\'');
        }
        returnValue.append(" and ");
        returnValue.append('`').append(op2DisplayString).append('\'');
        if (op2TypeName != null && !op2DisplayString.equals(op2TypeName)) {
            returnValue.append(" of type ");
            returnValue.append('`');
            returnValue.append(op2TypeName);
            returnValue.append('\'');
        }
        returnValue.append(" are not compatible");
        if (this.errorStr != null) {
            returnValue.append(": " + this.errorStr);
        }
        return returnValue.toString();
    }

    public Chain getChain() {
        return new Chain();
    }

    public static final class Chain {
        private final List<IType> chainLinks = new ArrayList<IType>();
        private final List<Integer> markedStates = new ArrayList<Integer>();
        private int firstDouble = -1;

        public boolean hasRecursion() {
            return this.firstDouble != -1;
        }

        public void add(IType chainLink) {
            if (this.firstDouble == -1) {
                for (int i = 0; i < this.chainLinks.size(); ++i) {
                    if (this.chainLinks.get(i) != chainLink) continue;
                    this.firstDouble = this.chainLinks.size();
                }
            }
            this.chainLinks.add(chainLink);
        }

        public void markState() {
            this.markedStates.add(this.chainLinks.size());
        }

        public void previousState() {
            if (this.markedStates.isEmpty()) {
                return;
            }
            for (int i = this.chainLinks.size() - 1; i >= this.markedStates.get(this.markedStates.size() - 1); --i) {
                this.chainLinks.remove(i);
            }
            this.markedStates.remove(this.markedStates.size() - 1);
            if (this.chainLinks.size() <= this.firstDouble) {
                this.firstDouble = -1;
            }
        }
    }
}

