/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SubstrExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The first operand of operation `substr' should be a string, `record of', or a `set of' value";
    private static final String OPERANDERROR2 = "The second operand of operation `substr' should be an integer value";
    private static final String OPERANDERROR3 = "The second operand of operation `substr' should not be negative";
    private static final String OPERANDERROR4 = "The third operand of operation `substr' should be an integer value";
    private static final String OPERANDERROR5 = "The third operand of operation `substr' should not be negative";
    private static final String OPERANDERROR6 = "The third operand of operation `substr'' ({0}) is greater than the length of the first operand ({1})";
    private static final String OPERANDERROR7 = "The second operand of operation `substr'' ({0}) is greater than the length of the first operand ({1})";
    private static final String OPERANDERROR8 = "The sum of second operand ({0}) and third operand ({1}) of operation `substr'' is greater than the length of the first operand ({2})";
    private static final String OPERANDERROR9 = "Using a large integer value ({0}) as the second operand of operation `substr'' is not allowed";
    private static final String OPERANDERROR10 = "Using a large integer value ({0}) as the third operand of operation `substr'' is not allowed";
    private final TemplateInstance templateInstance1;
    private final Value value2;
    private final Value value3;

    public SubstrExpression(TemplateInstance templateInstance1, Value value2, Value value3) {
        this.templateInstance1 = templateInstance1;
        this.value2 = value2;
        this.value3 = value3;
        if (templateInstance1 != null) {
            templateInstance1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
        if (value3 != null) {
            value3.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.SUBSTR_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("substr");
        builder.append('(').append(this.templateInstance1.createStringRepresentation());
        builder.append(", ");
        builder.append(this.value2.createStringRepresentation());
        builder.append(", ");
        builder.append(this.value3.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance1 != null) {
            this.templateInstance1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
        if (this.value3 != null) {
            this.value3.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        if (this.value3 == child) {
            return builder.append(".<operand3>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IValue last = this.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || this.templateInstance1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        ITTCN3Template template = this.templateInstance1.getTemplateBody().setLoweridToReference(timestamp);
        IType.Type_type tempType = template.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_SET_OF: 
            case TYPE_SEQUENCE_OF: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance1 == null || this.value2 == null || this.value3 == null || this.getIsErroneous(timestamp)) {
            return true;
        }
        ITTCN3Template template = this.templateInstance1.getTemplateBody();
        if (template == null || !ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template.getTemplatetype())) {
            return true;
        }
        IValue value1 = ((SpecificValue_Template)template).getSpecificValue();
        if (value1 == null) {
            return true;
        }
        template = template.setLoweridToReference(timestamp);
        IType.Type_type tempType = template.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                break;
            }
            default: {
                return true;
            }
        }
        return value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value3.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        long i;
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        IType.Type_type tempType1 = null;
        IType.Type_type tempType2 = null;
        IType.Type_type tempType3 = null;
        IValue value1 = null;
        if (this.templateInstance1 != null) {
            TTCN3Template temp = this.templateInstance1.getTemplateBody();
            if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)temp.getTemplatetype())) {
                this.location.reportSemanticError(OPERANDERROR1);
                this.setIsErroneous(true);
            }
            value1 = ((SpecificValue_Template)temp).getSpecificValue();
            value1.setLoweridToReference(timestamp);
            tempType1 = value1.getExpressionReturntype(timestamp, internalExpectation);
            switch (tempType1) {
                case TYPE_BITSTRING: 
                case TYPE_HEXSTRING: 
                case TYPE_OCTETSTRING: 
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: 
                case TYPE_SET_OF: 
                case TYPE_SEQUENCE_OF: {
                    value1.getValueRefdLast(timestamp, internalExpectation, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value2 != null) {
            this.value2.setLoweridToReference(timestamp);
            tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_INTEGER: {
                    IValue last2 = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (last2.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last2.getValuetype())) break;
                    if (((Integer_Value)last2).isNative()) {
                        i = ((Integer_Value)last2).getValue();
                        if (i >= 0L) break;
                        this.value2.getLocation().reportSemanticError(OPERANDERROR3);
                        this.setIsErroneous(true);
                        break;
                    }
                    this.value2.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR9, last2));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR2);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value3 != null) {
            this.value3.setLoweridToReference(timestamp);
            tempType3 = this.value3.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType3) {
                case TYPE_INTEGER: {
                    IValue last3 = this.value3.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (last3.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last3.getValuetype())) break;
                    if (((Integer_Value)last3).isNative()) {
                        i = ((Integer_Value)last3).getValue();
                        if (i >= 0L) break;
                        this.value3.getLocation().reportSemanticError(OPERANDERROR5);
                        this.setIsErroneous(true);
                        break;
                    }
                    this.value3.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR10, last3));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR4);
                    this.setIsErroneous(true);
                }
            }
        }
        this.checkExpressionOperandsHelper(timestamp, value1, expectedValue, referenceChain);
    }

    private void checkExpressionOperandsHelper(CompilationTimeStamp timestamp, IValue value1, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (value1 == null || this.value2 == null || this.value3 == null || this.getIsErroneous(timestamp)) {
            return;
        }
        long valueSize = -1L;
        if (!value1.isUnfoldable(timestamp)) {
            IValue temp = value1.setLoweridToReference(timestamp);
            temp = temp.getValueRefdLast(timestamp, referenceChain);
            switch (temp.getValuetype()) {
                case BITSTRING_VALUE: {
                    valueSize = ((Bitstring_Value)temp).getValueLength();
                    break;
                }
                case HEXSTRING_VALUE: {
                    valueSize = ((Hexstring_Value)temp).getValueLength();
                    break;
                }
                case OCTETSTRING_VALUE: {
                    valueSize = ((Octetstring_Value)temp).getValueLength();
                    break;
                }
                case CHARSTRING_VALUE: {
                    valueSize = ((Charstring_Value)temp).getValueLength();
                    break;
                }
                case UNIVERSALCHARSTRING_VALUE: {
                    valueSize = ((UniversalCharstring_Value)temp).getValueLength();
                    break;
                }
                case SEQUENCEOF_VALUE: {
                    valueSize = ((SequenceOf_Value)temp).getNofComponents();
                    break;
                }
                case SETOF_VALUE: {
                    valueSize = ((SetOf_Value)temp).getNofComponents();
                    break;
                }
            }
        }
        if (valueSize < 0L) {
            return;
        }
        if (this.value2.isUnfoldable(timestamp)) {
            IValue last3;
            long last3Value;
            if (!this.value3.isUnfoldable(timestamp) && (last3Value = ((Integer_Value)(last3 = this.value3.getValueRefdLast(timestamp, expectedValue, referenceChain))).getValue()) > valueSize) {
                this.location.reportSemanticError(MessageFormat.format(OPERANDERROR6, last3Value, valueSize));
                this.setIsErroneous(true);
            }
        } else {
            IValue last2 = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
            long last2Value = ((Integer_Value)last2).getValue();
            if (this.value3.isUnfoldable(timestamp)) {
                if (last2Value > valueSize) {
                    this.location.reportSemanticError(MessageFormat.format(OPERANDERROR7, last2Value, valueSize));
                    this.setIsErroneous(true);
                }
            } else {
                IValue last3 = this.value3.getValueRefdLast(timestamp, expectedValue, referenceChain);
                long last3Value = ((Integer_Value)last3).getValue();
                if (last2Value + last3Value > valueSize) {
                    this.location.reportSemanticError(MessageFormat.format(OPERANDERROR8, last2Value, last3Value, valueSize));
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance1 == null || this.value2 == null || this.value3 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        TTCN3Template temp = this.templateInstance1.getTemplateBody();
        IValue value1 = ((SpecificValue_Template)temp).getSpecificValue();
        IValue v1 = value1.getValueRefdLast(timestamp, referenceChain);
        IValue v2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        IValue v3 = this.value3.getValueRefdLast(timestamp, referenceChain);
        int index = (int)((Integer_Value)v2).getValue();
        int len = (int)((Integer_Value)v3).getValue();
        switch (v1.getValuetype()) {
            case BITSTRING_VALUE: {
                this.lastValue = new Bitstring_Value(((Bitstring_Value)v1).getValue().substring(index, index + len));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case HEXSTRING_VALUE: {
                this.lastValue = new Hexstring_Value(((Hexstring_Value)v1).getValue().substring(index, index + len));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case OCTETSTRING_VALUE: {
                this.lastValue = new Octetstring_Value(((Octetstring_Value)v1).getValue().substring(index * 2, (index + len) * 2));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case CHARSTRING_VALUE: {
                this.lastValue = new Charstring_Value(((Charstring_Value)v1).getValue().substring(index, index + len));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                this.lastValue = new UniversalCharstring_Value(((UniversalCharstring_Value)v1).getValue().substring(index, index + len));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.templateInstance1 != null) {
                referenceChain.markState();
                this.templateInstance1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value3 != null) {
                referenceChain.markState();
                this.value3.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance1 != null) {
            this.templateInstance1.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
        if (this.value3 != null) {
            this.value3.updateSyntax(reparser, false);
            reparser.updateLocation(this.value3.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance1 != null) {
            this.templateInstance1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value3 != null) {
            this.value3.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstance1 != null && !this.templateInstance1.accept(v)) {
            return false;
        }
        if (this.value2 != null && !this.value2.accept(v)) {
            return false;
        }
        return this.value3 == null || this.value3.accept(v);
    }
}

