/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.values.RelativeObjectIdentifier_Value;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.LengthRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.RangeLenghtRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.SingleLenghtRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.ObjectIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Set_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SizeOfExpression
extends Expression_Value {
    private final TemplateInstance templateInstance;

    public SizeOfExpression(TemplateInstance templateInstance) {
        this.templateInstance = templateInstance;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.SIZEOF_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("sizeof(");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return !(this.lastValue instanceof Integer_Value);
    }

    private long checkTimerPort(CompilationTimeStamp timestamp, Reference ref, ArrayDimensions dimensions, Assignment assignment) {
        int referencedDimensions;
        if (dimensions == null) {
            this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("operation is not applicable to single {0}", assignment.getDescription()));
            this.setIsErroneous(true);
            return -1L;
        }
        dimensions.checkIndices(timestamp, ref, assignment.getAssignmentName(), true, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        List<ISubReference> subreferences = ref.getSubreferences();
        if (subreferences.size() > 1) {
            int nofDimensions;
            referencedDimensions = subreferences.size() - 1;
            if (referencedDimensions < (nofDimensions = dimensions.size())) {
                this.setIsErroneous(true);
                return -1L;
            }
            if (referencedDimensions == nofDimensions) {
                this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Operation is not applicable to a {0}", assignment.getAssignmentName()));
                this.setIsErroneous(true);
                return -1L;
            }
        } else {
            referencedDimensions = 0;
        }
        return dimensions.get(referencedDimensions).getSize();
    }

    private long checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType governor;
        Reference ref;
        Expected_Value_type internalExpectedValue = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        TTCN3Template template = this.templateInstance.getTemplateBody();
        template.getTemplateReferencedLast(timestamp, referenceChain);
        if (template.getTemplatetype() == ITTCN3Template.Template_type.SPECIFIC_VALUE) {
            Referenced_Value referencedValue;
            Assignment temporalAss;
            SpecificValue_Template specValTempl = (SpecificValue_Template)template;
            IValue val = specValTempl.getSpecificValue();
            val.setMyGovernor(specValTempl.getMyGovernor());
            if (val.getValuetype() == IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE) {
                val = val.setLoweridToReference(timestamp);
            }
            if (val != null && val.getValuetype() == IValue.Value_type.REFERENCED_VALUE && (temporalAss = (ref = (referencedValue = (Referenced_Value)val).getReference()).getRefdAssignment(timestamp, true)) != null) {
                Assignment.Assignment_type asstype = temporalAss.getAssignmentType();
                if (asstype == Assignment.Assignment_type.A_PORT) {
                    ArrayDimensions dimensions = ((Def_Port)temporalAss).getDimensions();
                    return this.checkTimerPort(timestamp, ref, dimensions, temporalAss);
                }
                if (asstype == Assignment.Assignment_type.A_TIMER) {
                    ArrayDimensions dimensions = ((Def_Timer)temporalAss).getDimensions();
                    return this.checkTimerPort(timestamp, ref, dimensions, temporalAss);
                }
            }
        }
        if ((governor = this.templateInstance.getExpressionGovernor(timestamp, internalExpectedValue)) == null) {
            ITTCN3Template templ = this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
            governor = templ.getExpressionGovernor(timestamp, internalExpectedValue);
        }
        if (governor == null) {
            this.setIsErroneous(true);
            return -1L;
        }
        IType.Type_type typetype = this.templateInstance.getExpressionReturntype(timestamp, internalExpectedValue);
        switch (typetype) {
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_ASN1_SET: 
            case TYPE_ARRAY: 
            case TYPE_OBJECTID: 
            case TYPE_ROID: 
            case TYPE_UNDEFINED: {
                break;
            }
            default: {
                this.templateInstance.getLocation().reportSemanticError("Reference to a value or template of type record, record of, set, set of, objid or array was expected");
                this.setIsErroneous(true);
                return -1L;
            }
        }
        IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, governor, referenceChain, internalExpectedValue);
        if (this.isErroneous) {
            return -1L;
        }
        this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
        if (template.getTemplatetype() != ITTCN3Template.Template_type.SPECIFIC_VALUE) {
            return -1L;
        }
        IValue value = ((SpecificValue_Template)template).getSpecificValue();
        if (value.getValuetype() == IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE) {
            value = value.setLoweridToReference(timestamp);
        }
        if (value.getValuetype() != IValue.Value_type.REFERENCED_VALUE) {
            return this.evaluateValue(value);
        }
        ref = ((Referenced_Value)value).getReference();
        Assignment assignment = ref.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return -1L;
        }
        if (assignment.getIsErroneous()) {
            this.setIsErroneous(true);
            return -1L;
        }
        switch (assignment.getAssignmentType()) {
            case A_CONST: {
                value = ((Def_Const)assignment).getValue().getValueRefdLast(timestamp, internalExpectedValue, referenceChain);
                return this.evaluateValue(value);
            }
            case A_TEMPLATE: {
                template = ((Def_Template)assignment).getTemplate(timestamp).getTemplateReferencedLast(timestamp, referenceChain);
                return this.evaluateTemplate(template, timestamp);
            }
            case A_TIMER: {
                ArrayDimensions dimensions = ((Def_Timer)assignment).getDimensions();
                return this.checkTimerPort(timestamp, ref, dimensions, assignment);
            }
            case A_PORT: {
                ArrayDimensions dimensions = ((Def_Port)assignment).getDimensions();
                return this.checkTimerPort(timestamp, ref, dimensions, assignment);
            }
            case A_EXT_CONST: 
            case A_MODULEPAR: {
                if (!Expected_Value_type.EXPECTED_CONSTANT.equals((Object)internalExpectedValue)) break;
                this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Reference to an (evaluatable) constant value was expected instead of {0}", assignment.getDescription()));
                this.setIsErroneous(true);
                return -1L;
            }
            case A_VAR: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                switch (internalExpectedValue) {
                    case EXPECTED_CONSTANT: {
                        this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Reference to a constant value was expected instead of {0}", assignment.getDescription()));
                        this.setIsErroneous(true);
                        return -1L;
                    }
                    case EXPECTED_STATIC_VALUE: {
                        this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Reference to a static value was expected instead of {0}", assignment.getDescription()));
                        this.setIsErroneous(true);
                        return -1L;
                    }
                }
                break;
            }
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: {
                switch (internalExpectedValue) {
                    case EXPECTED_CONSTANT: {
                        this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Reference to a constant value was expected instead of the return value of {0}", assignment.getDescription()));
                        this.setIsErroneous(true);
                        return -1L;
                    }
                    case EXPECTED_STATIC_VALUE: {
                        this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Reference to a static value was expected instead of the return value of {0}", assignment.getDescription()));
                        this.setIsErroneous(true);
                        return -1L;
                    }
                }
                break;
            }
            case A_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RTEMP: {
                if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)internalExpectedValue)) break;
                this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Reference to a value was expected instead of a call of {0}, which returns a template", assignment.getDescription()));
                this.setIsErroneous(true);
                return -1L;
            }
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)internalExpectedValue)) break;
                this.templateInstance.getLocation().reportSemanticError(MessageFormat.format("Reference to a value was expected instead of {0}", assignment.getDescription()));
                this.setIsErroneous(true);
                return -1L;
            }
            default: {
                return -1L;
            }
        }
        return -1L;
    }

    private long evaluateValue(IValue value) {
        switch (value.getValuetype()) {
            case SEQUENCEOF_VALUE: {
                SequenceOf_Value seqOfValue = (SequenceOf_Value)value;
                if (seqOfValue.isIndexed()) {
                    return -1L;
                }
                return seqOfValue.getNofComponents();
            }
            case SETOF_VALUE: {
                SetOf_Value setOfValue = (SetOf_Value)value;
                if (setOfValue.isIndexed()) {
                    return -1L;
                }
                return setOfValue.getNofComponents();
            }
            case ARRAY_VALUE: {
                Array_Value arrayValue = (Array_Value)value;
                if (arrayValue.isIndexed()) {
                    return -1L;
                }
                return arrayValue.getNofComponents();
            }
            case OBJECTID_VALUE: {
                return ((ObjectIdentifier_Value)value).getNofComponents();
            }
            case RELATIVEOBJECTIDENTIFIER_VALUE: {
                return ((RelativeObjectIdentifier_Value)value).getNofComponents();
            }
            case SEQUENCE_VALUE: {
                int result = 0;
                Sequence_Value temp = (Sequence_Value)value;
                int size = temp.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    if (IValue.Value_type.OMIT_VALUE.equals((Object)temp.getSeqValueByIndex(i).getValue().getValuetype())) continue;
                    ++result;
                }
                return result;
            }
            case SET_VALUE: {
                int result = 0;
                Set_Value temp = (Set_Value)value;
                int size = temp.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    if (IValue.Value_type.OMIT_VALUE.equals((Object)temp.getSequenceValueByIndex(i).getValue().getValuetype())) continue;
                    ++result;
                }
                return result;
            }
        }
        return -1L;
    }

    private long evaluateTemplate(ITTCN3Template template, CompilationTimeStamp timestamp) {
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                Template_List temp = (Template_List)template;
                if (temp.templateContainsAnyornone()) {
                    LengthRestriction lengthRestriction = temp.getLengthRestriction();
                    if (lengthRestriction == null) {
                        this.templateInstance.getLocation().reportSemanticError("`sizeof' operation is not applicable for templates containing `*' without length restriction");
                        this.setIsErroneous(true);
                        return -1L;
                    }
                    if (lengthRestriction instanceof RangeLenghtRestriction) {
                        IValue upper = ((RangeLenghtRestriction)lengthRestriction).getUpperValue(timestamp);
                        if (IValue.Value_type.REAL_VALUE.equals((Object)upper.getValuetype()) && ((Real_Value)upper).isPositiveInfinity()) {
                            this.templateInstance.getLocation().reportSemanticError("`sizeof' operation is not applicable for templates containing `*' without upper boundary in the length restriction");
                            this.setIsErroneous(true);
                            return -1L;
                        }
                        if (!IValue.Value_type.INTEGER_VALUE.equals((Object)upper.getValuetype())) break;
                        int nofComponents = temp.getNofTemplatesNotAnyornone(timestamp);
                        if (nofComponents == ((Integer_Value)upper).intValue()) {
                            return nofComponents;
                        }
                        IValue lower = ((RangeLenghtRestriction)lengthRestriction).getLowerValue(timestamp);
                        if (lower != null && IValue.Value_type.INTEGER_VALUE.equals((Object)lower.getValuetype()) && ((Integer_Value)upper).intValue() == ((Integer_Value)lower).intValue()) {
                            return ((Integer_Value)upper).intValue();
                        }
                        this.templateInstance.getLocation().reportSemanticError("`sizeof' operation is not applicable for templates without exact size");
                        this.setIsErroneous(true);
                        return -1L;
                    }
                    IValue restriction = ((SingleLenghtRestriction)lengthRestriction).getRestriction(timestamp);
                    if (!IValue.Value_type.INTEGER_VALUE.equals((Object)restriction.getValuetype())) break;
                    return ((Integer_Value)restriction).intValue();
                }
                int result = 0;
                int size = temp.getNofTemplates();
                block10: for (int i = 0; i < size; ++i) {
                    ITemplateListItem tmp = temp.getTemplateByIndex(i);
                    switch (tmp.getTemplatetype()) {
                        case SPECIFIC_VALUE: {
                            if (tmp.getValue().getValuetype() == IValue.Value_type.OMIT_VALUE) continue block10;
                            ++result;
                            continue block10;
                        }
                        default: {
                            ++result;
                        }
                    }
                }
                return result;
            }
            case NAMED_TEMPLATE_LIST: {
                int result = 0;
                Named_Template_List temp = (Named_Template_List)template;
                int size = temp.getNofTemplates();
                block11: for (int i = 0; i < size; ++i) {
                    ITemplateListItem tmp = temp.getTemplateByIndex(i).getTemplate();
                    switch (tmp.getTemplatetype()) {
                        case SPECIFIC_VALUE: {
                            if (tmp.getValue().getValuetype() == IValue.Value_type.OMIT_VALUE) continue block11;
                            ++result;
                            continue block11;
                        }
                        default: {
                            ++result;
                        }
                    }
                }
                return result;
            }
            default: {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance == null) {
            return this.lastValue;
        }
        long i = this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (i != -1L) {
            this.lastValue = new Integer_Value(i);
            this.lastValue.copyGeneralProperties(this);
        }
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance == null) {
            return;
        }
        this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.templateInstance == null || this.templateInstance.accept(v);
    }
}

