/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class DecodeExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The first operand of the `decvalue' operation should be a bitstring value";
    private static final String OPERANDERROR2 = "The second operand of the `decvalue' operation is unable to hold a decoded value";
    private final Reference reference1;
    private final Reference reference2;

    public DecodeExpression(Reference reference1, Reference reference2) {
        this.reference1 = reference1;
        this.reference2 = reference2;
        if (reference1 != null) {
            reference1.setFullNameParent(this);
        }
        if (reference2 != null) {
            reference2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.DECODE_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("decvalue");
        builder.append('(').append(this.reference1.getDisplayName());
        builder.append(", ");
        builder.append(this.reference2.getDisplayName());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference1 != null) {
            this.reference1.setMyScope(scope);
        }
        if (this.reference2 != null) {
            this.reference2.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.reference1 == child || this.reference2 == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.reference1 == null || this.reference2 == null) {
            return;
        }
        Assignment temporalAssignment = this.reference1.getRefdAssignment(timestamp, true);
        if (temporalAssignment == null) {
            this.setIsErroneous(true);
            return;
        }
        switch (temporalAssignment.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_TEMPLATE: {
                this.reference1.getLocation().reportSemanticError(MessageFormat.format("Reference to `{0}'' cannot be used as the first operand of the `decvalue'' operation", temporalAssignment.getAssignmentName()));
                this.setIsErroneous(true);
                break;
            }
            case A_VAR: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                break;
            }
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                Referenced_Template template = new Referenced_Template(this.reference1);
                template.setMyScope(this.getMyScope());
                template.setFullNameParent(new BridgingNamedNode(this, ".<operand>"));
                TTCN3Template last = template.getTemplateReferencedLast(timestamp);
                if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)last.getTemplatetype()) || last == template) break;
                this.reference1.getLocation().reportSemanticError(MessageFormat.format("Specific value template was expected instead of `{0}''", last.getTemplateTypeName()));
                this.setIsErroneous(true);
                return;
            }
            default: {
                this.reference1.getLocation().reportSemanticError(MessageFormat.format("Reference to `{0}'' cannot be used as the first operand of the `decvalue' operation", temporalAssignment.getAssignmentName()));
                this.setIsErroneous(true);
                return;
            }
        }
        IType temporalType = temporalAssignment.getType(timestamp).getFieldType(timestamp, this.reference1, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (temporalType == null) {
            this.setIsErroneous(true);
            return;
        }
        if (temporalType.getTypeRefdLast(timestamp).getTypetype() != IType.Type_type.TYPE_BITSTRING) {
            if (!this.isErroneous) {
                this.location.reportSemanticError(OPERANDERROR1);
                this.setIsErroneous(true);
            }
            return;
        }
        temporalAssignment = this.reference2.getRefdAssignment(timestamp, true);
        if (temporalAssignment == null) {
            this.setIsErroneous(true);
            return;
        }
        temporalType = temporalAssignment.getType(timestamp).getFieldType(timestamp, this.reference2, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (temporalType == null) {
            this.setIsErroneous(true);
            return;
        }
        temporalType = temporalType.getTypeRefdLast(timestamp);
        switch (temporalType.getTypetype()) {
            case TYPE_UNDEFINED: 
            case TYPE_NULL: 
            case TYPE_REFERENCED: 
            case TYPE_VERDICT: 
            case TYPE_PORT: 
            case TYPE_COMPONENT: 
            case TYPE_DEFAULT: 
            case TYPE_SIGNATURE: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                this.reference2.getLocation().reportSemanticError(OPERANDERROR2);
                this.setIsErroneous(true);
                break;
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        this.checkExpressionOperands(timestamp, referenceChain);
        return this.lastValue;
    }

    private void checkRecursionHelper(CompilationTimeStamp timestamp, Reference reference, IReferenceChain referenceChain) {
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                Referenced_Value value = new Referenced_Value(reference);
                value.setMyScope(this.getMyScope());
                value.setFullNameParent(this);
                referenceChain.markState();
                value.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
                break;
            }
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                Referenced_Template template = new Referenced_Template(this.reference1);
                template.setMyScope(this.getMyScope());
                template.setFullNameParent(this);
                referenceChain.markState();
                template.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
                break;
            }
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            this.checkRecursionHelper(timestamp, this.reference1, referenceChain);
            this.checkRecursionHelper(timestamp, this.reference2, referenceChain);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference1 != null) {
            this.reference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference1.getLocation());
        }
        if (this.reference2 != null) {
            this.reference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference1 != null) {
            this.reference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.reference2 != null) {
            this.reference2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.reference1 != null && !this.reference1.accept(v)) {
            return false;
        }
        return this.reference2 == null || this.reference2.accept(v);
    }
}

