/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.Value_Assignment;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Referenced_Value
extends Value {
    private static final String UNEXPECTEDCALL1 = "Reference to a value or template was expected instead of a call of {0}, which does not have a return type";
    private static final String UNEXPECTEDCALL2 = "Reference to a value was expected instead of a call of {0}, which does not have a return type";
    private static final String UNEXPECTEDASSIGNMENT1 = "Reference to a value or template was expected instead of {0}";
    private static final String UNEXPECTEDASSIGNMENT2 = "Reference to a value was expected instead of {0}";
    private static final String INFORMATIONFROMOBJECTNOTVALUE = "InformationFromObjects construct `{0}'' does not refer to a value";
    private static final String VALUERETURNEXPECTED = "Reference to a value was expected instead of a call of {0}, which does not have a return type";
    private final Reference reference;
    private IValue referencedValue;

    public Referenced_Value(Reference reference) {
        this.reference = reference;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    protected Referenced_Value(Undefined_LowerIdentifier_Value original) {
        this.copyGeneralProperties(original);
        ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
        subReferences.add(new FieldSubReference(original.getIdentifier()));
        this.reference = new Reference(null, subReferences);
        this.reference.setMyScope(this.myScope);
        this.reference.setLocation(original.getIdentifier().getLocation());
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.REFERENCED_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        if (this.referencedValue != null && this.referencedValue != this) {
            return this.referencedValue.createStringRepresentation();
        }
        return this.reference.getDisplayName();
    }

    @Override
    public Location getLocation() {
        return new Location(this.reference.getLocation());
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType temporalType = this.getExpressionGovernor(timestamp, expectedValue);
        if (temporalType == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (temporalType.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
        }
        return temporalType.getTypeRefdLast(timestamp).getTypetypeTtcn3();
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        Assignment ass = this.reference.getRefdAssignment(timestamp, false);
        if (ass == null) {
            return true;
        }
        switch (ass.getAssignmentType()) {
            case A_OBJECT: 
            case A_OS: 
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                break;
            }
            default: {
                return true;
            }
        }
        IValue last = this.getValueRefdLast(timestamp, expectedValue, referenceChain);
        if (last == this || last == null) {
            return true;
        }
        return last.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IValue result = this.getValueRefdLast(timestamp, refChain);
        if (result != null && result != this) {
            if ((result = result.getReferencedSubValue(timestamp, reference, actualSubReference, refChain)) != null && result.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            }
            return result;
        }
        return this;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        IValue temp;
        if (IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)newType) && (temp = this.getValueRefdLast(timestamp, null)) != null && IValue.Value_type.CHARSTRING_VALUE.equals((Object)temp.getValuetype())) {
            return new UniversalCharstring_Value((Charstring_Value)temp);
        }
        return super.setValuetype(timestamp, newType);
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.referencedValue;
        }
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        this.referencedValue = this;
        this.isErroneous = false;
        if (this.reference == null) {
            return this.referencedValue;
        }
        this.reference.setIsErroneous(false);
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass == null) {
            this.isErroneous = true;
            return this.referencedValue;
        }
        switch (ass.getAssignmentType()) {
            case A_OBJECT: 
            case A_OS: {
                ISetting setting = this.reference.getRefdSetting(timestamp);
                if (setting == null || setting.getIsErroneous(timestamp)) {
                    this.isErroneous = true;
                    break;
                }
                if (!ISetting.Setting_type.S_V.equals((Object)setting.getSettingtype())) {
                    this.reference.getLocation().reportSemanticError(MessageFormat.format(INFORMATIONFROMOBJECTNOTVALUE, this.reference));
                    this.isErroneous = true;
                    break;
                }
                tempReferenceChain.markState();
                if (tempReferenceChain.add(this)) {
                    this.referencedValue = ((IValue)setting).getValueRefdLast(timestamp, expectedValue, referenceChain);
                } else {
                    this.isErroneous = true;
                }
                tempReferenceChain.previousState();
                break;
            }
            case A_CONST: {
                tempReferenceChain.markState();
                if (tempReferenceChain.add(this)) {
                    if (ass instanceof Def_Const) {
                        this.referencedValue = ((Def_Const)ass).getValue();
                    } else if (ass instanceof Value_Assignment) {
                        this.referencedValue = ((Value_Assignment)ass).getValue();
                    } else {
                        this.isErroneous = true;
                    }
                    if (this.referencedValue == null || this.isErroneous) {
                        this.referencedValue = this;
                        tempReferenceChain.previousState();
                        return this.referencedValue;
                    }
                    this.referencedValue = this.referencedValue.getReferencedSubValue(timestamp, this.reference, 1, tempReferenceChain);
                    if (this.referencedValue != null) {
                        this.referencedValue = this.referencedValue.getValueRefdLast(timestamp, tempReferenceChain);
                    } else {
                        if (this.reference.hasUnfoldableIndexSubReference(timestamp)) {
                            this.referencedValue = this;
                            tempReferenceChain.previousState();
                            return this.referencedValue;
                        }
                        if (this.reference.getUsedInIsbound()) {
                            this.referencedValue = this;
                            tempReferenceChain.previousState();
                            return this.referencedValue;
                        }
                        this.isErroneous = true;
                    }
                } else {
                    this.isErroneous = true;
                }
                tempReferenceChain.previousState();
                break;
            }
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RTEMP: 
            case A_MODULEPAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_INOUT: 
            case A_PAR_TEMP_OUT: 
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: {
                this.referencedValue = this;
                break;
            }
            case A_FUNCTION: 
            case A_EXT_FUNCTION: {
                this.reference.getLocation().reportSemanticError(MessageFormat.format("Reference to a value was expected instead of a call of {0}, which does not have a return type", ass.getDescription()));
                this.isErroneous = true;
                break;
            }
            default: {
                if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) {
                    this.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDASSIGNMENT1, ass.getDescription()));
                } else {
                    this.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDASSIGNMENT2, ass.getDescription()));
                }
                this.isErroneous = true;
            }
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        this.lastTimeChecked = timestamp;
        if (this.referencedValue == null) {
            this.referencedValue = this;
            this.isErroneous = true;
        }
        return this.referencedValue;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        this.reference.setIsErroneous(false);
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass == null) {
            this.setIsErroneous(true);
            return null;
        }
        IType temporalType = null;
        switch (ass.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RTEMP: 
            case A_MODULEPAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_INOUT: 
            case A_PAR_TEMP_OUT: 
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: {
                temporalType = ass.getType(timestamp);
                break;
            }
            case A_FUNCTION: 
            case A_EXT_FUNCTION: {
                if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) {
                    this.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDCALL1, ass.getDescription()));
                } else {
                    this.getLocation().reportSemanticError(MessageFormat.format("Reference to a value was expected instead of a call of {0}, which does not have a return type", ass.getDescription()));
                }
                this.setIsErroneous(true);
                return null;
            }
            default: {
                if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) {
                    this.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDASSIGNMENT1, ass.getDescription()));
                } else {
                    this.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDASSIGNMENT2, ass.getDescription()));
                }
                this.setIsErroneous(true);
                return null;
            }
        }
        if (temporalType == null) {
            this.setIsErroneous(true);
            return null;
        }
        if ((temporalType = temporalType.getFieldType(timestamp, this.reference, 1, expectedValue, false)) == null || this.reference.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return null;
        }
        return temporalType;
    }

    @Override
    public void checkExpressionOmitComparison(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        ArrayList<ISubReference> subreferences = new ArrayList<ISubReference>();
        subreferences.addAll(this.reference.getSubreferences());
        if (subreferences.size() <= 1) {
            return;
        }
        ISubReference subreference = (ISubReference)subreferences.remove(subreferences.size() - 1);
        Identifier id = subreference.getId();
        if (id == null) {
            this.getLocation().reportSemanticError("Only a reference pointing to an optional record or set field can be compared with `omit'");
            this.setIsErroneous(true);
            return;
        }
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return;
        }
        IType type = assignment.getType(timestamp);
        if (type == null) {
            this.setIsErroneous(true);
            return;
        }
        Reference tempReference = new Reference(null, subreferences);
        tempReference.setFullNameParent(this);
        tempReference.setMyScope(this.myScope);
        type = type.getFieldType(timestamp, tempReference, 1, expectedValue, false);
        if (type == null) {
            this.setIsErroneous(true);
            return;
        }
        if ((type = type.getTypeRefdLast(timestamp)) == null || type.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return;
        }
        switch (type.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                if (!((ASN1_Sequence_Type)type).hasComponentWithName(id)) {
                    this.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' does not have field named `{1}''", type.getTypename(), id.getDisplayName()));
                    this.setIsErroneous(true);
                    break;
                }
                if (((ASN1_Sequence_Type)type).getComponentByName(id).isOptional()) break;
                this.getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is mandatory in type`{1}''. It cannot be compared with `omit''", id.getDisplayName(), type.getTypename()));
                this.setIsErroneous(true);
                break;
            }
            case TYPE_TTCN3_SEQUENCE: {
                if (!((TTCN3_Sequence_Type)type).hasComponentWithName(id.getName())) {
                    this.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' does not have field named `{1}''", type.getTypename(), id.getDisplayName()));
                    this.setIsErroneous(true);
                    break;
                }
                if (((TTCN3_Sequence_Type)type).getComponentByName(id.getName()).isOptional()) break;
                this.getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is mandatory in type`{1}''. It cannot be compared with `omit''", id.getDisplayName(), type.getTypename()));
                this.setIsErroneous(true);
                break;
            }
            case TYPE_ASN1_SET: {
                if (!((ASN1_Set_Type)type).hasComponentWithName(id)) {
                    this.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' does not have field named `{1}''", type.getTypename(), id.getDisplayName()));
                    this.setIsErroneous(true);
                    break;
                }
                if (((ASN1_Set_Type)type).getComponentByName(id).isOptional()) break;
                this.getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is mandatory in type`{1}''. It cannot be compared with `omit''", id.getDisplayName(), type.getTypename()));
                this.setIsErroneous(true);
                break;
            }
            case TYPE_TTCN3_SET: {
                if (!((TTCN3_Set_Type)type).hasComponentWithName(id.getName())) {
                    this.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' does not have field named `{1}''", type.getTypename(), id.getDisplayName()));
                    this.setIsErroneous(true);
                    break;
                }
                if (((TTCN3_Set_Type)type).getComponentByName(id.getName()).isOptional()) break;
                this.getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is mandatory in type`{1}''. It cannot be compared with `omit''", id.getDisplayName(), type.getTypename()));
                this.setIsErroneous(true);
                break;
            }
            default: {
                this.getLocation().reportSemanticError("Only a reference pointing to an optional record or set field can be compared with `omit'");
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        if (this.lastTimeChecked == null) {
            this.getValueRefdLast(timestamp, null);
        }
        if (this.referencedValue == null) {
            return false;
        }
        if (this.referencedValue == this) {
            return true;
        }
        return this.referencedValue.checkEquality(timestamp, other);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        if (last == this) {
            return false;
        }
        return last.evaluateIsvalue(false);
    }

    @Override
    public boolean evaluateIsbound(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        if (last == this) {
            return false;
        }
        return last.evaluateIsbound(timestamp, reference, actualSubReference);
    }

    @Override
    public boolean evaluateIspresent(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        if (last == this) {
            return false;
        }
        return last.evaluateIspresent(timestamp, reference, actualSubReference);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference == null) {
            return;
        }
        this.reference.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.reference == null || this.reference.accept(v);
    }
}

