/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Macro_Value
extends Value {
    private static final String TESCASEIDINCONTROLPART = "Macro %testcaseId cannot be used in the control part. It is allowed only within the statement blocks of function, altsteps and testcases";
    private static final String TESTCASEIDNOTALLOWED = "Usage of macro %testcaseId is allowed only within the statement blocks of function, altsteps and testcases";
    private static final String UNDETERMINABLEPATH = "The path can not be determined";
    private static final String UNDETERMINABLESCOPE = "The value of the __SCOPE__ can not be determined";
    private final Macro_type value;

    public Macro_Value(Macro_type value) {
        this.value = value;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.MACRO_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        switch (this.value) {
            case MODULEID: {
                return "%moduleId";
            }
            case FILENAME: {
                return "%fileName";
            }
            case BFILENAME: {
                return "__BFILE__";
            }
            case FILEPATH: {
                return "__FILE__";
            }
            case LINENUMBER: {
                return "%lineNumber";
            }
            case LINENUMBER_C: {
                return "__LINE__";
            }
            case DEFINITIONID: {
                return "%definitionId";
            }
            case SCOPE: {
                return "__SCOPE__";
            }
            case TESTCASEID: {
                return "%testcaseId";
            }
        }
        return "<unknown macro>";
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.value == null) {
            return IType.Type_type.TYPE_CHARSTRING;
        }
        switch (this.value) {
            case LINENUMBER_C: {
                return IType.Type_type.TYPE_INTEGER;
            }
        }
        return IType.Type_type.TYPE_CHARSTRING;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.MACRO_VALUE.equals((Object)last.getValuetype()) && this.value.equals((Object)((Macro_Value)last).value);
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IValue result = this.getValueRefdLast(timestamp, refChain);
        if (result != null && result != this && (result = result.getReferencedSubValue(timestamp, reference, actualSubReference, refChain)) != null && result.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
        }
        return this;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return Macro_type.TESTCASEID.equals((Object)this.value);
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return this.evaluateMacro(expectedValue);
    }

    private IValue evaluateMacro(Expected_Value_type expectedValue) {
        Value lastValue = this;
        switch (this.value) {
            case MODULEID: {
                Module module;
                if (this.myScope == null || this.myScope.getModuleScope() == null || (module = this.myScope.getModuleScope()).getIdentifier() == null) break;
                lastValue = new Charstring_Value(module.getIdentifier().getDisplayName());
                lastValue.copyGeneralProperties(this);
                break;
            }
            case DEFINITIONID: {
                if (this.myScope != null) {
                    Definition definition;
                    StatementBlock block = this.myScope.getStatementBlockScope();
                    if (block == null || (definition = block.getMyDefinition()) == null) break;
                    lastValue = new Charstring_Value(definition.getIdentifier().getDisplayName());
                    lastValue.copyGeneralProperties(this);
                    break;
                }
                this.setIsErroneous(true);
                break;
            }
            case TESTCASEID: {
                if (this.myScope != null) {
                    StatementBlock block = this.myScope.getStatementBlockScope();
                    if (block != null) {
                        Definition definition = block.getMyDefinition();
                        if (definition == null) {
                            this.location.reportSemanticError(TESCASEIDINCONTROLPART);
                            this.setIsErroneous(true);
                            break;
                        }
                        if (!Assignment.Assignment_type.A_TESTCASE.equals(definition.getAssignmentType())) break;
                        lastValue = new Charstring_Value(definition.getIdentifier().getDisplayName());
                        lastValue.copyGeneralProperties(this);
                        break;
                    }
                    this.location.reportSemanticError(TESTCASEIDNOTALLOWED);
                    this.setIsErroneous(true);
                    break;
                }
                this.setIsErroneous(true);
                break;
            }
            case FILENAME: 
            case BFILENAME: {
                if (NULL_Location.INSTANCE.equals(this.location)) {
                    this.setIsErroneous(true);
                    break;
                }
                lastValue = new Charstring_Value(this.location.getFile().getName());
                lastValue.copyGeneralProperties(this);
                break;
            }
            case FILEPATH: {
                String canonicalPath;
                if (NULL_Location.INSTANCE.equals(this.location)) {
                    this.setIsErroneous(true);
                    break;
                }
                IPath absolutePath = this.location.getFile().getLocation();
                if (absolutePath == null) {
                    this.location.reportSemanticError(UNDETERMINABLEPATH);
                    canonicalPath = this.location.getFile().getName();
                    this.setIsErroneous(true);
                } else {
                    File file = absolutePath.toFile();
                    try {
                        canonicalPath = file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        this.location.reportSemanticError(UNDETERMINABLEPATH);
                        canonicalPath = this.location.getFile().getName();
                        this.setIsErroneous(true);
                    }
                }
                lastValue = new Charstring_Value(canonicalPath);
                lastValue.copyGeneralProperties(this);
                break;
            }
            case LINENUMBER: {
                if (NULL_Location.INSTANCE.equals(this.location)) {
                    this.setIsErroneous(true);
                    break;
                }
                lastValue = new Charstring_Value(Long.toString(this.location.getLine()));
                lastValue.copyGeneralProperties(this);
                break;
            }
            case LINENUMBER_C: {
                if (NULL_Location.INSTANCE.equals(this.location)) {
                    this.setIsErroneous(true);
                    break;
                }
                lastValue = new Integer_Value(this.location.getLine());
                lastValue.copyGeneralProperties(this);
                break;
            }
            case SCOPE: {
                if (this.myScope != null) {
                    lastValue = new Charstring_Value(this.myScope.getScopeMacroName());
                    lastValue.copyGeneralProperties(this);
                    break;
                }
                this.location.reportSemanticError(UNDETERMINABLESCOPE);
                this.setIsErroneous(true);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    public static enum Macro_type {
        MODULEID,
        SCOPE,
        DEFINITIONID,
        TESTCASEID,
        FILENAME,
        BFILENAME,
        FILEPATH,
        LINENUMBER,
        LINENUMBER_C;

    }
}

