/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.IndexedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Values;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Array_Value
extends Value {
    private static final String NOINDEX = "There is no value assigned to index {0} in the value `{1}''";
    private final Values values;

    protected Array_Value(SequenceOf_Value original) {
        this.copyGeneralProperties(original);
        this.values = original.getValues();
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.ARRAY_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("{");
        if (this.isIndexed()) {
            for (int i = 0; i < this.values.getNofIndexedValues(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                Value indexedValue = this.values.getIndexedValueByIndex(i).getIndex().getValue();
                builder.append(indexedValue.createStringRepresentation());
            }
        } else {
            for (int i = 0; i < this.values.getNofValues(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                IValue indexedValue = this.values.getValueByIndex(i);
                builder.append(indexedValue.createStringRepresentation());
            }
        }
        builder.append('}');
        return builder.toString();
    }

    public boolean isIndexed() {
        return this.values.isIndexed();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp) || !IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, refChain);
                if (valueIndex.isUnfoldable(timestamp)) {
                    return null;
                }
                if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                    int index = ((Integer_Value)valueIndex).intValue();
                    ArrayDimension dimension = ((Array_Type)type).getDimension();
                    dimension.checkIndex(timestamp, valueIndex, Expected_Value_type.EXPECTED_CONSTANT);
                    if (dimension.getIsErroneous(timestamp)) {
                        return null;
                    }
                    if (this.isIndexed()) {
                        for (int i = 0; i < this.values.getNofIndexedValues(); ++i) {
                            IValue indexedValue = this.values.getIndexedValueByIndex(i).getIndex().getValue();
                            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)(indexedValue = indexedValue.getValueRefdLast(timestamp, refChain)).getValuetype()) || ((Integer_Value)indexedValue).intValue() != index) continue;
                            return this.values.getIndexedValueByIndex(i).getValue().getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                        }
                        arrayIndex.getLocation().reportSemanticError(MessageFormat.format(NOINDEX, index, this.values.getFullName()));
                    } else if (index >= 0 && index < this.values.getNofValues()) {
                        return this.values.getValueByIndex(index).getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                    }
                    return null;
                }
                arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.values.isIndexed()) {
            int size = this.values.getNofIndexedValues();
            for (int i = 0; i < size; ++i) {
                if (!this.values.getIndexedValueByIndex(i).isUnfoldable(timestamp, expectedValue, referenceChain)) continue;
                return true;
            }
        } else {
            int size = this.values.getNofValues();
            for (int i = 0; i < size; ++i) {
                if (!this.values.getValueByIndex(i).isUnfoldable(timestamp, expectedValue, referenceChain)) continue;
                return true;
            }
        }
        return false;
    }

    public int getNofComponents() {
        if (this.values.isIndexed()) {
            return this.values.getNofIndexedValues();
        }
        return this.values.getNofValues();
    }

    public IValue getValueByIndex(int index) {
        if (this.values.isIndexed()) {
            return this.values.getIndexedValueByIndex(index).getValue();
        }
        return this.values.getValueByIndex(index);
    }

    public Value getIndexByIndex(int index) {
        if (this.values.isIndexed()) {
            return this.values.getIndexedValueByIndex(index).getIndex().getValue();
        }
        return null;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.values != null) {
            this.values.setMyScope(scope);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        block4: {
            if (!referenceChain.add(this)) break block4;
            if (this.values.isIndexed()) {
                int size = this.values.getNofIndexedValues();
                for (int i = 0; i < size; ++i) {
                    referenceChain.markState();
                    this.values.getIndexedValueByIndex(i).getValue().checkRecursions(timestamp, referenceChain);
                    referenceChain.previousState();
                }
            } else {
                int size = this.values.getNofValues();
                for (int i = 0; i < size; ++i) {
                    referenceChain.markState();
                    this.values.getValueByIndex(i).checkRecursions(timestamp, referenceChain);
                    referenceChain.previousState();
                }
            }
        }
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (!IValue.Value_type.ARRAY_VALUE.equals((Object)last.getValuetype())) {
            return false;
        }
        Array_Value otherArray = (Array_Value)last;
        if (this.values.isIndexed()) {
            if (otherArray.isIndexed()) {
                if (this.values.getNofIndexedValues() != otherArray.values.getNofIndexedValues()) {
                    return false;
                }
                int size = this.values.getNofIndexedValues();
                for (int i = 0; i < size; ++i) {
                    IndexedValue localTemp = this.values.getIndexedValueByIndex(i);
                    Value indexValue = localTemp.getIndex().getValue();
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)indexValue.getValuetype())) {
                        Integer_Value integerValue = (Integer_Value)indexValue;
                        IValue otherValue = otherArray.values.getIndexedValueByRealIndex(integerValue.intValue());
                        if (otherValue != null && localTemp.getValue().checkEquality(timestamp, otherValue)) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                if (this.values.getNofIndexedValues() != otherArray.values.getNofValues()) {
                    return false;
                }
                int size = otherArray.values.getNofValues();
                for (int i = 0; i < size; ++i) {
                    IValue value = this.values.getIndexedValueByRealIndex(i);
                    if (value != null && otherArray.values.getValueByIndex(i).checkEquality(timestamp, value)) continue;
                    return false;
                }
            }
        } else if (otherArray.isIndexed()) {
            if (this.values.getNofValues() != otherArray.values.getNofIndexedValues()) {
                return false;
            }
            int size = this.values.getNofValues();
            for (int i = 0; i < size; ++i) {
                IValue otherValue = otherArray.values.getIndexedValueByRealIndex(i);
                if (otherValue != null && this.values.getValueByIndex(i).checkEquality(timestamp, otherValue)) continue;
                return false;
            }
        } else {
            if (this.values.getNofValues() != otherArray.values.getNofValues()) {
                return false;
            }
            int size = this.values.getNofValues();
            for (int i = 0; i < size; ++i) {
                if (this.values.getValueByIndex(i).checkEquality(timestamp, otherArray.values.getValueByIndex(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.values != null) {
            this.values.updateSyntax(reparser, false);
        }
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        if (this.values == null) {
            return true;
        }
        int size = this.values.getNofValues();
        for (int i = 0; i < size; ++i) {
            if (this.values.getValueByIndex(i).evaluateIsvalue(false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluateIsbound(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp) || !IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (valueIndex.isUnfoldable(timestamp)) {
                    return false;
                }
                if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                    int index = ((Integer_Value)valueIndex).intValue();
                    if (this.isIndexed()) {
                        for (int i = 0; i < this.values.getNofIndexedValues(); ++i) {
                            IValue indexedValue = this.values.getIndexedValueByIndex(i).getIndex().getValue();
                            referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            indexedValue = indexedValue.getValueRefdLast(timestamp, referenceChain);
                            referenceChain.release();
                            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)indexedValue.getValuetype()) || ((Integer_Value)indexedValue).intValue() != index) continue;
                            return this.values.getIndexedValueByIndex(i).getValue().evaluateIsbound(timestamp, reference, actualSubReference + 1);
                        }
                        arrayIndex.getLocation().reportSemanticError(MessageFormat.format(NOINDEX, index, this.values.getFullName()));
                    } else if (index >= 0 && index < this.values.getNofValues()) {
                        return this.values.getValueByIndex(index).evaluateIsbound(timestamp, reference, actualSubReference + 1);
                    }
                    return false;
                }
                return false;
            }
            case fieldSubReference: {
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean evaluateIspresent(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp) || !IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (valueIndex.isUnfoldable(timestamp)) {
                    return false;
                }
                if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                    int index = ((Integer_Value)valueIndex).intValue();
                    if (this.isIndexed()) {
                        for (int i = 0; i < this.values.getNofIndexedValues(); ++i) {
                            IValue indexedValue = this.values.getIndexedValueByIndex(i).getIndex().getValue();
                            referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            indexedValue = indexedValue.getValueRefdLast(timestamp, referenceChain);
                            referenceChain.release();
                            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)indexedValue.getValuetype()) || ((Integer_Value)indexedValue).intValue() != index) continue;
                            return this.values.getIndexedValueByIndex(i).getValue().evaluateIspresent(timestamp, reference, actualSubReference + 1);
                        }
                        arrayIndex.getLocation().reportSemanticError(MessageFormat.format(NOINDEX, index, this.values.getFullName()));
                    } else if (index >= 0 && index < this.values.getNofValues()) {
                        return this.values.getValueByIndex(index).evaluateIspresent(timestamp, reference, actualSubReference + 1);
                    }
                    return false;
                }
                return false;
            }
            case fieldSubReference: {
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.values == null) {
            return;
        }
        this.values.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.values == null || this.values.accept(v);
    }
}

