/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.CharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.UnivCharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueRange;
import org.eclipse.titan.designer.AST.TTCN3.templates.Value_Range_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class UniversalCharstring_Type
extends Type {
    private static final String CHARSTRINGVALUEEXPECTED = "Universal character string value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `{1}''";
    private static final String INCORRECTBOUNDARIES = "The lower boundary is higher than the upper boundary";
    private static final String INFINITEBOUNDARYERROR = "The {0} boundary must be a universalcharstring value";
    private static final String TOOLONGBOUNDARYERROR = "The {0} boundary must be a universalcharstring value containing a single character.";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_UCHARSTRING;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("universalcharstring");
    }

    @Override
    public String getOutlineIcon() {
        return "universal_charstring.gif";
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        switch (temp.getTypetype()) {
            case TYPE_UCHARSTRING: 
            case TYPE_UTF8STRING: 
            case TYPE_BMPSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_OBJECTDESCRIPTOR: 
            case TYPE_GENERALSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_NUMERICSTRING: 
            case TYPE_PRINTABLESTRING: 
            case TYPE_IA5STRING: 
            case TYPE_VISIBLESTRING: 
            case TYPE_UTCTIME: 
            case TYPE_GENERALIZEDTIME: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "universal charstring";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_UNIVERSAL_CHARSTRING;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.parseAttributes(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.CHARSYMBOLS_VALUE);
                if (last.getIsErroneous(timestamp)) {
                    return;
                }
                last = last.setValuetype(timestamp, IValue.Value_type.UNIVERSALCHARSTRING_VALUE);
                break;
            }
            case CHARSYMBOLS_VALUE: 
            case CHARSTRING_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.UNIVERSALCHARSTRING_VALUE);
                break;
            }
            case ISO2022STRING_VALUE: {
                this.location.reportSemanticError("ISO-10646 string value cannot be converted to ISO-2022 string");
                this.setIsErroneous(true);
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(CHARSTRINGVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        UniversalCharstring_Type.checkThisTemplateString(timestamp, this, template, isModified);
    }

    public static void checkThisTemplateString(CompilationTimeStamp timestamp, Type type, ITTCN3Template template, boolean isModified) {
        template.setMyGovernor(type);
        PatternString ps = null;
        switch (template.getTemplatetype()) {
            case VALUE_RANGE: {
                UniversalCharstring value2;
                UniversalCharstring value1;
                ValueRange range = ((Value_Range_Template)template).getValueRange();
                IValue lower = UniversalCharstring_Type.checkBoundary(timestamp, type, range.getMin(), template, "lower");
                IValue upper = UniversalCharstring_Type.checkBoundary(timestamp, type, range.getMax(), template, "upper");
                if (lower == null || upper == null || (value1 = IValue.Value_type.CHARSTRING_VALUE.equals((Object)lower.getValuetype()) ? new UniversalCharstring(((Charstring_Value)lower).getValue()) : ((UniversalCharstring_Value)lower).getValue()).compareWith(value2 = IValue.Value_type.CHARSTRING_VALUE.equals((Object)upper.getValuetype()) ? new UniversalCharstring(((Charstring_Value)upper).getValue()) : ((UniversalCharstring_Value)upper).getValue()) <= 0) break;
                template.getLocation().reportSemanticError(INCORRECTBOUNDARIES);
                break;
            }
            case CSTR_PATTERN: {
                CharString_Pattern_Template cstrpt = (CharString_Pattern_Template)template;
                ps = cstrpt.getPatternstring();
                ps.setPatterntype(PatternString.PatternType.UNIVCHARSTRING_PATTERN);
                break;
            }
            case USTR_PATTERN: {
                ps = ((UnivCharString_Pattern_Template)template).getPatternstring();
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), type.getTypename()));
            }
        }
    }

    private static IValue checkBoundary(CompilationTimeStamp timestamp, Type type, Value value, ITTCN3Template template, String which) {
        if (value == null) {
            template.getLocation().reportSemanticError(MessageFormat.format(INFINITEBOUNDARYERROR, which));
            return null;
        }
        value.setMyGovernor(type);
        IValue temp = type.checkThisValueRef(timestamp, value);
        type.checkThisValue(timestamp, temp, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
        temp = temp.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        switch (temp.getValuetype()) {
            case CHARSTRING_VALUE: {
                if (((Charstring_Value)temp).getValueLength() == 1) break;
                value.getLocation().reportSemanticError(MessageFormat.format(TOOLONGBOUNDARYERROR, which));
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                if (((UniversalCharstring_Value)temp).getValueLength() == 1) break;
                value.getLocation().reportSemanticError(MessageFormat.format(TOOLONGBOUNDARYERROR, which));
                break;
            }
            default: {
                temp = null;
            }
        }
        return temp;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                if (subreferences.size() > actualSubReference + 1) {
                    subreference.getLocation().reportSemanticError("A string element cannot be indexed");
                    return null;
                }
                if (subreferences.size() == actualSubReference + 1) {
                    reference.setStringElementReferencing();
                }
                return this;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() == i + 1) {
            declarationCollector.addDeclaration("universalcharstring", this.location, this);
        }
    }
}

