/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class TemplateInstances
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final List<TemplateInstance> instances;
    private Location location;

    public TemplateInstances() {
        this.instances = new ArrayList<TemplateInstance>();
        this.location = NULL_Location.INSTANCE;
    }

    public TemplateInstances(TemplateInstances other) {
        this.instances = new ArrayList<TemplateInstance>(other.instances.size());
        int size = other.instances.size();
        for (int i = 0; i < size; ++i) {
            this.instances.add(other.instances.get(i));
        }
        this.location = other.location;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.instances.size();
        for (int i = 0; i < size; ++i) {
            this.instances.get(i).setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.instances.size();
        for (int i = 0; i < size; ++i) {
            if (this.instances.get(i) != child) continue;
            return builder.append("[").append(String.valueOf(i + 1)).append("]");
        }
        return builder;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addTemplateInstance(TemplateInstance instance) {
        if (instance != null) {
            this.instances.add(instance);
            instance.setFullNameParent(this);
        }
    }

    public int getNofTis() {
        return this.instances.size();
    }

    public TemplateInstance getInstanceByIndex(int index) {
        return this.instances.get(index);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.instances.size();
        for (int i = 0; i < size; ++i) {
            TemplateInstance instance = this.instances.get(i);
            instance.updateSyntax(reparser, false);
            reparser.updateLocation(instance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.instances == null) {
            return;
        }
        for (TemplateInstance ti : this.instances) {
            ti.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.instances != null) {
            for (TemplateInstance ti : this.instances) {
                if (ti.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public String createStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        for (TemplateInstance ti : this.instances) {
            sb.append(ti.createStringRepresentation() + ", ");
        }
        if (!this.instances.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }
}

