/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.LengthRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeFactory;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class TTCN3Template
extends GovernedSimple
implements IReferenceChainElement,
ITTCN3Template,
IIncrementallyUpdateable {
    protected static final String RESTRICTIONERROR = "Restriction on {0} does not allow usage of `{1}''";
    protected static final String OMITRESTRICTIONERROR = "Restriction 'omit' on {0} does not allow usage of `{1}''";
    protected static final String VALUERESTRICTIONERROR = "Restriction ''value'' on {0} does not allow usage of {1}";
    protected static final String PRESENTRESTRICTIONERROR = "Restriction ''present'' on {0} does not allow usage of `{1}''";
    private static final String LENGTHRESTRICTIONERROR = "Restriction on {0} does not allow usage of length restriction";
    protected IType myGovernor;
    protected LengthRestriction lengthRestriction;
    protected boolean isIfpresent;
    protected boolean specificValueChecked;
    protected ITTCN3Template baseTemplate;

    @Override
    public ISetting.Setting_type getSettingtype() {
        return ISetting.Setting_type.S_TEMPLATE;
    }

    @Override
    public final void copyGeneralProperties(ITTCN3Template original) {
        this.location = original.getLocation();
        super.setFullNameParent(original.getNameParent());
        this.myGovernor = original.getMyGovernor();
        this.myScope = original.getMyScope();
    }

    @Override
    public abstract ITTCN3Template.Template_type getTemplatetype();

    @Override
    public abstract String getTemplateTypeName();

    @Override
    public final IType getMyGovernor() {
        return this.myGovernor;
    }

    @Override
    public final void setMyGovernor(IType governor) {
        this.myGovernor = governor;
    }

    @Override
    public String chainedDescription() {
        return "template reference: " + this.getFullName();
    }

    @Override
    public final Location getChainLocation() {
        return this.getLocation();
    }

    @Override
    public abstract String createStringRepresentation();

    @Override
    public ITTCN3Template setLoweridToReference(CompilationTimeStamp timestamp) {
        return this;
    }

    @Override
    public final void setLengthRestriction(LengthRestriction lengthRestriction) {
        if (lengthRestriction != null) {
            this.lengthRestriction = lengthRestriction;
        }
    }

    @Override
    public final LengthRestriction getLengthRestriction() {
        return this.lengthRestriction;
    }

    @Override
    public final void setIfpresent() {
        this.isIfpresent = true;
    }

    @Override
    public final ITTCN3Template getBaseTemplate() {
        return this.baseTemplate;
    }

    @Override
    public final void setBaseTemplate(ITTCN3Template baseTemplate) {
        this.baseTemplate = baseTemplate;
    }

    @Override
    public final ITTCN3Template.Completeness_type getCompletenessConditionSeof(CompilationTimeStamp timestamp, boolean incompleteAllowed) {
        if (!incompleteAllowed) {
            return ITTCN3Template.Completeness_type.MUST_COMPLETE;
        }
        if (this.baseTemplate == null) {
            return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
        }
        TTCN3Template temp = this.baseTemplate.getTemplateReferencedLast(timestamp);
        if (temp.getIsErroneous(timestamp)) {
            return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
        }
        switch (temp.getTemplatetype()) {
            case TEMPLATE_NOTUSED: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: 
            case TEMPLATE_REFD: 
            case TEMPLATE_INVOKE: 
            case NAMED_TEMPLATE_LIST: 
            case INDEXED_TEMPLATE_LIST: {
                return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
            }
            case TEMPLATE_LIST: {
                if (this.myGovernor == null) {
                    return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
                }
                IType type = this.myGovernor.getTypeRefdLast(timestamp);
                if (type == null) {
                    return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
                }
                switch (type.getTypetype()) {
                    case TYPE_SEQUENCE_OF: 
                    case TYPE_SET_OF: {
                        return ITTCN3Template.Completeness_type.PARTIAL;
                    }
                }
                return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
            }
        }
        return ITTCN3Template.Completeness_type.MUST_COMPLETE;
    }

    @Override
    public final ITTCN3Template.Completeness_type getCompletenessConditionChoice(CompilationTimeStamp timestamp, boolean incompleteAllowed, Identifier fieldName) {
        if (!incompleteAllowed) {
            return ITTCN3Template.Completeness_type.MUST_COMPLETE;
        }
        if (this.baseTemplate == null) {
            return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
        }
        TTCN3Template temp = this.baseTemplate.getTemplateReferencedLast(timestamp);
        if (temp.getIsErroneous(timestamp)) {
            return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
        }
        switch (temp.getTemplatetype()) {
            case TEMPLATE_NOTUSED: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: 
            case TEMPLATE_REFD: 
            case TEMPLATE_INVOKE: 
            case TEMPLATE_LIST: {
                return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
            }
            case NAMED_TEMPLATE_LIST: {
                if (((Named_Template_List)temp).hasNamedTemplate(fieldName)) {
                    return ITTCN3Template.Completeness_type.MAY_INCOMPLETE;
                }
                return ITTCN3Template.Completeness_type.MUST_COMPLETE;
            }
        }
        return ITTCN3Template.Completeness_type.MUST_COMPLETE;
    }

    @Override
    public final TTCN3Template getTemplateReferencedLast(CompilationTimeStamp timestamp) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        TTCN3Template result = this.getTemplateReferencedLast(timestamp, referenceChain);
        referenceChain.release();
        return result;
    }

    @Override
    public TTCN3Template getTemplateReferencedLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        return this;
    }

    @Override
    public TTCN3Template setTemplatetype(CompilationTimeStamp timestamp, ITTCN3Template.Template_type newType) {
        this.setIsErroneous(true);
        return this;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return TypeFactory.createType(this.getExpressionReturntype(timestamp, expectedValue));
    }

    @Override
    public abstract void checkRecursions(CompilationTimeStamp var1, IReferenceChain var2);

    @Override
    public abstract void checkSpecificValue(CompilationTimeStamp var1, boolean var2);

    private ITTCN3Template getRefdUnionFieldTemplate(Identifier fieldIdentifier, Reference reference, IType type) {
        if (!ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)this.getTemplatetype())) {
            return null;
        }
        Named_Template_List namedList = (Named_Template_List)this;
        if (namedList.getNofTemplates() != 1) {
            return null;
        }
        NamedTemplate namedTemplate = namedList.getTemplateByIndex(0);
        if (namedTemplate.getName().equals(fieldIdentifier)) {
            return namedTemplate.getTemplate();
        }
        if (!reference.getUsedInIsbound()) {
            String message = MessageFormat.format("Reference to inactive field `{0}'' in a template of union type `{1}''. The active field is `{2}''", fieldIdentifier.getDisplayName(), type.getTypename(), namedTemplate.getName().getDisplayName());
            reference.getLocation().reportSemanticError(message);
        }
        return null;
    }

    private ITTCN3Template getReferencedSetSequenceFieldTemplate(CompilationTimeStamp timestamp, Identifier fieldIdentifier, Reference reference, IReferenceChain referenceChain) {
        if (!ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)this.getTemplatetype())) {
            return null;
        }
        Named_Template_List namedList = (Named_Template_List)this;
        if (namedList.hasNamedTemplate(fieldIdentifier)) {
            return namedList.getNamedTemplate(fieldIdentifier).getTemplate();
        }
        if (this.baseTemplate != null) {
            TTCN3Template temp = this.baseTemplate.getTemplateReferencedLast(timestamp, referenceChain);
            if (temp == null) {
                return null;
            }
            return temp.getReferencedFieldTemplate(timestamp, fieldIdentifier, reference, referenceChain);
        }
        if (!reference.getUsedInIsbound()) {
            reference.getLocation().reportSemanticError(MessageFormat.format("Reference to unbound field `{0}''.", fieldIdentifier.getDisplayName()));
        }
        return null;
    }

    private ITTCN3Template getReferencedFieldTemplate(CompilationTimeStamp timestamp, Identifier fieldIdentifier, Reference reference, IReferenceChain referenceChain) {
        switch (this.getTemplatetype()) {
            case ANY_VALUE: 
            case ANY_OR_OMIT: 
            case OMIT_VALUE: 
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: 
            case SUBSET_MATCH: 
            case SUPERSET_MATCH: 
            case PERMUTATION_MATCH: 
            case BSTR_PATTERN: 
            case HSTR_PATTERN: 
            case OSTR_PATTERN: 
            case CSTR_PATTERN: 
            case USTR_PATTERN: {
                reference.getLocation().reportSemanticError(MessageFormat.format("Reference to field `{0}'' of {1} `{2}''", fieldIdentifier.getDisplayName(), this.getTemplateTypeName(), this.getFullName()));
                break;
            }
        }
        IType tempType = this.myGovernor.getTypeRefdLast(timestamp);
        if (tempType.getIsErroneous(timestamp)) {
            return null;
        }
        switch (tempType.getTypetype()) {
            case TYPE_ASN1_CHOICE: {
                if (!((ASN1_Choice_Type)tempType).hasComponentWithName(fieldIdentifier)) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent union field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getRefdUnionFieldTemplate(fieldIdentifier, reference, tempType);
            }
            case TYPE_TTCN3_CHOICE: {
                if (!((TTCN3_Choice_Type)tempType).hasComponentWithName(fieldIdentifier.getName())) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent union field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getRefdUnionFieldTemplate(fieldIdentifier, reference, tempType);
            }
            case TYPE_OPENTYPE: {
                if (!((Open_Type)tempType).hasComponentWithName(fieldIdentifier)) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent union field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getRefdUnionFieldTemplate(fieldIdentifier, reference, tempType);
            }
            case TYPE_ANYTYPE: {
                if (!((Anytype_Type)tempType).hasComponentWithName(fieldIdentifier.getName())) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent union field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getRefdUnionFieldTemplate(fieldIdentifier, reference, tempType);
            }
            case TYPE_ASN1_SEQUENCE: {
                if (!((ASN1_Sequence_Type)tempType).hasComponentWithName(fieldIdentifier)) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent record field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getReferencedSetSequenceFieldTemplate(timestamp, fieldIdentifier, reference, referenceChain);
            }
            case TYPE_TTCN3_SEQUENCE: {
                if (!((TTCN3_Sequence_Type)tempType).hasComponentWithName(fieldIdentifier.getName())) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent record field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getReferencedSetSequenceFieldTemplate(timestamp, fieldIdentifier, reference, referenceChain);
            }
            case TYPE_ASN1_SET: {
                if (!((ASN1_Set_Type)tempType).hasComponentWithName(fieldIdentifier)) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent set field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getReferencedSetSequenceFieldTemplate(timestamp, fieldIdentifier, reference, referenceChain);
            }
            case TYPE_TTCN3_SET: {
                if (!((TTCN3_Set_Type)tempType).hasComponentWithName(fieldIdentifier.getName())) {
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existent set field `{0}'' in type `{1}''", fieldIdentifier.getDisplayName(), tempType.getTypename()));
                    return null;
                }
                return this.getReferencedSetSequenceFieldTemplate(timestamp, fieldIdentifier, reference, referenceChain);
            }
        }
        reference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields", fieldIdentifier.getDisplayName(), tempType.getTypename()));
        return null;
    }

    protected ITTCN3Template getReferencedArrayTemplate(CompilationTimeStamp timestamp, IValue arrayIndex, IReferenceChain referenceChain) {
        switch (this.getTemplatetype()) {
            case ANY_VALUE: 
            case ANY_OR_OMIT: 
            case OMIT_VALUE: 
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: 
            case SUBSET_MATCH: 
            case SUPERSET_MATCH: {
                arrayIndex.getLocation().reportSemanticError(MessageFormat.format("Reference with index to an element of {0} `{1}''", this.getTemplateTypeName(), this.getFullName()));
                break;
            }
        }
        IValue indexValue = arrayIndex.setLoweridToReference(timestamp);
        indexValue = indexValue.getValueRefdLast(timestamp, referenceChain);
        if (indexValue.getIsErroneous(timestamp)) {
            return null;
        }
        long index = 0L;
        if (!indexValue.isUnfoldable(timestamp)) {
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)indexValue.getValuetype())) {
                arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                return null;
            }
        } else {
            return null;
        }
        index = ((Integer_Value)indexValue).getValue();
        IType tempType = this.myGovernor.getTypeRefdLast(timestamp);
        if (tempType.getIsErroneous(timestamp)) {
            return null;
        }
        switch (tempType.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                if (index < 0L) {
                    String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `sequence of'' type `{1}''", index, tempType.getTypename());
                    arrayIndex.getLocation().reportSemanticError(message);
                    return null;
                }
                if (!ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)this.getTemplatetype())) {
                    return null;
                }
                int nofElements = ((Template_List)this).getNofTemplates();
                if (index <= (long)nofElements) break;
                String message = MessageFormat.format("Index overflow in a template of `sequence of'' type `{0}'': the index is {1}, but the template has only {2} elements", tempType.getTypename(), index, nofElements);
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
            case TYPE_SET_OF: {
                if (index < 0L) {
                    String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `set of'' type `{1}''", index, tempType.getTypename());
                    arrayIndex.getLocation().reportSemanticError(message);
                    return null;
                }
                if (!ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)this.getTemplatetype())) {
                    return null;
                }
                int nofElements = ((Template_List)this).getNofTemplates();
                if (index <= (long)nofElements) break;
                String message = MessageFormat.format("Index overflow in a template of `set of'' type `{0}'': the index is {1}, but the template has only {2} elements", tempType.getTypename(), index, nofElements);
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
            case TYPE_ARRAY: {
                ArrayDimension dimension = ((Array_Type)tempType).getDimension();
                dimension.checkIndex(timestamp, indexValue, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)this.getTemplatetype()) && !dimension.getIsErroneous(timestamp)) {
                    if ((index -= dimension.getOffset()) >= 0L && index <= (long)((Template_List)this).getNofTemplates()) break;
                    arrayIndex.getLocation().reportSemanticError(MessageFormat.format("The index value {0} is outside the array indexable range", index + dimension.getOffset()));
                    return null;
                }
                return null;
            }
            default: {
                String message = MessageFormat.format("Invalid array element reference: type `{0}'' cannot be indexed", tempType.getTypename());
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
        }
        if (this instanceof Template_List) {
            ITemplateListItem returnValue = ((Template_List)this).getTemplateByIndex((int)index);
            if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)returnValue.getTemplatetype())) {
                if (this.baseTemplate != null) {
                    return this.baseTemplate.getTemplateReferencedLast(timestamp, referenceChain).getReferencedArrayTemplate(timestamp, indexValue, referenceChain);
                }
                return null;
            }
            return returnValue;
        }
        return null;
    }

    @Override
    public ITTCN3Template getReferencedSubTemplate(CompilationTimeStamp timestamp, Reference reference, IReferenceChain referenceChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        ITTCN3Template template = this;
        for (int i = 1; i < subreferences.size(); ++i) {
            ISubReference ref;
            if (template == null) {
                return template;
            }
            if ((template = template.getTemplateReferencedLast(timestamp, referenceChain)).getIsErroneous(timestamp)) {
                return template;
            }
            if (ITTCN3Template.Template_type.TEMPLATE_REFD.equals((Object)(template = template.setLoweridToReference(timestamp)).getTemplatetype())) {
                return null;
            }
            if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template.getTemplatetype())) {
                ((SpecificValue_Template)template).getValue().getReferencedSubValue(timestamp, reference, i, referenceChain);
            }
            if (ISubReference.Subreference_type.fieldSubReference.equals((Object)(ref = subreferences.get(i)).getReferenceType())) {
                template = ((TTCN3Template)template).getReferencedFieldTemplate(timestamp, ref.getId(), reference, referenceChain);
                continue;
            }
            if (ISubReference.Subreference_type.arraySubReference.equals((Object)ref.getReferenceType())) {
                template = ((TTCN3Template)template).getReferencedArrayTemplate(timestamp, ((ArraySubReference)ref).getValue(), referenceChain);
                continue;
            }
            return this;
        }
        return template;
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        return false;
    }

    @Override
    public IValue getValue() {
        return null;
    }

    protected void checkLengthRestriction(CompilationTimeStamp timestamp, IType type) {
        if (this.lengthRestriction == null) {
            return;
        }
        this.lengthRestriction.check(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type instanceof IReferencingType) {
            ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType last = ((IReferencingType)((Object)type)).getTypeRefd(timestamp, refChain);
            refChain.release();
            if (!last.getIsErroneous(timestamp)) {
                this.checkLengthRestriction(timestamp, last);
            }
            return;
        }
        if (type.getIsErroneous(timestamp)) {
            return;
        }
        IType.Type_type typeType = type.getTypetypeTtcn3();
        switch (typeType) {
            case TYPE_PORT: {
                return;
            }
            case TYPE_ARRAY: {
                this.lengthRestriction.checkArraySize(timestamp, ((Array_Type)type).getDimension());
                break;
            }
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                break;
            }
            default: {
                this.lengthRestriction.getLocation().reportSemanticError(MessageFormat.format("Length restriction cannot be used in template of type `{0}''", type.getTypename()));
                return;
            }
        }
        this.checkTemplateSpecificLengthRestriction(timestamp, typeType);
    }

    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        if (type == null) {
            return;
        }
        if (!this.getIsErroneous(timestamp)) {
            if (!ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)this.getTemplatetype())) {
                type.checkThisTemplate(timestamp, this, isModified, implicitOmit);
            }
            if (this.getLengthRestriction() != null) {
                this.checkLengthRestriction(timestamp, type);
            }
            if (!allowOmit && this.isIfpresent) {
                this.location.reportSemanticError("`ifpresent' is not allowed here");
            }
            if (subCheck) {
                type.checkThisTemplateSubtype(timestamp, this);
            }
        }
    }

    @Override
    public final void checkRestrictionCommon(CompilationTimeStamp timestamp, String definitionName, TemplateRestriction.Restriction_type templateRestriction, Location usageLocation) {
        switch (templateRestriction) {
            case TR_VALUE: {
                if (!this.isValue(timestamp)) {
                    usageLocation.reportSemanticError(MessageFormat.format(VALUERESTRICTIONERROR, definitionName, "this template"));
                }
            }
            case TR_OMIT: {
                if (this.lengthRestriction != null) {
                    usageLocation.reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONERROR, definitionName));
                }
                if (!this.isIfpresent) break;
                usageLocation.reportSemanticError(MessageFormat.format(RESTRICTIONERROR, definitionName, "ifpresent"));
                break;
            }
            case TR_PRESENT: {
                if (!this.isIfpresent && !this.getTemplateReferencedLast((CompilationTimeStamp)timestamp).isIfpresent) break;
                usageLocation.reportSemanticError(MessageFormat.format(PRESENTRESTRICTIONERROR, definitionName, "ifpresent"));
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        return false;
    }

    @Override
    public boolean chkRestrictionNamedListBaseTemplate(CompilationTimeStamp timestamp, String definitionName, Set<String> checkedNames, int neededCheckedCnt, Location usageLocation) {
        return false;
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.lengthRestriction == null) {
            return;
        }
        this.lengthRestriction.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.lengthRestriction == null || this.lengthRestriction.accept(v);
    }
}

