/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedParameters;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ParsedActualParameters
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private TemplateInstances unnamedPart;
    private NamedParameters namedPart;
    private FormalParameterList formalParList = null;
    private Location location = NULL_Location.INSTANCE;

    public void setFormalParList(FormalParameterList formalParList) {
        this.formalParList = formalParList;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.unnamedPart != null) {
            this.unnamedPart.setMyScope(scope);
        }
        if (this.namedPart != null) {
            this.namedPart.setMyScope(scope);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
        if (this.unnamedPart != null) {
            this.unnamedPart.setLocation(location);
        }
        if (this.namedPart != null) {
            this.namedPart.setLocation(location);
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addUnnamedParameter(TemplateInstance parameter) {
        if (this.unnamedPart == null) {
            this.unnamedPart = new TemplateInstances();
            this.unnamedPart.setFullNameParent(this);
        }
        this.unnamedPart.addTemplateInstance(parameter);
    }

    public TemplateInstances getInstances() {
        if (this.unnamedPart == null) {
            return new TemplateInstances();
        }
        return this.unnamedPart;
    }

    public void addNamedParameter(NamedParameter parameter) {
        if (this.namedPart == null) {
            this.namedPart = new NamedParameters();
            this.namedPart.setFullNameParent(this);
        }
        this.namedPart.addParameter(parameter);
    }

    public NamedParameters getNamedParameters() {
        if (this.namedPart == null) {
            return new NamedParameters();
        }
        return this.namedPart;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.unnamedPart != null) {
            this.unnamedPart.updateSyntax(reparser, false);
        }
        if (this.namedPart != null) {
            this.namedPart.updateSyntax(reparser, false);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.unnamedPart != null) {
            this.unnamedPart.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.namedPart != null) {
            if (this.formalParList != null) {
                for (int i = 0; i < this.namedPart.getNofParams(); ++i) {
                    Identifier parName = this.namedPart.getParamByIndex(i).getName();
                    FormalParameter fp = this.formalParList.getParameterById(parName);
                    if (fp != referenceFinder.assignment) continue;
                    foundIdentifiers.add(new ReferenceFinder.Hit(parName));
                }
            }
            this.namedPart.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.unnamedPart != null && !this.unnamedPart.accept(v)) {
            return false;
        }
        return this.namedPart == null || this.namedPart.accept(v);
    }

    public String createStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.unnamedPart != null) {
            sb.append(this.unnamedPart.createStringRepresentation());
        }
        if (this.namedPart != null) {
            if (this.namedPart.getNofParams() != 0) {
                sb.append(", ");
            }
            sb.append(this.namedPart.createStringRepresentation());
        }
        return sb.toString();
    }
}

