/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class OmitValue_Template
extends TTCN3Template {
    public static final String SPECIFICVALUEEXPECTED = "A specific value was expected instead of omit value";
    private static final String OMITNOTALLOWED = "`omit'' value is not allowed in this context";
    private static final String SIGNATUREERROR = "Generic wildcard `omit'' cannot be used for signature `{0}''";
    private Omit_Value asValue = null;

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.OMIT_VALUE;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous omit value";
        }
        return "omit value";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("omit");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        if (!allowOmit) {
            this.getLocation().reportSemanticError(SPECIFICVALUEEXPECTED);
        }
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        this.lengthRestriction.getLocation().reportSemanticError("Length restriction cannot be used with omit value");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        IType last;
        if (!allowOmit) {
            this.location.reportSemanticError(OMITNOTALLOWED);
            this.setIsErroneous(true);
        }
        if (!this.getIsErroneous(timestamp) && IType.Type_type.TYPE_SIGNATURE.equals((Object)(last = type.getTypeRefdLast(timestamp)).getTypetype())) {
            this.location.reportSemanticError(MessageFormat.format(SIGNATUREERROR, last.getFullName()));
            this.setIsErroneous(true);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    public IValue getValue() {
        if (this.asValue != null) {
            return this.asValue;
        }
        this.asValue = new Omit_Value();
        this.asValue.setLocation(this.getLocation());
        this.asValue.setMyScope(this.getMyScope());
        this.asValue.setFullNameParent(this.getNameParent());
        return this.asValue;
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
            usageLocation.reportSemanticError(MessageFormat.format("Restriction on {0} does not allow usage of `{1}''", definitionName, this.getTemplateTypeName()));
        }
        return false;
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        usageLocation.reportSemanticError(MessageFormat.format("Restriction on {0} does not allow usage of `{1}''", definitionName, this.getTemplateTypeName()));
        return false;
    }
}

