/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Invoke_Altguard
extends AltGuard {
    private static final String BOOLEANEXPECTED = "A value or expression of type boolean was expected";
    private static final String FULLNAMEPART1 = ".expr";
    private static final String FULLNAMEPART2 = ".function";
    private static final String FULLNAMEPART3 = ".<parameters>";
    private static final String FULLNAMEPART4 = ".block";
    private final Value expression;
    private final Value value;
    private final ParsedActualParameters parsedParameters;

    public Invoke_Altguard(Value expression, Value value, ParsedActualParameters actualParameterList, StatementBlock statementblock) {
        super(AltGuard.altguard_type.AG_INVOKE, statementblock);
        this.expression = expression;
        this.value = value;
        this.parsedParameters = actualParameterList;
        if (expression != null) {
            expression.setFullNameParent(this);
        }
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
            statementblock.setOwnerIsAltguard();
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.expression == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.value == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.parsedParameters == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.expression != null) {
            this.expression.setMyScope(scope);
        }
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.parsedParameters != null) {
            this.parsedParameters.setMyScope(scope);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyScope(scope);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementblock != null) {
            return this.statementblock.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        IType type;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.expression != null) {
            IValue last = this.expression.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temporalType = last.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (!last.getIsErroneous(timestamp) && !IType.Type_type.TYPE_BOOL.equals((Object)temporalType)) {
                last.getLocation().reportSemanticError(BOOLEANEXPECTED);
                this.expression.setIsErroneous(true);
            }
        }
        if ((type = this.value.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE)) == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        if ((type = type.getTypeRefdLast(timestamp)) == null || type.getIsErroneous(timestamp)) {
            this.lastTimeChecked = timestamp;
            return;
        }
        if (!IType.Type_type.TYPE_ALTSTEP.equals((Object)type.getTypetype())) {
            this.value.getLocation().reportSemanticError(MessageFormat.format("A value of type altstep was expected instead of `{0}''", type.getTypename()));
            this.lastTimeChecked = timestamp;
            return;
        }
        this.value.getMyScope().checkRunsOnScope(timestamp, type, (ILocateableNode)this, "call");
        FormalParameterList formalParmaterList = ((Altstep_Type)type).getFormalParameters();
        ActualParameterList actualParameterList = new ActualParameterList();
        formalParmaterList.checkActualParameterList(timestamp, this.parsedParameters, actualParameterList);
        if (this.statementblock != null) {
            this.statementblock.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        this.getLocation().reportSemanticError("Invocation of an altstep is not allowed within an interleave statement");
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    @Override
    public void postCheck() {
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            if (this.statementblock != null && reparser.envelopsDamage(this.statementblock.getLocation())) {
                this.statementblock.updateSyntax(reparser, true);
                if (this.expression != null) {
                    this.expression.updateSyntax(reparser, false);
                    reparser.updateLocation(this.expression.getLocation());
                }
                if (this.parsedParameters != null) {
                    this.parsedParameters.updateSyntax(reparser, false);
                    reparser.updateLocation(this.parsedParameters.getLocation());
                }
                reparser.updateLocation(this.statementblock.getLocation());
                return;
            }
            throw new ReParseException();
        }
        if (this.expression != null) {
            this.expression.updateSyntax(reparser, false);
            reparser.updateLocation(this.expression.getLocation());
        }
        if (this.parsedParameters != null) {
            this.parsedParameters.updateSyntax(reparser, false);
            reparser.updateLocation(this.parsedParameters.getLocation());
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.expression != null) {
            this.expression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parsedParameters != null) {
            this.parsedParameters.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.expression != null && !this.expression.accept(v)) {
            return false;
        }
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        if (this.parsedParameters != null && !this.parsedParameters.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }
}

