/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Check_Port_Statement
extends Statement {
    private static final String NOINCOMINGQUEUE = "Port type `{0}'' does not have incoming queue because it has neither incoming messages nor incoming or outgoing signatues";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".from";
    private static final String FULLNAMEPART3 = ".redirectSender";
    private static final String STATEMENT_NAME = "check";
    private final Reference portReference;
    private final TemplateInstance fromClause;
    private final Reference redirectSender;

    public Check_Port_Statement(Reference portReference, TemplateInstance fromClause, Reference redirectSender) {
        this.portReference = portReference;
        this.fromClause = fromClause;
        this.redirectSender = redirectSender;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CHECK;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Type portType = Port_Utility.checkPortReference(timestamp, this, this.portReference);
        if (portType != null && !portType.getPortBody().hasQueue(timestamp)) {
            this.portReference.getLocation().reportSemanticError(MessageFormat.format(NOINCOMINGQUEUE, portType.getTypename()));
        }
        Port_Utility.checkFromClause(timestamp, this, portType, this.fromClause, this.redirectSender);
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(219);
        if (this.fromClause != null) {
            return result;
        }
        result.add(54);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        return this.redirectSender == null || this.redirectSender.accept(v);
    }
}

