/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.product.ProductIdentity;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportation;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AnytypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ModuleVersionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TitanVersionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.VersionRequirementAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.core.CompilerVersionInformationCollector;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.core.ProductIdentityHelper;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class TTCN3Module
extends Module {
    private static final String FULLNAMEPART = ".control";
    public static final String MODULE = "module";
    private static final String MISSINGREFERENCE = "There is no visible definition with name `{0}'' in module `{1}''";
    private final List<ImportModule> importedModules = new CopyOnWriteArrayList<ImportModule>();
    private final List<FriendModule> friendModules = new CopyOnWriteArrayList<FriendModule>();
    protected Definitions definitions = new Definitions();
    private ControlPart controlpart;
    private Location commentLocation = null;
    Set<IFile> includedFiles = null;
    List<Location> inactiveCodeLocations = null;
    private Anytype_Type anytype;
    private Def_Type anytypeDefinition;
    protected WithAttributesPath withAttributesPath = null;
    private ProductIdentity versionNumber = null;
    private List<Reference> missingReferences;

    public TTCN3Module(Identifier identifier, IProject project) {
        super(identifier, project);
        this.definitions.setParentScope(this);
        this.definitions.setFullNameParent(this);
        this.anytype = new Anytype_Type();
        this.anytypeDefinition = new Def_Type(new Identifier(Identifier.Identifier_type.ID_TTCN, "anytype"), this.anytype);
        this.anytypeDefinition.setMyScope(this);
        this.anytypeDefinition.setFullNameParent(this);
        this.missingReferences = new ArrayList<Reference>();
    }

    @Override
    public Module.module_type getModuletype() {
        return Module.module_type.TTCN3_MODULE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = new StringBuilder();
        builder.append("@").append(this.getIdentifier().getDisplayName());
        if (this.controlpart == child) {
            return builder.append(FULLNAMEPART);
        }
        if (this.anytypeDefinition == child) {
            Identifier identifier = this.anytypeDefinition.getIdentifier();
            return builder.append(".").append(identifier.getDisplayName());
        }
        return builder;
    }

    public void setDefinitionsLocation(Location location) {
        this.definitions.setLocation(location);
    }

    private void setVersion(ProductIdentity versionNumber) {
        this.versionNumber = versionNumber;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public void addDefinition(Definition def) {
        this.definitions.addDefinition(def);
    }

    public void addDefinitions(List<Definition> definitionList) {
        this.definitions.addDefinitions(definitionList);
    }

    public void addImportedModule(ImportModule impmod) {
        if (impmod != null && impmod.getIdentifier() != null) {
            this.importedModules.add(impmod);
            impmod.setMyModule(this.identifier);
            impmod.setMyModule(this);
            impmod.setProject(this.project);
        }
    }

    public void addGroup(Group group) {
        if (group != null && group.getIdentifier() != null) {
            this.definitions.addGroup(group);
        }
    }

    public void addFriendModule(FriendModule friendModule) {
        if (friendModule != null) {
            this.friendModules.add(friendModule);
            friendModule.setProject(this.project);
        }
    }

    @Override
    public Definitions getAssignmentsScope() {
        return this.definitions;
    }

    @Override
    public Assignments getAssignments() {
        return this.definitions;
    }

    @Override
    public Def_Type getAnytype() {
        return this.anytypeDefinition;
    }

    public IType getAddressType(CompilationTimeStamp timestamp) {
        Identifier addressIdentifier = new Identifier(Identifier.Identifier_type.ID_TTCN, "ADDRESS");
        if (!this.definitions.hasLocalAssignmentWithID(timestamp, addressIdentifier)) {
            return null;
        }
        Definition definition = this.definitions.getLocalAssignmentByID(timestamp, addressIdentifier);
        if (!Assignment.Assignment_type.A_TYPE.equals(definition.getAssignmentType())) {
            return null;
        }
        return definition.getType(timestamp);
    }

    @Override
    public Object[] getOutlineChildren() {
        if (!this.importedModules.isEmpty()) {
            return new Object[]{this.importedModules, this.definitions};
        }
        return new Object[]{this.definitions};
    }

    @Override
    public String getOutlineIcon() {
        return "ttcn.gif";
    }

    public void addControlpart(ControlPart controlpart) {
        if (controlpart != null) {
            this.controlpart = controlpart;
            controlpart.setMyScope(this.definitions);
            controlpart.setFullNameParent(this);
        }
    }

    @Override
    public boolean isValidModuleId(Identifier identifier) {
        if (identifier == null) {
            return false;
        }
        String originalName = identifier.getName();
        if (this.identifier != null && originalName.equals(this.identifier.getName())) {
            return true;
        }
        for (ImportModule impMod : this.importedModules) {
            if (!originalName.equals(impMod.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkImports(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, List<Module> moduleStack) {
        if (this.lastImportCheckTimeStamp != null && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        for (ImportModule impmod : this.importedModules) {
            referenceChain.markState();
            impmod.checkImports(timestamp, referenceChain, moduleStack);
            referenceChain.previousState();
            LoadBalancingUtilities.astNodeChecked();
        }
        this.lastImportCheckTimeStamp = timestamp;
    }

    private void checkFriendModuleUniqueness() {
        if (!this.friendModules.isEmpty()) {
            HashMap<String, FriendModule> map = new HashMap<String, FriendModule>(this.friendModules.size());
            for (FriendModule friendModule : this.friendModules) {
                Identifier identifier = friendModule.getIdentifier();
                String name = identifier.getName();
                if (map.containsKey(name)) {
                    Location otherLocation = ((FriendModule)map.get(name)).getIdentifier().getLocation();
                    otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate friend module `{0}'' was first declared here", identifier.getDisplayName()));
                    Location friendLocation = friendModule.getIdentifier().getLocation();
                    friendLocation.reportSingularSemanticError(MessageFormat.format("Duplicate friend module `{0}'' was declared here again", identifier.getDisplayName()));
                    continue;
                }
                map.put(name, friendModule);
            }
        }
    }

    public List<ImportModule> getImports() {
        ArrayList<ImportModule> result = new ArrayList<ImportModule>(this.importedModules.size());
        result.addAll(this.importedModules);
        return result;
    }

    @Override
    public List<Module> getImportedModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        for (ImportModule impmod : this.importedModules) {
            result.add(impmod.getReferredModule());
        }
        return result;
    }

    @Override
    public boolean hasUnhandledImportChanges() {
        for (ImportModule impmod : this.importedModules) {
            if (!impmod.hasUnhandledChange()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        T3Doc.check(this.getCommentLocation(), MODULE);
        this.lastCompilationTimeStamp = timestamp;
        if (this.getSkippedFromSemanticChecking()) {
            return;
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionTTCN3Module", this.identifier, "TTCN-3 module");
        this.versionNumber = null;
        this.anytype.clear();
        this.missingReferences.clear();
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        for (ImportModule impMod : this.importedModules) {
            impMod.check(timestamp);
        }
        this.checkFriendModuleUniqueness();
        for (FriendModule friendModule : this.friendModules) {
            friendModule.check(timestamp);
        }
        if (this.withAttributesPath != null) {
            this.analyzeExtensionAttributes(timestamp);
        }
        this.anytypeDefinition.check(timestamp);
        this.definitions.check(timestamp);
        if (this.controlpart != null) {
            this.controlpart.check(timestamp);
        }
    }

    public void checkWithDefinitions(CompilationTimeStamp timestamp, List<Assignment> assignments) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        T3Doc.check(this.getCommentLocation(), MODULE);
        this.lastCompilationTimeStamp = timestamp;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionTTCN3Module", this.identifier, "TTCN-3 module");
        this.versionNumber = null;
        this.anytype.clear();
        this.missingReferences.clear();
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.checkFriendModuleUniqueness();
        for (FriendModule friendModule : this.friendModules) {
            friendModule.check(timestamp);
        }
        if (this.withAttributesPath != null) {
            this.analyzeExtensionAttributes(timestamp);
        }
        this.definitions.checkWithDefinitions(timestamp, assignments);
        if (this.controlpart != null) {
            this.controlpart.check(timestamp);
        }
    }

    @Override
    public void postCheck() {
        if (!TTCN3Module.getReportUnusedModuleImportationProblems()) {
            for (ImportModule impmod : this.importedModules) {
                impmod.postCheck();
            }
        }
        this.definitions.postCheck();
        if (this.controlpart != null) {
            this.controlpart.postCheck();
        }
    }

    public void analyzeExtensionAttributes(CompilationTimeStamp timestamp) {
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (int i = 0; i < realAttributes.size(); ++i) {
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (int i = 0; i < specifications.size(); ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        block8: for (int i = 0; i < attributes.size(); ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            switch (extensionAttribute.getAttributeType()) {
                case ANYTYPE: {
                    AnytypeAttribute anytypeAttribute = (AnytypeAttribute)extensionAttribute;
                    for (int j = 0; j < anytypeAttribute.getNofTypes(); ++j) {
                        Object fieldName;
                        Type tempType = anytypeAttribute.getType(j);
                        Identifier identifier = null;
                        if (IType.Type_type.TYPE_REFERENCED.equals((Object)tempType.getTypetype())) {
                            Reference reference = ((Referenced_Type)tempType).getReference();
                            identifier = reference.getId();
                            fieldName = identifier.getTtcnName();
                        } else {
                            fieldName = tempType.getTypename();
                            identifier = new Identifier(Identifier.Identifier_type.ID_TTCN, (String)fieldName);
                        }
                        tempType.setMyScope(this.definitions);
                        this.anytype.addComp(new CompField(identifier, tempType, false, null));
                    }
                    continue block8;
                }
                case VERSION: {
                    ModuleVersionAttribute moduleVersion = (ModuleVersionAttribute)extensionAttribute;
                    moduleVersion.parse();
                    if (this.versionNumber != null) {
                        moduleVersion.getLocation().reportSemanticError("Duplicate version attribute");
                        continue block8;
                    }
                    this.setVersion(moduleVersion.getVersionNumber());
                    continue block8;
                }
                case REQUIRES: {
                    VersionRequirementAttribute versionReq = (VersionRequirementAttribute)extensionAttribute;
                    versionReq.parse();
                    ModuleImportation theImport = null;
                    String requiredModuleName = versionReq.getRequiredModule().getName();
                    for (ImportModule impMod : this.importedModules) {
                        if (!requiredModuleName.equals(impMod.getIdentifier().getName())) continue;
                        theImport = impMod;
                        break;
                    }
                    if (theImport == null) {
                        String message = MessageFormat.format("There is no module with name `{0}''", versionReq.getRequiredModule().getDisplayName());
                        versionReq.getRequiredModule().getLocation().reportSemanticError(message);
                        continue block8;
                    }
                    TTCN3Module theImportedModule = (TTCN3Module)theImport.getReferredModule();
                    theImportedModule.check(timestamp);
                    ProductIdentity requiredVersion = versionReq.getVersionNumber();
                    if (requiredVersion == null || theImportedModule.versionNumber == null || theImportedModule.versionNumber.compareTo(requiredVersion) >= 0) continue block8;
                    String message = MessageFormat.format("Module `{0}'' requires version {1} of module `{2}'', but only version {3} is available", this.identifier.getDisplayName(), requiredVersion.toString(), theImportedModule.getIdentifier().getDisplayName(), theImportedModule.versionNumber.toString());
                    versionReq.getLocation().reportSemanticError(message);
                    continue block8;
                }
                case TITANVERSION: {
                    String message;
                    TitanVersionAttribute titanReq = (TitanVersionAttribute)extensionAttribute;
                    titanReq.parse();
                    ProductIdentity requiredTITANVersion = titanReq.getVersionNumber();
                    String temp = CompilerVersionInformationCollector.getCompilerProductNumber();
                    ProductIdentity compilerVersion = ProductIdentityHelper.getProductIdentity(temp, null);
                    if (requiredTITANVersion != null && compilerVersion != null && compilerVersion.compareTo(requiredTITANVersion) < 0) {
                        message = MessageFormat.format("Module `{0}'' requires TITAN version {1}, but version {2} is used right now", this.identifier.getDisplayName(), requiredTITANVersion.toString(), compilerVersion.toString());
                        titanReq.getLocation().reportSemanticError(message);
                    }
                    if (requiredTITANVersion == null || GeneralConstants.ON_THE_FLY_ANALYZER_VERSION == null || GeneralConstants.ON_THE_FLY_ANALYZER_VERSION.compareTo(requiredTITANVersion) >= 0) continue block8;
                    message = MessageFormat.format("Module `{0}'' requires TITAN version {1}, but the on-the-fly analyzer is of version {2}", this.identifier.getDisplayName(), requiredTITANVersion.toString(), GeneralConstants.ON_THE_FLY_ANALYZER_VERSION.toString());
                    titanReq.getLocation().reportSemanticError(message);
                    continue block8;
                }
            }
        }
    }

    @Override
    public Scope getSmallestEnclosingScope(int offset) {
        if (this.location == null || offset < this.location.getOffset() || offset > this.location.getEndOffset()) {
            return null;
        }
        if (this.controlpart != null && this.controlpart.getLocation() != null && this.controlpart.getLocation().getOffset() < offset && offset < this.controlpart.getLocation().getEndOffset()) {
            return this.controlpart.getSmallestEnclosingScope(offset);
        }
        return this.definitions.getSmallestEnclosingScope(offset);
    }

    @Override
    public boolean hasImportedAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        for (ImportModule impMod : this.importedModules) {
            if (!impMod.hasImportedAssignmentWithID(timestamp, identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Definition importAssignment(CompilationTimeStamp timestamp, Identifier moduleId, Reference reference) {
        Definition result = this.definitions.getLocalAssignmentByID(timestamp, reference.getId());
        if (result == null) {
            return null;
        }
        VisibilityModifier modifier = result.getVisibilityModifier();
        switch (modifier) {
            case Public: {
                return result;
            }
            case Friend: {
                for (FriendModule friend : this.friendModules) {
                    if (!friend.getIdentifier().getName().equals(moduleId.getName())) continue;
                    return result;
                }
                return null;
            }
            case Private: {
                return null;
            }
        }
        return result;
    }

    public boolean isVisible(CompilationTimeStamp timestamp, Identifier moduleId, ImportModule impmod) {
        VisibilityModifier modifier = impmod.getVisibilityModifier();
        switch (modifier) {
            case Public: {
                return true;
            }
            case Friend: {
                for (FriendModule friend : this.friendModules) {
                    if (!friend.getIdentifier().getName().equals(moduleId.getName())) continue;
                    return true;
                }
                return false;
            }
            case Private: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isVisible(CompilationTimeStamp timestamp, Identifier moduleId, Assignment assignment) {
        if (assignment == null || !(assignment instanceof Definition)) {
            return false;
        }
        if (this.definitions.getLocalAssignmentByID(timestamp, assignment.getIdentifier()) != assignment) {
            return false;
        }
        VisibilityModifier modifier = ((Definition)assignment).getVisibilityModifier();
        switch (modifier) {
            case Public: {
                return true;
            }
            case Friend: {
                for (FriendModule friend : this.friendModules) {
                    if (!friend.getIdentifier().getName().equals(moduleId.getName())) continue;
                    return true;
                }
                return false;
            }
            case Private: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        Identifier moduleId = reference.getModuleIdentifier();
        Location referenceLocation = reference.getLocation();
        Identifier id = reference.getId();
        if (id == null) {
            return null;
        }
        Assignment temporalAssignment = null;
        if (moduleId == null) {
            if ("anytype".equals(id.getTtcnName())) {
                return this.anytypeDefinition;
            }
            Assignment tempResult = null;
            for (ImportModule impMod : this.importedModules) {
                if (impMod.getReferredModule() == null) continue;
                ModuleImportationChain referenceChain = new ModuleImportationChain("Circular reference chain: `{0}''", false);
                tempResult = impMod.importAssignment(timestamp, referenceChain, this.identifier, reference, new ArrayList<ModuleImportation>());
                if (tempResult != null && !tempResult.getMyScope().getModuleScope().isVisible(timestamp, this.getIdentifier(), tempResult)) {
                    tempResult = null;
                }
                if (tempResult == null) continue;
                if (temporalAssignment == null) {
                    temporalAssignment = tempResult;
                    continue;
                }
                if (temporalAssignment == tempResult) continue;
                reference.getLocation().reportSemanticError("It is not possible to resolve this reference unambigously, as  it can be resolved to `" + temporalAssignment.getFullName() + "' and to `" + tempResult.getFullName() + "'");
                return null;
            }
            if (temporalAssignment != null) {
                return temporalAssignment;
            }
            referenceLocation.reportSemanticError(MessageFormat.format(MISSINGREFERENCE, id.getDisplayName(), this.identifier.getDisplayName()));
            this.missingReferences.add(reference);
        } else if (moduleId.getName().equals(this.name)) {
            if ("anytype".equals(id.getTtcnName())) {
                return this.anytypeDefinition;
            }
            temporalAssignment = this.definitions.getLocalAssignmentByID(timestamp, id);
            if (temporalAssignment == null) {
                referenceLocation.reportSemanticError(MessageFormat.format(MISSINGREFERENCE, id.getDisplayName(), this.identifier.getDisplayName()));
            }
        } else {
            for (ImportModule impMod : this.importedModules) {
                if (!moduleId.getName().equals(impMod.getName())) continue;
                if (impMod.getReferredModule() == null) {
                    return temporalAssignment;
                }
                ModuleImportationChain referenceChain = new ModuleImportationChain("Circular reference chain: `{0}''", false);
                temporalAssignment = impMod.importAssignment(timestamp, referenceChain, this.identifier, reference, new ArrayList<ModuleImportation>());
                if (!impMod.getReferredModule().isVisible(timestamp, this.getIdentifier(), temporalAssignment)) {
                    temporalAssignment = null;
                }
                if (temporalAssignment == null) {
                    referenceLocation.reportSemanticError(MessageFormat.format(MISSINGREFERENCE, id.getDisplayName(), impMod.getIdentifier().getDisplayName()));
                }
                return temporalAssignment;
            }
            referenceLocation.reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportMissingImportedModule", "warning", null), MessageFormat.format("There is no module with name `{0}''", moduleId.getDisplayName()));
            this.missingReferences.add(reference);
        }
        return temporalAssignment;
    }

    public List<Reference> getMissingReferences() {
        return this.missingReferences;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("module: ").append(this.name);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        Identifier moduleId = propCollector.getReference().getModuleIdentifier();
        if (moduleId == null) {
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null) continue;
                importedModule.addProposal(propCollector, this.identifier);
            }
        } else if (this.identifier != null && moduleId.getName().equals(this.identifier.getName())) {
            for (int i = 0; i < this.definitions.getNofAssignments(); ++i) {
                this.definitions.getAssignmentByIndex(i).addProposal(propCollector, 0);
            }
        } else {
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null || !importedModule.getName().equals(moduleId.getName())) continue;
                importedModule.addProposal(propCollector, this.identifier);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.MODULE_LEVEL_SKELETON_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.MODULE_SCOPE, null, "keyword");
        propCollector.addProposal(TTCN3Keywords.GENERALLY_USABLE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        Identifier moduleId = declarationCollector.getReference().getModuleIdentifier();
        if (moduleId == null) {
            List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
            if (subrefs.size() == 1 && this.identifier != null && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
                declarationCollector.addDeclaration(this.name, this.identifier.getLocation(), this);
            }
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null) continue;
                importedModule.addDeclaration(declarationCollector, this.identifier);
            }
        } else if (this.identifier != null && moduleId.getName().equals(this.identifier.getName())) {
            for (int i = 0; i < this.definitions.getNofAssignments(); ++i) {
                this.definitions.getAssignmentByIndex(i).addDeclaration(declarationCollector, 0);
            }
        } else {
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null || !importedModule.getName().equals(moduleId.getName())) continue;
                importedModule.addDeclaration(declarationCollector, this.identifier);
            }
        }
        super.addDeclaration(declarationCollector);
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
        }
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void addDeclarationWithoutImportLookup(DeclarationCollector declarationCollector) {
        Identifier moduleId = declarationCollector.getReference().getModuleIdentifier();
        if (moduleId == null) {
            for (int i = 0; i < this.definitions.getNofAssignments(); ++i) {
                this.definitions.getAssignmentByIndex(i).addDeclaration(declarationCollector, 0);
            }
            List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
            if (subrefs.size() == 1 && this.identifier != null && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
                declarationCollector.addDeclaration(this.name, this.identifier.getLocation(), this);
            }
        }
    }

    @Override
    public void extractStructuralInformation(ProjectStructureDataCollector collector) {
        for (ImportModule imported : this.importedModules) {
            collector.addImportation(this.identifier, imported.getIdentifier());
        }
    }

    private int reparseAfterModule(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                MultipleWithAttributes attributes = parser.pr_reparser_optionalWithStatement().attributes;
                parser.pr_EndOfFile();
                if (parser.isErrorListEmpty()) {
                    TTCN3Module.this.withAttributesPath = new WithAttributesPath();
                    TTCN3Module.this.withAttributesPath.setWithAttributes(attributes);
                    if (attributes != null) {
                        TTCN3Module.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                    }
                }
            }
        });
    }

    private int reparseInsideAttributelist(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                MultipleWithAttributes attributes = parser.pr_reparser_optionalWithStatement().attributes;
                parser.pr_EndOfFile();
                if (parser.isErrorListEmpty()) {
                    TTCN3Module.this.withAttributesPath.setWithAttributes(attributes);
                    TTCN3Module.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                }
            }
        });
    }

    public void updateSyntax(TTCN3ReparseUpdater reparser, ProjectSourceParser sourceParser) throws ReParseException {
        boolean enveloped = false;
        if (reparser.getDamageEnd() < this.location.getOffset()) {
            reparser.updateLocation(this.identifier.getLocation());
            if (this.definitions != null) {
                this.definitions.updateSyntax(reparser, this.importedModules, this.friendModules, this.controlpart);
            }
            if (this.controlpart != null) {
                this.controlpart.updateSyntax(reparser);
                reparser.updateLocation(this.controlpart.getLocation());
            }
            if (this.withAttributesPath != null) {
                this.withAttributesPath.updateSyntax(reparser, false);
                reparser.updateLocation(this.withAttributesPath.getLocation());
            }
            return;
        }
        if (reparser.getDamageStart() > this.location.getEndOffset()) {
            if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
                reparser.extendDamagedRegionTillFileEnd();
                int result = this.reparseAfterModule(reparser);
                if (result != 0) {
                    throw new ReParseException();
                }
            }
            return;
        }
        Location temporalIdentifier = this.identifier.getLocation();
        if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
            reparser.extendDamagedRegion(temporalIdentifier);
            IdentifierReparser r = new IdentifierReparser(reparser);
            int result = r.parse();
            this.identifier = r.getIdentifier();
            if (result != 0) {
                throw new ReParseException(result);
            }
            if (this.definitions != null) {
                this.definitions.updateSyntax(reparser, this.importedModules, this.friendModules, this.controlpart);
            }
            if (this.controlpart != null) {
                this.controlpart.updateSyntax(reparser);
                reparser.updateLocation(this.controlpart.getLocation());
            }
            if (this.withAttributesPath != null) {
                this.withAttributesPath.updateSyntax(reparser, false);
                reparser.updateLocation(this.withAttributesPath.getLocation());
            }
            return;
        }
        if (reparser.isDamaged(temporalIdentifier)) {
            throw new ReParseException();
        }
        if (this.definitions != null && reparser.envelopsDamage(this.definitions.getLocation()) || this.controlpart != null && reparser.envelopsDamage(this.controlpart.getLocation())) {
            if (this.definitions != null && reparser.isAffected(this.definitions.getLocation())) {
                this.definitions.updateSyntax(reparser, this.importedModules, this.friendModules, this.controlpart);
                reparser.updateLocation(this.definitions.getLocation());
            }
            if (this.controlpart != null && reparser.isAffected(this.controlpart.getLocation())) {
                this.controlpart.updateSyntax(reparser);
                reparser.updateLocation(this.controlpart.getLocation());
            }
            enveloped = true;
        }
        if (this.withAttributesPath != null && reparser.isAffected(this.withAttributesPath.getLocation())) {
            if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                reparser.extendDamagedRegion(this.withAttributesPath.getLocation());
                int result = this.reparseInsideAttributelist(reparser);
                if (result != 0) {
                    throw new ReParseException();
                }
                return;
            }
            if (enveloped) {
                this.withAttributesPath.updateSyntax(reparser, reparser.envelopsDamage(this.withAttributesPath.getLocation()));
                reparser.updateLocation(this.withAttributesPath.getLocation());
            } else {
                throw new ReParseException();
            }
        }
        if (!enveloped) {
            throw new ReParseException();
        }
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitions == null) {
            return null;
        }
        return this.definitions.getEnclosingAssignment(offset);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.definitions != null) {
            this.definitions.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.controlpart != null) {
            this.controlpart.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.anytypeDefinition != null) {
            this.anytypeDefinition.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.importedModules != null) {
            for (ImportModule im : this.importedModules) {
                if (im.accept(v)) continue;
                return false;
            }
        }
        if (this.friendModules != null) {
            for (FriendModule fm : this.friendModules) {
                if (fm.accept(v)) continue;
                return false;
            }
        }
        if (this.definitions != null && !this.definitions.accept(v)) {
            return false;
        }
        if (this.controlpart != null && !this.controlpart.accept(v)) {
            return false;
        }
        if (this.anytypeDefinition != null && !this.anytypeDefinition.accept(v)) {
            return false;
        }
        return this.withAttributesPath == null || this.withAttributesPath.accept(v);
    }

    public void setIncludedFiles(Set<IFile> includedFiles) {
        this.includedFiles = includedFiles;
    }

    public Set<IFile> getIncludedFiles() {
        return this.includedFiles;
    }

    public void setInactiveCodeLocations(List<Location> inactiveCodeLocations) {
        this.inactiveCodeLocations = inactiveCodeLocations;
    }

    public List<Location> getInactiveCodeLocations() {
        return this.inactiveCodeLocations;
    }
}

