/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Testcase
extends Definition
implements IParameterisedAssignment {
    private static final String FULLNAMEPART1 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART2 = ".<runs_on_type>";
    private static final String FULLNAMEPART3 = ".<system_type>";
    private static final String FULLNAMEPART4 = ".<statement_block>";
    private static final String DASHALLOWEDONLYFORTEMPLATES = "Using not used symbol (`-') as the default parameter is allowed only for modified templates";
    private static final String KIND = "testcase";
    private final FormalParameterList formalParList;
    private final Reference runsOnReference;
    private Component_Type runsOnType = null;
    private final Reference systemReference;
    private Component_Type systemType = null;
    private final StatementBlock block;
    private NamedBridgeScope bridgeScope = null;

    public static String getKind() {
        return KIND;
    }

    public Def_Testcase(Identifier identifier, FormalParameterList formalParameters, Reference runsOnRef, Reference systemRef, StatementBlock block) {
        super(identifier);
        this.formalParList = formalParameters;
        if (this.formalParList != null) {
            this.formalParList.setMyDefinition(this);
        }
        this.runsOnReference = runsOnRef;
        this.systemReference = systemRef;
        this.block = block;
        if (block != null) {
            block.setMyDefinition(this);
            block.setFullNameParent(this);
        }
        if (this.formalParList != null) {
            this.formalParList.setFullNameParent(this);
        }
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
        if (systemRef != null) {
            systemRef.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TESTCASE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.runsOnReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.systemReference == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.block == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public FormalParameterList getFormalParameterList() {
        return this.formalParList;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getOutlineIcon() {
        return "testcase.gif";
    }

    @Override
    public String getOutlineText() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParList == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.equals((parameter = this.formalParList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(type.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        nameBuilder.append('(');
        this.formalParList.getAsProposalDesriptionPart(nameBuilder);
        nameBuilder.append(')');
        return nameBuilder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.runsOnReference != null) {
            this.runsOnReference.setMyScope(this.bridgeScope);
        }
        if (this.systemReference != null) {
            this.systemReference.setMyScope(this.bridgeScope);
        }
        this.formalParList.setMyScope(this.bridgeScope);
        if (this.block != null) {
            this.block.setMyScope(this.formalParList);
            this.bridgeScope.addSubScope(this.block.getLocation(), this.block);
        }
        this.bridgeScope.addSubScope(this.formalParList.getLocation(), this.formalParList);
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    public Component_Type getSystemType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.systemType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        this.runsOnType = null;
        this.systemType = null;
        this.lastTimeChecked = timestamp;
        T3Doc.check(this.getCommentLocation(), KIND);
        if (this.runsOnReference != null) {
            this.runsOnType = this.runsOnReference.chkComponentypeReference(timestamp);
            if (this.runsOnType != null) {
                Scope formalParlistPreviosScope = this.formalParList.getParentScope();
                if (formalParlistPreviosScope instanceof RunsOnScope && ((RunsOnScope)formalParlistPreviosScope).getParentScope() == this.myScope) {
                    ((RunsOnScope)formalParlistPreviosScope).setComponentType(this.runsOnType);
                } else {
                    RunsOnScope tempScope = new RunsOnScope(this.runsOnType, this.myScope);
                    this.formalParList.setMyScope(tempScope);
                }
            }
        }
        if (this.systemReference != null) {
            this.systemType = this.systemReference.chkComponentypeReference(timestamp);
        }
        if (this.formalParList.hasNotusedDefaultValue()) {
            this.formalParList.getLocation().reportSemanticError(DASHALLOWEDONLYFORTEMPLATES);
            return;
        }
        boolean canSkip = false;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            canSkip = true;
        }
        if (!canSkip) {
            this.formalParList.reset();
        }
        this.formalParList.check(timestamp, this.getAssignmentType());
        if (canSkip) {
            return;
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionTestcase", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.block != null) {
            this.block.check(timestamp);
            this.block.postCheck();
            if (!EditorTracker.containsKey((IFile)this.getLocation().getFile())) {
                this.block.free();
            }
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
    }

    @Override
    public void postCheck() {
        Module module;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        super.postCheck();
        this.formalParList.postCheck();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (ISubReference.Subreference_type.parameterisedSubReference.equals((Object)subrefs.get(i).getReferenceType()) && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            return;
        }
        if (this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase()) && subrefs.size() == i + 1) {
            StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
            patternBuilder.append('(');
            this.formalParList.getAsProposalPart(patternBuilder);
            patternBuilder.append(')');
            propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            super.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (this.identifier.getName().equals(subrefs.get(i).getId().getName()) && subrefs.size() == i + 1) {
            declarationCollector.addDeclaration(this);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            int result = 1;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.formalParList != null) {
                if (enveloped) {
                    this.formalParList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParList.getLocation())) {
                    try {
                        this.formalParList.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.formalParList.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.runsOnReference != null) {
                if (enveloped) {
                    this.runsOnReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.runsOnReference.getLocation());
                } else if (reparser.envelopsDamage(this.runsOnReference.getLocation())) {
                    try {
                        this.runsOnReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.runsOnReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.systemReference != null) {
                if (enveloped) {
                    this.systemReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.systemReference.getLocation());
                } else if (reparser.envelopsDamage(this.systemReference.getLocation())) {
                    try {
                        this.systemReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.systemReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.block != null) {
                if (enveloped) {
                    this.block.updateSyntax(reparser, false);
                    reparser.updateLocation(this.block.getLocation());
                } else if (reparser.envelopsDamage(this.block.getLocation())) {
                    try {
                        this.block.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.block.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.runsOnReference != null) {
            this.runsOnReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnReference.getLocation());
        }
        if (this.systemReference != null) {
            this.systemReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.systemReference.getLocation());
        }
        if (this.block != null) {
            this.block.updateSyntax(reparser, false);
            reparser.updateLocation(this.block.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnReference != null) {
            this.runsOnReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.systemReference != null) {
            this.systemReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.block != null) {
            this.block.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        if (this.runsOnReference != null && !this.runsOnReference.accept(v)) {
            return false;
        }
        if (this.systemReference != null && !this.systemReference.accept(v)) {
            return false;
        }
        return this.block == null || this.block.accept(v);
    }
}

