/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Port
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<dimensions>";
    public static final String PORTEXPECTED = "Port type expected";
    public static final String TYPEEXPECTED = "Type reference expected";
    private static final String KIND = "port definition";
    private final Reference portTypeReference;
    private Port_Type portType = null;
    private final ArrayDimensions dimensions;

    public static String getKind() {
        return KIND;
    }

    public Def_Port(Identifier identifier, Reference portTypeReference, ArrayDimensions dimensions) {
        super(identifier);
        this.portTypeReference = portTypeReference;
        this.dimensions = dimensions;
        if (portTypeReference != null) {
            portTypeReference.setFullNameParent(this);
        }
        if (dimensions != null) {
            dimensions.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_PORT;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dimensions != null) {
            this.dimensions.setMyScope(scope);
        }
        if (this.portTypeReference != null) {
            this.portTypeReference.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portTypeReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.dimensions == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public ArrayDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public String getAssignmentName() {
        return "port";
    }

    @Override
    public String getOutlineIcon() {
        return "port.gif";
    }

    @Override
    public Port_Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.portType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        T3Doc.check(this.getCommentLocation(), KIND);
        this.isUsed = false;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGlobalPort", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.portTypeReference == null) {
            return;
        }
        Assignment assignment = this.portTypeReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return;
        }
        if (Assignment.Assignment_type.A_TYPE.equals(assignment.getAssignmentType()) && assignment.getType(timestamp) != null) {
            IType type = assignment.getType(timestamp);
            if ((type = type.getTypeRefdLast(timestamp)) != null && !type.getIsErroneous(timestamp)) {
                switch (type.getTypetype()) {
                    case TYPE_PORT: {
                        this.portType = (Port_Type)type;
                        break;
                    }
                    case TYPE_REFERENCED: {
                        break;
                    }
                    default: {
                        this.portTypeReference.getLocation().reportSemanticError(PORTEXPECTED);
                    }
                }
            }
        } else {
            this.portTypeReference.getLocation().reportSemanticError(TYPEEXPECTED);
        }
        if (this.dimensions != null) {
            this.dimensions.check(timestamp);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_PORT.equals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a port, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Port otherPort = (Def_Port)definition;
        if (!this.portType.isIdentical(timestamp, otherPort.portType)) {
            String mesage = MessageFormat.format("Local port `{0}'' has type `{1}'', but the port inherited from component type `{2}'' has type `{3}''", this.identifier.getDisplayName(), this.portType.getTypename(), otherPort.getMyScope().getFullName(), otherPort.portType.getTypename());
            this.portTypeReference.getLocation().reportSemanticError(mesage);
            return false;
        }
        if (this.dimensions != null) {
            if (otherPort.dimensions != null) {
                if (this.dimensions.isIdenticial(timestamp, otherPort.dimensions)) return true;
                this.location.reportSemanticError(MessageFormat.format("Local port `{0}'' and the port inherited from component type `{1}'' have different array dimensions", this.identifier.getDisplayName(), otherPort.getMyScope().getFullName()));
                return false;
            }
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a port array, but the definition inherited from component type `{1}'' is a single port", this.identifier.getDisplayName(), otherPort.getMyScope().getFullName()));
            return false;
        }
        if (otherPort.dimensions == null) return true;
        this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a single port, but the definition inherited from component type `{1}'' is a port array", this.identifier.getDisplayName(), otherPort.getMyScope().getFullName()));
        return false;
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            super.addProposal(propCollector, i);
        } else if (subrefs.size() > i + 1 && this.portType != null && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.portType.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && this.portType != null) {
                this.portType.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.portTypeReference != null) {
                this.portTypeReference.updateSyntax(reparser, false);
                reparser.updateLocation(this.portTypeReference.getLocation());
            }
            if (this.dimensions != null) {
                this.dimensions.updateSyntax(reparser, false);
            }
            if (this.withAttributesPath != null) {
                this.withAttributesPath.updateSyntax(reparser, false);
                reparser.updateLocation(this.withAttributesPath.getLocation());
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.portTypeReference != null) {
            this.portTypeReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portTypeReference.getLocation());
        }
        if (this.dimensions != null) {
            this.dimensions.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.portTypeReference != null) {
            this.portTypeReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dimensions != null) {
            this.dimensions.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.portTypeReference != null && !this.portTypeReference.accept(v)) {
            return false;
        }
        return this.dimensions == null || this.dimensions.accept(v);
    }
}

