/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.values.Named_Bits;
import org.eclipse.titan.designer.AST.ASN1.values.RelativeObjectIdentifier_Value;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValues;
import org.eclipse.titan.designer.AST.TTCN3.values.ObjectIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Set_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Values;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Undefined_Block_Value
extends Value {
    private Value realValue;
    private Block mBlock;

    public Undefined_Block_Value(Block aBlock) {
        this.mBlock = aBlock;
    }

    public Undefined_Block_Value() {
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.UNDEFINED_BLOCK;
    }

    @Override
    public String createStringRepresentation() {
        return "<unsupported valuetype>";
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (null == this.lastTimeChecked || this.lastTimeChecked.isLess(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (null == this.realValue || this.realValue.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.realValue.getExpressionReturntype(timestamp, expectedValue);
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IValue result = this.getValueRefdLast(timestamp, refChain);
        if (null != result && result != this) {
            return result.getReferencedSubValue(timestamp, reference, actualSubReference, refChain);
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (null == this.lastTimeChecked || this.lastTimeChecked.isLess(timestamp)) {
            return true;
        }
        if (null == this.realValue || this.realValue.getIsErroneous(timestamp)) {
            return true;
        }
        return this.realValue.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (null == this.lastTimeChecked || this.lastTimeChecked.isLess(timestamp)) {
            return this;
        }
        if (null == this.realValue || this.realValue.getIsErroneous(timestamp)) {
            return this;
        }
        return this.realValue.getValueRefdLast(timestamp, expectedValue, referenceChain);
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        this.lastTimeChecked = timestamp;
        switch (newType) {
            case NAMED_BITS: {
                Named_Bits namedBits = this.parseBlockNamedBits();
                if (null == namedBits) {
                    namedBits = new Named_Bits();
                }
                namedBits.copyGeneralProperties(this);
                this.realValue = namedBits;
                break;
            }
            case SEQUENCEOF_VALUE: {
                SequenceOf_Value value = this.parseBlockSeqofValue();
                if (null == value) {
                    Values values = new Values(false);
                    value = new SequenceOf_Value(values);
                }
                value.setFullNameParent(this.getNameParent());
                value.copyGeneralProperties(this);
                this.realValue = value;
                break;
            }
            case SETOF_VALUE: {
                SetOf_Value value = this.parseBlockSetofValue();
                if (null == value) {
                    Values values = new Values(false);
                    value = new SetOf_Value(values);
                }
                value.setFullNameParent(this.getNameParent());
                value.copyGeneralProperties(this);
                this.realValue = value;
                break;
            }
            case SEQUENCE_VALUE: {
                Sequence_Value value = this.parseBlockSequenceValue();
                if (null == value) {
                    NamedValues values = new NamedValues();
                    value = new Sequence_Value(values);
                }
                value.setFullNameParent(this.getNameParent());
                value.copyGeneralProperties(this);
                this.realValue = value;
                break;
            }
            case SET_VALUE: {
                Set_Value value = this.parseBlockSetValue();
                if (null == value) {
                    NamedValues values = new NamedValues();
                    value = new Set_Value(values);
                }
                value.setFullNameParent(this.getNameParent());
                value.copyGeneralProperties(this);
                this.realValue = value;
                break;
            }
            case OBJECTID_VALUE: {
                ObjectIdentifier_Value value = this.parseBlockObjectIdentifierValue();
                if (null == value) {
                    value = new ObjectIdentifier_Value();
                }
                value.setFullNameParent(this.getNameParent());
                value.copyGeneralProperties(this);
                this.realValue = value;
                break;
            }
            case RELATIVEOBJECTIDENTIFIER_VALUE: {
                RelativeObjectIdentifier_Value value = this.parseBlockRelativeObjectIdentifierValue();
                if (null == value) {
                    value = new RelativeObjectIdentifier_Value();
                }
                value.setFullNameParent(this.getNameParent());
                value.copyGeneralProperties(this);
                this.realValue = value;
                break;
            }
            default: {
                this.realValue = super.setValuetype(timestamp, newType);
            }
        }
        return this.realValue;
    }

    private Named_Bits parseBlockNamedBits() {
        if (null == this.mBlock) {
            return null;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return null;
        }
        Named_Bits namedBits = parser.pr_special_NamedBitListValue().named_bits;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
            return null;
        }
        return namedBits;
    }

    private SequenceOf_Value parseBlockSeqofValue() {
        if (null == this.mBlock) {
            return null;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return null;
        }
        SequenceOf_Value value = parser.pr_special_SeqOfValue().value;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
            return null;
        }
        return value;
    }

    private SetOf_Value parseBlockSetofValue() {
        if (null == this.mBlock) {
            return null;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return null;
        }
        SetOf_Value value = parser.pr_special_SetOfValue().value;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
            return null;
        }
        return value;
    }

    private Sequence_Value parseBlockSequenceValue() {
        if (null == this.mBlock) {
            return null;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return null;
        }
        Sequence_Value value = parser.pr_special_SequenceValue().value;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
            return null;
        }
        return value;
    }

    private Set_Value parseBlockSetValue() {
        if (null == this.mBlock) {
            return null;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return null;
        }
        Set_Value value = parser.pr_special_SetValue().value;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
            return null;
        }
        return value;
    }

    private ObjectIdentifier_Value parseBlockObjectIdentifierValue() {
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return null;
        }
        ObjectIdentifier_Value value = parser.pr_special_ObjectIdentifierValue().value;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
            return null;
        }
        return value;
    }

    private RelativeObjectIdentifier_Value parseBlockRelativeObjectIdentifierValue() {
        if (null == this.mBlock) {
            return null;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return null;
        }
        RelativeObjectIdentifier_Value value = parser.pr_special_RelativeObjectIdentifierValue().value;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
            return null;
        }
        return value;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        if (null == this.realValue || this.realValue.getIsErroneous(timestamp)) {
            return false;
        }
        return this.realValue.checkEquality(timestamp, other);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (null == this.realValue || this.realValue.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        this.realValue.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.realValue == null || this.realValue.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) || this.realValue.accept(v);
    }

    @Override
    public Location getLocation() {
        if (null != this.mBlock) {
            return this.mBlock.getLocation();
        }
        return null;
    }
}

