/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Selection_Type
extends ASN1Type
implements IReferencingType {
    private static final String CHOICEFERENCEEXPECTED = "(Reference to) a CHOICE type was expected in selection type";
    private static final String MISSINGALTERNATIVE = "No alternative with name `{0}'' in the given type `{1}''";
    private final Identifier identifier;
    private final IASN1Type selectionType;
    private IType referencedLast;

    public Selection_Type(Identifier identifier, IASN1Type selectionType) {
        this.identifier = identifier;
        this.selectionType = selectionType;
        if (null != selectionType) {
            selectionType.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_SELECTION;
    }

    @Override
    public IASN1Type newInstance() {
        return new Selection_Type(this.identifier, this.selectionType.newInstance());
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.selectionType) {
            this.selectionType.setMyScope(scope);
        }
    }

    @Override
    public String chainedDescription() {
        return "selection type with name: " + this.identifier.getDisplayName();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        if (null == this.selectionType) {
            return false;
        }
        IType t1 = this.selectionType.getTypeRefdLast(timestamp);
        IType t2 = otherType.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isCompatible(timestamp, t2, null, null, null);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public String getTypename() {
        if (this.isErroneous || null == this.selectionType || this == this.selectionType) {
            return "Selection type";
        }
        return this.selectionType.getTypename();
    }

    @Override
    public String getOutlineIcon() {
        return "asn1_selection.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        builder.append("selection of ");
        if (null != this.selectionType) {
            this.selectionType.getProposalDescription(builder);
        }
        return builder;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        this.referencedLast = this.getTypeRefdLast(timestamp);
        if (!this.referencedLast.getIsErroneous(timestamp)) {
            this.referencedLast.check(timestamp);
        }
        if (null != this.selectionType) {
            this.selectionType.check(timestamp);
        }
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            Type refd = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (null == refd) {
                return value;
            }
            return refd.checkThisValueRef(timestamp, value);
        }
        return value;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        Type last = this.getTypeRefd(timestamp, refChain);
        refChain.release();
        if (null != last && last != this) {
            last.checkThisValue(timestamp, value, valueCheckingOptions);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            tempType.checkThisTemplate(timestamp, template, isModified, implicitOmit);
        }
    }

    @Override
    public Type getTypeRefd(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (refChain.add(this) && !this.getIsErroneous(timestamp)) {
            IType type = this.selectionType.getTypeRefdLast(timestamp);
            if (type.getIsErroneous(timestamp)) {
                this.isErroneous = true;
                this.lastTimeChecked = timestamp;
                return this;
            }
            if (IType.Type_type.TYPE_ASN1_CHOICE.equals((Object)type.getTypetype())) {
                if (((ASN1_Choice_Type)type).hasComponentWithName(this.identifier)) {
                    return ((ASN1_Choice_Type)type).getComponentByName(this.identifier).getType();
                }
                String message = MessageFormat.format(MISSINGALTERNATIVE, this.identifier.getDisplayName(), type.getFullName());
                this.location.reportSemanticError(message);
            } else {
                this.selectionType.getLocation().reportSemanticError(CHOICEFERENCEEXPECTED);
            }
        }
        this.isErroneous = true;
        this.lastTimeChecked = timestamp;
        return this;
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        IType type = this;
        while (null != type && type instanceof IReferencingType && !type.getIsErroneous(timestamp)) {
            type = ((IReferencingType)((Object)type)).getTypeRefd(timestamp, tempReferenceChain);
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        return type;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            Type type = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (null != type && !type.getIsErroneous(timestamp) && !this.equals(type)) {
                type.checkRecursions(timestamp, referenceChain);
            }
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null != this.referencedLast && this != this.referencedLast) {
            Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
            return this.referencedLast.getFieldType(timestamp, reference, actualSubReference, internalExpectation, refChain, interruptIfOptional);
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.selectionType != null) {
            this.selectionType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        return this.selectionType == null || this.selectionType.accept(v);
    }
}

