/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Choice_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Choice_Type
extends ASN1_Set_Seq_Choice_BaseType {
    private static final String MISSINGALTERNATIVE = "CHOICE type must have at least one alternative";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for union type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for union type `{0}''";
    private static final String ONEFIELDEXPECTED = "A template for union type must contain exactly one selected field";
    private static final String REFERENCETONONEXISTENTFIELD = "Reference to non-existent field `{0}'' in union template for type `{1}''";
    private static final String CHOICEEXPECTED = "CHOICE value was expected for type `{0}''";
    private static final String UNIONEXPECTED = "Union value was expected for type `{0}''";
    private static final String NONEXISTENTCHOICE = "Reference to a non-existent alternative `{0}'' in CHOICE value for type `{1}''";
    private static final String NONEXISTENTUNION = "Reference to a non-existent field `{0}'' in union value for type `{1}''";
    private static final String NOCOMPATIBLEFIELD = "union/CHOICE type `{0}'' doesn''t have any field compatible with `{1}''";
    private static final String NOTCOMPATIBLEUNION = "union/CHOICE types are compatible only with other union/CHOICE types";

    public ASN1_Choice_Type(Block aBlock) {
        this.mBlock = aBlock;
        this.setLocation(new Location(aBlock.getLocation()));
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Choice_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ASN1_CHOICE;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_CHOICE;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (null == info || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_CHOICE: {
                ASN1_Choice_Type temporalType = (ASN1_Choice_Type)temp;
                if (this == temporalType) {
                    return true;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (null == lChain) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (null == rChain) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                int size = this.getNofComponents(timestamp);
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    int size2 = temporalType.getNofComponents(timestamp);
                    for (int j = 0; j < size2; ++j) {
                        CompField temporalCompField = temporalType.getComponentByIndex(j);
                        IType tempTypeCompFieldType = temporalCompField.getType().getTypeRefdLast(timestamp);
                        if (!cf.getIdentifier().getDisplayName().equals(temporalCompField.getIdentifier().getDisplayName())) continue;
                        lChain.markState();
                        rChain.markState();
                        lChain.add(cfType);
                        rChain.add(tempTypeCompFieldType);
                        if (cfType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCompFieldType, info, lChain, rChain)) {
                            info.setNeedsConversion(true);
                            lChain.previousState();
                            rChain.previousState();
                            return true;
                        }
                        lChain.previousState();
                        rChain.previousState();
                    }
                }
                info.setErrorStr(MessageFormat.format(NOCOMPATIBLEFIELD, temp.getTypename(), this.getTypename()));
                return false;
            }
            case TYPE_TTCN3_CHOICE: {
                TTCN3_Choice_Type temporalType = (TTCN3_Choice_Type)temp;
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                int size = this.getNofComponents(timestamp);
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType compFieldType = cf.getType().getTypeRefdLast(timestamp);
                    int size2 = temporalType.getNofComponents();
                    for (int j = 0; j < size2; ++j) {
                        CompField temporalCompField = temporalType.getComponentByIndex(j);
                        IType tempTypeCompFieldType = temporalCompField.getType().getTypeRefdLast(timestamp);
                        if (!cf.getIdentifier().getDisplayName().equals(temporalCompField.getIdentifier().getDisplayName())) continue;
                        lChain.markState();
                        rChain.markState();
                        lChain.add(compFieldType);
                        rChain.add(tempTypeCompFieldType);
                        if (compFieldType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeCompFieldType, info, lChain, rChain)) {
                            info.setNeedsConversion(true);
                            lChain.previousState();
                            rChain.previousState();
                            return true;
                        }
                        lChain.previousState();
                        rChain.previousState();
                    }
                }
                info.setErrorStr(MessageFormat.format(NOCOMPATIBLEFIELD, temp.getTypename(), this.getTypename()));
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: 
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNION);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "asn1_choice.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("choice");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        Type type;
        if (this.components == null) {
            return;
        }
        if (referenceChain.add(this) && this.components.getNofComps() == 1 && (type = this.components.getCompByIndex(0).getType()) != null) {
            referenceChain.markState();
            type.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.components != null && this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        this.isErroneous = false;
        if (this.components == null) {
            this.parseBlockChoice();
        }
        if (this.isErroneous || this.components == null) {
            return;
        }
        this.components.check(timestamp);
        if (this.components.getNofComps() <= 0 && this.location != null) {
            this.location.reportSemanticError(MISSINGALTERNATIVE);
        }
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                if ((last = last.setValuetype(timestamp, IValue.Value_type.CHOICE_VALUE)).getIsErroneous(timestamp)) break;
                this.checkThisValueChoice(timestamp, (Choice_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed);
                break;
            }
            case CHOICE_VALUE: {
                this.checkThisValueChoice(timestamp, (Choice_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                } else {
                    value.getLocation().reportSemanticError(MessageFormat.format(UNIONEXPECTED, this.getFullName()));
                }
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueChoice(CompilationTimeStamp timestamp, Choice_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed) {
        Identifier name = value.getName();
        if (!this.hasComponentWithName(name)) {
            if (value.isAsn()) {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTCHOICE, name.getDisplayName(), this.getFullName()));
                value.setIsErroneous(true);
            } else {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTUNION, name.getDisplayName(), this.getFullName()));
                value.setIsErroneous(true);
            }
            value.setLastTimeChecked(timestamp);
            return;
        }
        Type alternativeType = this.getComponentByName(name).getType();
        IValue alternativeValue = value.getValue();
        if (alternativeValue == null) {
            return;
        }
        alternativeValue.setMyGovernor(alternativeType);
        alternativeValue = alternativeType.checkThisValueRef(timestamp, alternativeValue);
        alternativeType.checkThisValue(timestamp, alternativeValue, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, false, false));
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        if (ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)template.getTemplatetype())) {
            Named_Template_List namedTemplateList = (Named_Template_List)template;
            int nofTemplates = namedTemplateList.getNofTemplates();
            if (nofTemplates != 1) {
                template.getLocation().reportSemanticError(ONEFIELDEXPECTED);
            }
            for (int i = 0; i < nofTemplates; ++i) {
                NamedTemplate namedTemplate = namedTemplateList.getTemplateByIndex(i);
                Identifier name = namedTemplate.getName();
                CompField field = this.components.getCompByName(name);
                if (field == null) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(REFERENCETONONEXISTENTFIELD, name.getDisplayName(), this.getFullName()));
                    continue;
                }
                Type fieldType = field.getType();
                if (fieldType == null || fieldType.getIsErroneous(timestamp)) continue;
                ITTCN3Template namedTemplateTemplate = namedTemplate.getTemplate();
                namedTemplateTemplate.setMyGovernor(fieldType);
                namedTemplateTemplate = fieldType.checkThisTemplateRef(timestamp, namedTemplateTemplate);
                ITTCN3Template.Completeness_type completeness = namedTemplateList.getCompletenessConditionChoice(timestamp, isModified, name);
                namedTemplateTemplate.checkThisTemplateGeneric(timestamp, fieldType, ITTCN3Template.Completeness_type.MAY_INCOMPLETE.equals((Object)completeness), false, false, true, implicitOmit);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
    }

    private void parseBlockChoice() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.components = parser.pr_special_AlternativeTypeLists().list;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            this.components = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.components == null) {
            this.isErroneous = true;
            return;
        }
        this.components.setFullNameParent(this);
        this.components.setMyScope(this.getMyScope());
        this.components.setMyType(this);
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }
}

