/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class TargetStatus {
    private static final String TARGET_STATUS_ID = "targetStatus";
    private static StatusLineContributionItem targetStatus;

    private static StatusLineContributionItem getContributionItem() {
        if (targetStatus == null) {
            targetStatus = new TargetStatusLineContributionItem();
        }
        return targetStatus;
    }

    private static IStatusLineManager getStatusLineManager(IWorkbenchWindow window) {
        return window instanceof WorkbenchWindow ? ((WorkbenchWindow)window).getStatusLineManager() : null;
    }

    public static void initializeTargetStatus() {
        PDEPreferencesManager prefs = PDEPlugin.getDefault().getPreferenceManager();
        boolean showStatus = prefs.getBoolean("Preferences.MainPage.showTargetStatus");
        if (showStatus) {
            UIJob updateStatus = new UIJob("Refresh PDE Target Status"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        IStatusLineManager slManager = TargetStatus.getStatusLineManager(windows[i]);
                        if (slManager != null) {
                            slManager.appendToGroup("BEGIN_GROUP", (IContributionItem)TargetStatus.getContributionItem());
                            slManager.update(false);
                            break;
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            updateStatus.setSystem(true);
            updateStatus.setPriority(50);
            updateStatus.schedule();
        }
    }

    public static void refreshTargetStatus() {
        PDEPreferencesManager prefs = PDEPlugin.getDefault().getPreferenceManager();
        boolean showStatus = prefs.getBoolean("Preferences.MainPage.showTargetStatus");
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IStatusLineManager manager = TargetStatus.getStatusLineManager(windows[i]);
            if (manager != null) {
                if (showStatus) {
                    manager.remove(TARGET_STATUS_ID);
                    manager.appendToGroup("BEGIN_GROUP", (IContributionItem)TargetStatus.getContributionItem());
                } else {
                    manager.remove(TARGET_STATUS_ID);
                }
                manager.update(false);
                break;
            }
            ++i;
        }
    }

    public static void refreshTargetStatusContent() {
        PDEPreferencesManager prefs = PDEPlugin.getDefault().getPreferenceManager();
        boolean showStatus = prefs.getBoolean("Preferences.MainPage.showTargetStatus");
        if (showStatus) {
            TargetStatus.getContributionItem().update();
        }
    }

    private static class TargetStatusLineContributionItem
    extends StatusLineContributionItem {
        TargetDefinition fRunningHost;
        private final IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ("workspace_target_handle".equals(event.getKey())) {
                    TargetStatusLineContributionItem.this.update();
                }
            }
        };

        public TargetStatusLineContributionItem() {
            super(TargetStatus.TARGET_STATUS_ID, true, 22);
            PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
            this.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_TARGET_DEFINITION));
            this.fRunningHost = (TargetDefinition)TargetPlatformService.getDefault().newDefaultTarget();
            this.update();
            this.setActionHandler((IAction)new Action(){

                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)"org.eclipse.pde.ui.TargetPlatformPreferencePage", null, null);
                    dialog.open();
                }
            });
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.core");
            node.addPreferenceChangeListener(this.prefListener);
        }

        public void dispose() {
            PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
            super.dispose();
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.core");
            node.removePreferenceChangeListener(this.prefListener);
        }

        public void update() {
            int flag = 0;
            String result = Messages.TargetStatus_TargetStatusDefaultString;
            String statusMessage = null;
            try {
                Image newImage;
                ITargetHandle handle = TargetPlatformService.getDefault().getWorkspaceTargetHandle();
                if (handle != null) {
                    ITargetDefinition target = TargetPlatformService.getDefault().getWorkspaceTargetDefinition();
                    String name = target.getName();
                    if (name != null && name.length() > 0) {
                        result = name;
                    }
                    if (target.isResolved()) {
                        IStatus status = target.getStatus();
                        if (status.getSeverity() == 2) {
                            flag = 2;
                            statusMessage = this.getStatusMessage(status).toString();
                        } else if (status.getSeverity() == 4) {
                            flag = 1;
                            statusMessage = this.getStatusMessage(status).toString();
                        }
                    } else {
                        flag = 2;
                        result = NLS.bind((String)Messages.TargetStatus_UnresolvedTarget, (Object)name);
                        statusMessage = NLS.bind((String)(String.valueOf('\n') + Messages.TargetStatus_UnresolvedTargetStatus), (Object)name);
                    }
                    newImage = this.fRunningHost != null && this.fRunningHost.isContentEquivalent(target) ? PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_BRANDING, flag) : PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_TARGET_DEFINITION, flag);
                } else {
                    result = Messages.TargetStatus_NoActiveTargetPlatformStatus;
                    newImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_TARGET_DEFINITION);
                }
                final String newValue = result;
                final String newTooltip = statusMessage == null ? newValue : String.valueOf(newValue) + statusMessage;
                UIJob job = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        targetStatus.setText(newValue);
                        TargetStatusLineContributionItem.this.setImage(newImage);
                        TargetStatusLineContributionItem.this.setToolTipText(newTooltip);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }

        private StringBuffer getStatusMessage(IStatus status) {
            StringBuffer result = new StringBuffer();
            if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int i = 0;
                while (i < children.length) {
                    result.append(this.getStatusMessage(children[i]));
                    ++i;
                }
            } else {
                result.append('\n').append(status.getMessage());
            }
            return result;
        }
    }
}

