/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XliaModelKind implements Enumerator
{
    SYSTEM(0, "system", "system"),
    PACKAGE(1, "package", "package");

    public static final int SYSTEM_VALUE = 0;
    public static final int PACKAGE_VALUE = 1;
    private static final XliaModelKind[] VALUES_ARRAY;
    public static final List<XliaModelKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XliaModelKind[]{SYSTEM, PACKAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XliaModelKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XliaModelKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XliaModelKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XliaModelKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XliaModelKind get(int value) {
        switch (value) {
            case 0: {
                return SYSTEM;
            }
            case 1: {
                return PACKAGE;
            }
        }
        return null;
    }

    private XliaModelKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

