/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAGLayout<V, E>
extends SpringLayout<V, E> {
    private Map<V, Number> minLevels = new HashMap<V, Number>();
    static int graphHeight;
    static int numRoots;
    final double SPACEFACTOR = 1.3;
    final double LEVELATTRACTIONRATE = 0.8;
    final double MSV_THRESHOLD = 10.0;
    double meanSquareVel;
    boolean stoppingIncrements = false;
    int incrementsLeft;
    final int COOL_DOWN_INCREMENTS = 200;

    public DAGLayout(Graph<V, E> g) {
        super(g);
    }

    public void setRoot(Graph<V, E> g) {
        numRoots = 0;
        for (Object v : g.getVertices()) {
            Collection successors = this.getGraph().getSuccessors(v);
            if (successors.size() != 0) continue;
            this.setRoot(v);
            ++numRoots;
        }
    }

    public void setRoot(V v) {
        this.minLevels.put((Number)v, new Integer(0));
        this.propagateMinimumLevel(v);
    }

    public void propagateMinimumLevel(V v) {
        int level = this.minLevels.get(v).intValue();
        for (Object child : this.getGraph().getPredecessors(v)) {
            Number o = this.minLevels.get(child);
            int oldLevel = o != null ? o.intValue() : 0;
            int newLevel = Math.max(oldLevel, level + 1);
            this.minLevels.put((Number)child, new Integer(newLevel));
            if (newLevel > graphHeight) {
                graphHeight = newLevel;
            }
            this.propagateMinimumLevel(child);
        }
    }

    private void initializeLocation(V v, Point2D coord, Dimension d) {
        int level = this.minLevels.get(v).intValue();
        int minY = (int)((double)level * d.getHeight() / ((double)graphHeight * 1.3));
        double x = Math.random() * d.getWidth();
        double y = Math.random() * (d.getHeight() - (double)minY) + (double)minY;
        coord.setLocation(x, y);
    }

    @Override
    public void setSize(Dimension size) {
        super.setSize(size);
        for (Object v : this.getGraph().getVertices()) {
            this.initializeLocation(v, (Point2D)this.transform(v), this.getSize());
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setRoot((V)this.getGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void moveNodes() {
        double oldMSV = this.meanSquareVel;
        this.meanSquareVel = 0.0;
        Dimension dimension = this.getSize();
        synchronized (dimension) {
            for (Object v : this.getGraph().getVertices()) {
                if (this.isLocked(v)) continue;
                SpringLayout.SpringVertexData vd = (SpringLayout.SpringVertexData)this.springVertexData.get(v);
                Object xyd = this.transform(v);
                int width = this.getSize().width;
                int height = this.getSize().height;
                int level = this.minLevels.get(v).intValue();
                int minY = (int)((double)(level * height) / ((double)graphHeight * 1.3));
                int maxY = level == 0 ? (int)((double)height / ((double)graphHeight * 1.3 * 2.0)) : height;
                vd.dx += 2.0 * vd.repulsiondx + vd.edgedx;
                vd.dy += vd.repulsiondy + vd.edgedy;
                double delta = ((Point2D)xyd).getY() - (double)minY;
                vd.dy -= delta * 0.8;
                if (level == 0) {
                    vd.dy -= delta * 0.8;
                }
                this.meanSquareVel += vd.dx * vd.dx + vd.dy * vd.dy;
                ((Point2D)xyd).setLocation(((Point2D)xyd).getX() + Math.max(-5.0, Math.min(5.0, vd.dx)), ((Point2D)xyd).getY() + Math.max(-5.0, Math.min(5.0, vd.dy)));
                if (((Point2D)xyd).getX() < 0.0) {
                    ((Point2D)xyd).setLocation(0.0, ((Point2D)xyd).getY());
                } else if (((Point2D)xyd).getX() > (double)width) {
                    ((Point2D)xyd).setLocation(width, ((Point2D)xyd).getY());
                }
                if (((Point2D)xyd).getY() < (double)minY) {
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), minY);
                } else if (((Point2D)xyd).getY() > (double)maxY) {
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), maxY);
                }
                if (numRoots != 1 || level != 0) continue;
                ((Point2D)xyd).setLocation(width / 2, ((Point2D)xyd).getY());
            }
        }
        if (!this.stoppingIncrements && Math.abs(this.meanSquareVel - oldMSV) < 10.0) {
            this.stoppingIncrements = true;
            this.incrementsLeft = 200;
        } else if (this.stoppingIncrements && Math.abs(this.meanSquareVel - oldMSV) <= 10.0) {
            --this.incrementsLeft;
            if (this.incrementsLeft <= 0) {
                this.incrementsLeft = 0;
            }
        }
    }

    @Override
    public boolean done() {
        return this.stoppingIncrements && this.incrementsLeft == 0;
    }

    @Override
    public void setLocation(V picked, double x, double y) {
        Object coord = this.transform((Object)picked);
        ((Point2D)coord).setLocation(x, y);
        this.stoppingIncrements = false;
    }

    @Override
    public void setLocation(V picked, Point2D p) {
        Object coord = this.transform((Object)picked);
        ((Point2D)coord).setLocation(p);
        this.stoppingIncrements = false;
    }

    @Override
    protected void relaxEdges() {
        for (Object e : this.getGraph().getEdges()) {
            Pair endpoints = this.getGraph().getEndpoints(e);
            Object v1 = endpoints.getFirst();
            Object v2 = endpoints.getSecond();
            Object p1 = this.transform(v1);
            Object p2 = this.transform(v2);
            double vx = ((Point2D)p1).getX() - ((Point2D)p2).getX();
            double vy = ((Point2D)p1).getY() - ((Point2D)p2).getY();
            double len = Math.sqrt(vx * vx + vy * vy);
            int level1 = this.minLevels.get(v1).intValue();
            int level2 = this.minLevels.get(v2).intValue();
            double desiredLen = ((Integer)this.lengthFunction.transform(e)).intValue();
            len = len == 0.0 ? 1.0E-4 : len;
            double f = this.force_multiplier * (desiredLen - len) / len;
            f *= Math.pow(this.stretch / 100.0, this.getGraph().degree(v1) + this.getGraph().degree(v2) - 2);
            if (level1 != level2) {
                f /= Math.pow(Math.abs(level2 - level1), 1.5);
            }
            double dx = f * vx;
            double dy = f * vy;
            SpringLayout.SpringVertexData v1D = (SpringLayout.SpringVertexData)this.springVertexData.get(v1);
            SpringLayout.SpringVertexData v2D = (SpringLayout.SpringVertexData)this.springVertexData.get(v2);
            v1D.edgedx += dx;
            v1D.edgedy += dy;
            v2D.edgedx += -dx;
            v2D.edgedy += -dy;
        }
    }
}

