/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import edu.uci.ics.jung.algorithms.generators.EvolvingGraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarabasiAlbertGenerator<V, E>
implements EvolvingGraphGenerator<V, E> {
    private Graph<V, E> mGraph = null;
    private int mNumEdgesToAttachPerStep;
    private int mElapsedTimeSteps;
    private Random mRandom;
    protected List<V> vertex_index;
    protected int init_vertices;
    protected Map<V, Integer> index_vertex;
    protected Factory<Graph<V, E>> graphFactory;
    protected Factory<V> vertexFactory;
    protected Factory<E> edgeFactory;

    public BarabasiAlbertGenerator(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int init_vertices, int numEdgesToAttach, int seed, Set<V> seedVertices) {
        assert (init_vertices > 0) : "Number of initial unconnected 'seed' vertices must be positive";
        assert (numEdgesToAttach > 0) : "Number of edges to attach at each time step must be positive";
        this.mNumEdgesToAttachPerStep = numEdgesToAttach;
        this.mRandom = new Random(seed);
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.init_vertices = init_vertices;
        this.initialize(seedVertices);
    }

    public BarabasiAlbertGenerator(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int init_vertices, int numEdgesToAttach, Set<V> seedVertices) {
        this(graphFactory, vertexFactory, edgeFactory, init_vertices, numEdgesToAttach, (int)System.currentTimeMillis(), seedVertices);
    }

    private void initialize(Set<V> seedVertices) {
        this.mGraph = (Graph)this.graphFactory.create();
        this.vertex_index = new ArrayList<V>(2 * this.init_vertices);
        this.index_vertex = new HashMap<V, Integer>(2 * this.init_vertices);
        for (int i = 0; i < this.init_vertices; ++i) {
            Object v = this.vertexFactory.create();
            this.mGraph.addVertex(v);
            this.vertex_index.add(v);
            this.index_vertex.put((Integer)v, i);
            seedVertices.add(v);
        }
        this.mElapsedTimeSteps = 0;
    }

    private void createRandomEdge(Collection<V> preexistingNodes, V newVertex, Set<Pair<V>> added_pairs) {
        Pair<V> endpoints;
        V attach_point;
        boolean created_edge = false;
        do {
            double degree;
            double attach_prob;
            attach_point = this.vertex_index.get(this.mRandom.nextInt(this.vertex_index.size()));
            endpoints = new Pair<V>(newVertex, attach_point);
            if (!(this.mGraph instanceof MultiGraph) && (added_pairs.contains(endpoints) || this.mGraph.getDefaultEdgeType() == EdgeType.UNDIRECTED && added_pairs.contains(new Pair<V>(attach_point, newVertex))) || !((attach_prob = ((degree = (double)this.mGraph.inDegree(attach_point)) + 1.0) / (double)(this.mGraph.getEdgeCount() + this.mGraph.getVertexCount() - 1)) >= this.mRandom.nextDouble())) continue;
            created_edge = true;
        } while (!created_edge);
        added_pairs.add(endpoints);
        if (this.mGraph.getDefaultEdgeType() == EdgeType.UNDIRECTED) {
            added_pairs.add(new Pair<V>(attach_point, newVertex));
        }
    }

    @Override
    public void evolveGraph(int numTimeSteps) {
        for (int i = 0; i < numTimeSteps; ++i) {
            this.evolveGraph();
            ++this.mElapsedTimeSteps;
        }
    }

    private void evolveGraph() {
        Collection preexistingNodes = this.mGraph.getVertices();
        Object newVertex = this.vertexFactory.create();
        this.mGraph.addVertex(newVertex);
        HashSet<Pair<V>> added_pairs = new HashSet<Pair<V>>(this.mNumEdgesToAttachPerStep * 3);
        for (int i = 0; i < this.mNumEdgesToAttachPerStep; ++i) {
            this.createRandomEdge(preexistingNodes, newVertex, added_pairs);
        }
        for (Pair pair : added_pairs) {
            Object v1 = pair.getFirst();
            Object v2 = pair.getSecond();
            if (this.mGraph.getDefaultEdgeType() == EdgeType.UNDIRECTED && this.mGraph.isNeighbor(v1, v2)) continue;
            this.mGraph.addEdge(this.edgeFactory.create(), pair);
        }
        this.vertex_index.add(newVertex);
        this.index_vertex.put((Integer)newVertex, new Integer(this.vertex_index.size() - 1));
    }

    @Override
    public int numIterations() {
        return this.mElapsedTimeSteps;
    }

    public Graph<V, E> create() {
        return this.mGraph;
    }
}

