/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.merge;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.merge.GitCachedResourceVariantTree;
import org.eclipse.egit.core.internal.merge.GitResourceVariantCache;
import org.eclipse.egit.core.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.egit.core.internal.storage.TreeParserResourceVariant;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.team.core.variants.IResourceVariantTree;

public class TreeWalkResourceVariantTreeProvider
implements GitResourceVariantTreeProvider {
    private final IResourceVariantTree baseTree;
    private final IResourceVariantTree oursTree;
    private final IResourceVariantTree theirsTree;
    private final Set<IResource> roots;
    private final Set<IResource> knownResources;

    public TreeWalkResourceVariantTreeProvider(Repository repository, TreeWalk treeWalk, int baseIndex, int ourIndex, int theirIndex) throws IOException {
        AbstractTreeIterator[] initialTrees = new AbstractTreeIterator[treeWalk.getTreeCount()];
        int i = 0;
        while (i < treeWalk.getTreeCount()) {
            initialTrees[i] = treeWalk.getTree(i, AbstractTreeIterator.class);
            ++i;
        }
        GitResourceVariantCache baseCache = new GitResourceVariantCache();
        GitResourceVariantCache theirsCache = new GitResourceVariantCache();
        GitResourceVariantCache oursCache = new GitResourceVariantCache();
        while (treeWalk.next()) {
            int modeBase = treeWalk.getRawMode(baseIndex);
            int modeOurs = treeWalk.getRawMode(ourIndex);
            int modeTheirs = treeWalk.getRawMode(theirIndex);
            if (modeBase == 0 && modeOurs == 0 && modeTheirs == 0) continue;
            CanonicalTreeParser base = (CanonicalTreeParser)treeWalk.getTree(baseIndex, CanonicalTreeParser.class);
            CanonicalTreeParser ours = (CanonicalTreeParser)treeWalk.getTree(ourIndex, CanonicalTreeParser.class);
            CanonicalTreeParser theirs = (CanonicalTreeParser)treeWalk.getTree(theirIndex, CanonicalTreeParser.class);
            Path path = new Path(treeWalk.getPathString());
            IResource resource = ResourceUtil.getResourceHandleForLocation((IPath)path);
            if (resource.getProject() != null && resource.getProject().isAccessible()) {
                if (modeBase != 0) {
                    baseCache.setVariant(resource, TreeParserResourceVariant.create(repository, base));
                }
                if (modeOurs != 0) {
                    oursCache.setVariant(resource, TreeParserResourceVariant.create(repository, ours));
                }
                if (modeTheirs != 0) {
                    theirsCache.setVariant(resource, TreeParserResourceVariant.create(repository, theirs));
                }
            }
            if (!treeWalk.isSubtree()) continue;
            treeWalk.enterSubtree();
        }
        treeWalk.reset();
        int i2 = 0;
        while (i2 < initialTrees.length) {
            initialTrees[i2].reset();
            treeWalk.addTree(initialTrees[i2]);
            ++i2;
        }
        this.baseTree = new GitCachedResourceVariantTree(baseCache);
        this.theirsTree = new GitCachedResourceVariantTree(theirsCache);
        this.oursTree = new GitCachedResourceVariantTree(oursCache);
        this.roots = new LinkedHashSet<IResource>();
        this.roots.addAll(baseCache.getRoots());
        this.roots.addAll(oursCache.getRoots());
        this.roots.addAll(theirsCache.getRoots());
        this.knownResources = new LinkedHashSet<IResource>();
        this.knownResources.addAll(baseCache.getKnownResources());
        this.knownResources.addAll(oursCache.getKnownResources());
        this.knownResources.addAll(theirsCache.getKnownResources());
    }

    @Override
    public IResourceVariantTree getBaseTree() {
        return this.baseTree;
    }

    @Override
    public IResourceVariantTree getRemoteTree() {
        return this.theirsTree;
    }

    @Override
    public IResourceVariantTree getSourceTree() {
        return this.oursTree;
    }

    @Override
    public Set<IResource> getKnownResources() {
        return this.knownResources;
    }

    @Override
    public Set<IResource> getRoots() {
        return this.roots;
    }
}

