/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine.portals;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.Location;
import fr.inria.zvtm.engine.Picker;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.engine.portals.Portal;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.Translucent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Vector;

public class CameraPortal
extends Portal {
    Color borderColor;
    Color bkgColor;
    Camera camera;
    VirtualSpace cameraSpace;
    double viewWC;
    double viewNC;
    double viewEC;
    double viewSC;
    double duncoef;
    Vector drawnGlyphs;
    Glyph[] gll;
    int camIndex;
    Picker picker = new Picker();
    Stroke standardStroke;
    AffineTransform standardTransform;
    AlphaComposite alphaC;

    public CameraPortal(int x, int y, int w, int h, Camera c) {
        this(x, y, w, h, c, 1.0f);
    }

    public CameraPortal(int x, int y, int w, int h, Camera c, float a) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.updateDimensions();
        this.camera = c;
        this.cameraSpace = this.camera.getOwningSpace();
        this.camIndex = this.camera.getIndex();
        this.setTranslucencyValue(a);
    }

    public void setTranslucencyValue(float alpha) {
        this.alphaC = alpha == 1.0f ? null : AlphaComposite.getInstance(3, alpha);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public float getTranslucencyValue() {
        return this.alphaC != null ? this.alphaC.getAlpha() : 1.0f;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Picker getPicker() {
        return this.picker;
    }

    @Override
    public void setOwningView(View v) {
        super.setOwningView(v);
        this.camera.setOwningView(v);
    }

    public void setBorder(Color bc) {
        this.borderColor = bc;
    }

    public Color getBorder() {
        return this.borderColor;
    }

    public void setBackgroundColor(Color bc) {
        this.bkgColor = bc;
    }

    public Color getBackgroundColor() {
        return this.bkgColor;
    }

    public Point2D.Double getVSCoordinates(int cx, int cy) {
        double uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
        return new Point2D.Double(this.camera.vx + ((double)(cx - this.x) - (double)this.w / 2.0) * uncoef, this.camera.vy - ((double)(cy - this.y) - (double)this.h / 2.0) * uncoef);
    }

    public double[] getVisibleRegion(double[] res) {
        double uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
        res[0] = this.camera.vx - (double)this.w / 2.0 * uncoef;
        res[1] = this.camera.vy + (double)this.h / 2.0 * uncoef;
        res[2] = this.camera.vx + (double)this.w / 2.0 * uncoef;
        res[3] = this.camera.vy - (double)this.h / 2.0 * uncoef;
        return res;
    }

    public double[] getVisibleRegion() {
        return this.getVisibleRegion(new double[4]);
    }

    public Location getGlobalView() {
        double tmpRatio;
        double[] wnes = this.cameraSpace.findFarmostGlyphCoords();
        double dx = (wnes[2] + wnes[0]) / 2.0;
        double dy = (wnes[1] + wnes[3]) / 2.0;
        double[] regBounds = this.getVisibleRegion();
        double[] trRegBounds = new double[]{regBounds[0] + dx - this.camera.vx, regBounds[3] + dy - this.camera.vy};
        double currentAlt = this.camera.getAltitude() + this.camera.getFocal();
        double ratio = 0.0;
        if (trRegBounds[0] != 0.0) {
            ratio = (dx - wnes[0]) / (dx - trRegBounds[0]);
        }
        if (trRegBounds[1] != 0.0 && (tmpRatio = (dy - wnes[3]) / (dy - trRegBounds[1])) > ratio) {
            ratio = tmpRatio;
        }
        return new Location(dx, dy, currentAlt * Math.abs(ratio));
    }

    public Location getGlobalView(int d) {
        Location l = this.getGlobalView();
        Animation trans = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraTranslation(d, this.camera, new Point2D.Double(l.vx, l.vy), false, IdentityInterpolator.getInstance(), null);
        Animation altAnim = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraAltAnim(d, this.camera, l.alt, false, IdentityInterpolator.getInstance(), null);
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(trans, false);
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(altAnim, false);
        return l;
    }

    public Location getSeamlessView(Camera c) {
        int hvw = c.getOwningView().getFrame().getWidth() / 2;
        int hvh = c.getOwningView().getFrame().getHeight() / 2;
        double uncoef = (c.focal + c.altitude) / (double)((float)c.focal);
        double[] wnes = new double[]{c.getOwningView().mouse.getVSXCoordinate() - (double)this.w / 2.0 * uncoef, c.getOwningView().mouse.getVSYCoordinate() + (double)this.h / 2.0 * uncoef, c.getOwningView().mouse.getVSXCoordinate() + (double)this.w / 2.0 * uncoef, c.getOwningView().mouse.getVSYCoordinate() - (double)this.h / 2.0 * uncoef};
        return new Location((wnes[2] + wnes[0]) / 2.0, (wnes[1] + wnes[3]) / 2.0, this.camera.focal * ((wnes[2] - wnes[0]) / (double)this.w));
    }

    public Location centerOnRegion(double x1, double y1, double x2, double y2) {
        double tmpRatio;
        double minX = Math.min(x1, x2);
        double minY = Math.min(y1, y2);
        double maxX = Math.max(x1, x2);
        double maxY = Math.max(y1, y2);
        double[] wnes = new double[]{minX, maxY, maxX, minY};
        double dx = (wnes[2] + wnes[0]) / 2.0;
        double dy = (wnes[1] + wnes[3]) / 2.0;
        double[] regBounds = this.getVisibleRegion();
        double[] trRegBounds = new double[]{regBounds[0] + dx - this.camera.vx, regBounds[3] + dy - this.camera.vy};
        double currentAlt = this.camera.getAltitude() + this.camera.getFocal();
        double ratio = 0.0;
        if (trRegBounds[0] != 0.0) {
            ratio = (dx - wnes[0]) / (dx - trRegBounds[0]);
        }
        if (trRegBounds[1] != 0.0 && (tmpRatio = (dy - wnes[3]) / (dy - trRegBounds[1])) > ratio) {
            ratio = tmpRatio;
        }
        double newAlt = currentAlt * Math.abs(ratio);
        return new Location(dx, dy, newAlt);
    }

    public Location centerOnRegion(int d, double x1, double y1, double x2, double y2) {
        Location l = this.centerOnRegion(x1, y1, x2, y2);
        Animation trans = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraTranslation(d, this.camera, l.getPosition(), false, SlowInSlowOutInterpolator.getInstance(), null);
        Animation altAnim = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraAltAnim(d, this.camera, l.getAltitude(), false, SlowInSlowOutInterpolator.getInstance(), null);
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(trans, false);
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(altAnim, false);
        return l;
    }

    @Override
    public boolean coordInside(int cx, int cy) {
        return cx >= this.x && cx <= this.x + this.w && cy >= this.y && cy <= this.y + this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        if (this.alphaC != null) {
            if (this.alphaC.getAlpha() == 0.0f) {
                return;
            }
            g2d.setComposite(this.alphaC);
        }
        if (this.x + this.w < 0 || this.y + this.h < 0 || this.x >= viewWidth || this.y >= viewHeight) {
            return;
        }
        g2d.setClip(this.x, this.y, this.w, this.h);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        Vector vector = this.drawnGlyphs;
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.duncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = this.camera.vx - (double)this.w / 2.0 * this.duncoef;
            this.viewNC = this.camera.vy + (double)this.h / 2.0 * this.duncoef;
            this.viewEC = this.camera.vx + (double)this.w / 2.0 * this.duncoef;
            this.viewSC = this.camera.vy - (double)this.h / 2.0 * this.duncoef;
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInViewport(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camera)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                        this.cameraSpace.drewGlyph(this.gll[i], this.camIndex);
                    }
                    continue;
                }
            }
        }
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
        if (this.alphaC != null) {
            g2d.setComposite(Translucent.acO);
        }
    }

    public void pick(int cx, int cy, ViewListener eh) {
        this.picker.setJPanelCoordinates(cx - this.x, cy - this.y);
        double uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
        double pvx = this.camera.vx + ((double)(cx - this.x) - (double)this.w / 2.0) * uncoef;
        double pvy = this.camera.vy - ((double)(cy - this.y) - (double)this.h / 2.0) * uncoef;
        this.picker.setVSCoordinates(pvx, pvy);
        this.picker.computePickedGlyphList(eh, this.camera);
    }
}

