/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.CameraManager;
import fr.inria.zvtm.engine.Picker;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.RectangularShape;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class VirtualSpace {
    public static final String ANONYMOUS = "AnonVS";
    String spaceName;
    CameraManager cm;
    Vector<Glyph> visualEnts;
    Glyph[] drawingList;
    private Vector<Glyph>[] camera2drawnList;
    Vector<Picker> externalPickers = new Vector(0);

    public static Point2D.Double getGlyphSetGeometricalCenter(Glyph[] gl) {
        if (gl != null && gl.length > 0) {
            double[] tmpC = new double[4];
            double size = gl[0].getSize();
            tmpC[0] = gl[0].vx - size;
            tmpC[1] = gl[0].vy + size;
            tmpC[2] = gl[0].vx + size;
            tmpC[3] = gl[0].vy - size;
            for (int i = 1; i < gl.length; ++i) {
                size = gl[i].getSize();
                double tmp = gl[i].vx - size;
                if (tmp < tmpC[0]) {
                    tmpC[0] = tmp;
                }
                if ((tmp = gl[i].vy + size) > tmpC[1]) {
                    tmpC[1] = tmp;
                }
                if ((tmp = gl[i].vx + size) > tmpC[2]) {
                    tmpC[2] = tmp;
                }
                if (!((tmp = gl[i].vy - size) < tmpC[3])) continue;
                tmpC[3] = tmp;
            }
            return new Point2D.Double((tmpC[2] + tmpC[0]) / 2.0, (tmpC[1] + tmpC[3]) / 2.0);
        }
        return new Point2D.Double(0.0, 0.0);
    }

    VirtualSpace(String n) {
        this.cm = new CameraManager(this);
        this.visualEnts = new Vector();
        this.camera2drawnList = new Vector[0];
        this.drawingList = new Glyph[0];
        this.spaceName = n;
    }

    public String getName() {
        return this.spaceName;
    }

    public Camera getCamera(int i) {
        return this.cm.getCamera(i);
    }

    public Camera[] getCameraListAsArray() {
        return this.cm.cameraList;
    }

    public Camera addCamera() {
        Camera c = this.cm.addCamera();
        Vector[] newDrawnListList = new Vector[this.camera2drawnList.length + 1];
        System.arraycopy(this.camera2drawnList, 0, newDrawnListList, 0, this.camera2drawnList.length);
        newDrawnListList[this.camera2drawnList.length] = new Vector();
        this.camera2drawnList = newDrawnListList;
        c.setOwningSpace(this);
        Enumeration<Glyph> e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            Glyph g = e.nextElement();
            g.addCamera(c.getIndex());
        }
        return c;
    }

    public void removeCamera(int i) {
        if (this.cm.cameraList.length > i) {
            for (int j = 0; j < VirtualSpaceManager.INSTANCE.allViews.length; ++j) {
                if (!VirtualSpaceManager.INSTANCE.allViews[j].cameras.contains(this.cm.getCamera(i))) continue;
                VirtualSpaceManager.INSTANCE.allViews[j].destroyCamera(this.cm.getCamera(i));
            }
            Enumeration<Glyph> e = this.visualEnts.elements();
            while (e.hasMoreElements()) {
                Glyph g = e.nextElement();
                g.removeCamera(i);
            }
            this.cm.removeCamera(i);
            this.camera2drawnList[i] = null;
        }
    }

    protected void destroy() {
        for (int i = 0; i < this.cm.cameraList.length; ++i) {
            this.removeCamera(i);
        }
        this.removeAllGlyphs(false);
    }

    public void addGlyph(Glyph g, boolean initColors, boolean repaint) {
        if (g == null) {
            return;
        }
        if (this.contains(g)) {
            if (VirtualSpaceManager.INSTANCE.debugModeON()) {
                System.err.println("VirtualSpace @" + this.hashCode() + " already contains Glyph @" + g.hashCode());
            }
            return;
        }
        if (initColors) {
            g.setCursorInsideHighlightColor(Glyph.getDefaultCursorInsideHighlightColor());
        }
        g.initCams(this.cm.cameraList.length);
        this.visualEnts.add(g);
        this.addGlyphToDrawingList(g);
        if (repaint) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public void addGlyph(Glyph g) {
        this.addGlyph(g, true, true);
    }

    public void addGlyph(Glyph g, boolean repaint) {
        this.addGlyph(g, true, repaint);
    }

    public void addGlyphs(Glyph[] glyphs, boolean repaint) {
        for (Glyph glyph : glyphs) {
            glyph.initCams(this.cm.cameraList.length);
            this.visualEnts.add(glyph);
        }
        this.addGlyphsToDrawingList(glyphs);
        if (repaint) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public void addGlyphs(Glyph[] glyphs) {
        this.addGlyphs(glyphs, true);
    }

    public Vector<Glyph> getAllGlyphs() {
        return this.visualEnts;
    }

    public boolean contains(Glyph g) {
        return this.visualEnts.contains(g);
    }

    public Glyph[] getDrawingList() {
        return this.drawingList;
    }

    public Glyph[] getVisibleGlyphsList() {
        Glyph[] res = new Glyph[this.drawingList.length];
        System.arraycopy(this.drawingList, 0, res, 0, this.drawingList.length);
        return res;
    }

    public Vector<Glyph> getDrawnGlyphs(int cameraIndex) {
        if (cameraIndex < this.camera2drawnList.length) {
            return this.camera2drawnList[cameraIndex];
        }
        return null;
    }

    public void drewGlyph(Glyph gl, int cameraIndex) {
        if (cameraIndex < this.camera2drawnList.length && this.camera2drawnList[cameraIndex] != null) {
            this.camera2drawnList[cameraIndex].add(gl);
        }
    }

    public Vector<Glyph> getSelectedGlyphs() {
        Vector<Glyph> v = new Vector<Glyph>();
        Enumeration<Glyph> e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            Glyph g = e.nextElement();
            if (!g.isSelected()) continue;
            v.add(g);
        }
        return v;
    }

    public void selectAllGlyphs() {
        Enumeration<Glyph> e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            e.nextElement().select(true);
        }
    }

    public void unselectAllGlyphs() {
        Enumeration<Glyph> e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            e.nextElement().select(false);
        }
    }

    public Vector<Glyph> getGlyphsOfType(String t) {
        Vector<Glyph> v = new Vector<Glyph>();
        Enumeration<Glyph> e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            Glyph g = e.nextElement();
            if (!t.equals("") && !t.equals(g.getType())) continue;
            v.add(g);
        }
        return v;
    }

    public void removeAllGlyphs() {
        this.removeAllGlyphs(true);
    }

    public void removeAllGlyphs(boolean repaint) {
        Vector entClone = (Vector)this.getAllGlyphs().clone();
        for (int i = 0; i < entClone.size(); ++i) {
            this.removeGlyph((Glyph)entClone.elementAt(i), false);
        }
        if (repaint) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public void removeGlyph(Glyph g) {
        this.removeGlyph(g, true);
    }

    public void removeGlyph(Glyph g, boolean repaint) {
        try {
            int i;
            if (g.stickedTo != null) {
                if (g.stickedTo instanceof Glyph) {
                    ((Glyph)g.stickedTo).unstick(g);
                } else if (g.stickedTo instanceof Camera) {
                    ((Camera)g.stickedTo).unstick(g);
                } else {
                    ((VCursor)g.stickedTo).unstickGlyph(g);
                }
            }
            for (i = 0; i < this.camera2drawnList.length; ++i) {
                if (this.camera2drawnList[i] == null) continue;
                this.camera2drawnList[i].remove(g);
            }
            for (i = 0; i < this.cm.cameraList.length; ++i) {
                if (this.cm.cameraList[i] == null || this.cm.cameraList[i].view == null) continue;
                this.cm.cameraList[i].view.mouse.getPicker().removeGlyphFromList(g);
            }
            for (Picker p : this.externalPickers) {
                p.removeGlyphFromList(g);
            }
            this.visualEnts.remove(g);
            this.removeGlyphFromDrawingList(g);
            if (repaint) {
                VirtualSpaceManager.INSTANCE.repaint();
            }
        }
        catch (NullPointerException ex) {
            System.err.println("ZVTM Error: VirtualSpace.removeGlyph(): the glyph you are trying to delete might not be a member of this virtual space (" + this.spaceName + ") or might be null");
            ex.printStackTrace();
        }
    }

    public void removeGlyphs(Glyph[] gs, boolean repaint) {
        for (int i = 0; i < gs.length; ++i) {
            Glyph g = gs[i];
            if (g.stickedTo != null) {
                if (g.stickedTo instanceof Glyph) {
                    ((Glyph)g.stickedTo).unstick(g);
                } else if (g.stickedTo instanceof Camera) {
                    ((Camera)g.stickedTo).unstick(g);
                } else {
                    ((VCursor)g.stickedTo).unstickGlyph(g);
                }
            }
            for (int j = 0; j < this.camera2drawnList.length; ++j) {
                if (this.camera2drawnList[j] == null) continue;
                this.camera2drawnList[j].remove(g);
            }
            for (int k = 0; k < this.cm.cameraList.length; ++k) {
                if (this.cm.cameraList[k] == null || this.cm.cameraList[k].view == null) continue;
                this.cm.cameraList[k].view.mouse.getPicker().removeGlyphFromList(g);
            }
            for (Picker p : this.externalPickers) {
                p.removeGlyphFromList(g);
            }
            this.visualEnts.remove(g);
        }
        this.removeGlyphsFromDrawingList(gs);
        if (repaint) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public void removeGlyphs(Glyph[] gs) {
        this.removeGlyphs(gs, true);
    }

    public void show(Glyph g) {
        if (this.visualEnts.contains(g) && this.glyphIndexInDrawingList(g) == -1) {
            this.addGlyphToDrawingList(g);
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void hide(Glyph g) {
        this.removeGlyphFromDrawingList(g);
        g.resetMouseIn();
        for (int i = 0; i < this.cm.cameraList.length; ++i) {
            if (this.cm.cameraList[i] == null || this.cm.cameraList[i].view == null) continue;
            this.cm.cameraList[i].view.mouse.getPicker().removeGlyphFromList(g);
        }
        for (Picker p : this.externalPickers) {
            p.removeGlyphFromList(g);
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void onTop(Glyph g) {
        if (this.glyphIndexInDrawingList(g) != -1) {
            this.removeGlyphFromDrawingList(g);
            this.addGlyphToDrawingList(g);
            g.setZindex(this.drawingList.length > 0 ? this.drawingList[this.drawingList.length - 1].getZindex() : 0);
        }
    }

    public void atBottom(Glyph g) {
        if (this.glyphIndexInDrawingList(g) != -1) {
            this.removeGlyphFromDrawingList(g);
            this.insertGlyphInDrawingList(g, 0);
            g.setZindex(0);
        }
    }

    public void onTop(Glyph g, int z) {
        if (this.glyphIndexInDrawingList(g) != -1) {
            this.removeGlyphFromDrawingList(g);
            int insertAt = 0;
            for (int i = this.drawingList.length - 1; i >= 0; --i) {
                if (this.drawingList[i].getZindex() > z) continue;
                insertAt = i + 1;
                break;
            }
            this.insertGlyphInDrawingList(g, insertAt);
            g.setZindex(z);
        }
    }

    public void atBottom(Glyph g, int z) {
        if (this.glyphIndexInDrawingList(g) != -1) {
            this.removeGlyphFromDrawingList(g);
            int insertAt = 0;
            for (int i = 0; i < this.drawingList.length; ++i) {
                if (this.drawingList[i].getZindex() <= z) continue;
                insertAt = i;
                break;
            }
            this.insertGlyphInDrawingList(g, insertAt);
            g.setZindex(z);
        }
    }

    public void above(Glyph g1, Glyph g2) {
        if (g1 == g2) {
            return;
        }
        if (this.glyphIndexInDrawingList(g1) != -1 && this.glyphIndexInDrawingList(g2) != -1) {
            this.removeGlyphFromDrawingList(g1);
            int i = this.glyphIndexInDrawingList(g2);
            this.insertGlyphInDrawingList(g1, i + 1);
            g1.setZindex(g2.getZindex());
        }
    }

    public void below(Glyph g1, Glyph g2) {
        if (g1 == g2) {
            return;
        }
        if (this.glyphIndexInDrawingList(g1) != -1 && this.glyphIndexInDrawingList(g2) != -1) {
            this.removeGlyphFromDrawingList(g1);
            int i = this.glyphIndexInDrawingList(g2);
            this.insertGlyphInDrawingList(g1, i);
            g1.setZindex(g2.getZindex());
        }
    }

    public Glyph[] getGlyphsInRegion(double x1, double y1, double x2, double y2) {
        Vector<Glyph> res = new Vector<Glyph>();
        double minX = Math.min(x1, x2);
        double minY = Math.min(y1, y2);
        double maxX = Math.max(x1, x2);
        double maxY = Math.max(y1, y2);
        for (Glyph g : this.getAllGlyphs()) {
            if (!(g.vx >= minX) || !(g.vy >= minY) || !(g.vx <= maxX) || !(g.vy <= maxY)) continue;
            res.add(g);
        }
        return res.toArray(new Glyph[res.size()]);
    }

    public double[] findFarmostGlyphCoords() {
        double[] res = new double[4];
        return this.findFarmostGlyphCoords(res);
    }

    public double[] findFarmostGlyphCoords(double[] res) {
        return this.findFarmostGlyphCoords(this.getVisibleGlyphsList(), res);
    }

    public double[] findFarmostGlyphCoords(Glyph[] gl, double[] res) {
        if (gl.length > 0) {
            double size;
            RectangularShape rs;
            if (gl[0] instanceof RectangularShape) {
                rs = (RectangularShape)((Object)gl[0]);
                res[0] = gl[0].vx - rs.getWidth() / 2.0;
                res[1] = gl[0].vy + rs.getHeight() / 2.0;
                res[2] = gl[0].vx + rs.getWidth() / 2.0;
                res[3] = gl[0].vy - rs.getHeight() / 2.0;
            } else {
                size = gl[0].getSize() / 2.0;
                res[0] = gl[0].vx - size;
                res[1] = gl[0].vy + size;
                res[2] = gl[0].vx + size;
                res[3] = gl[0].vy - size;
            }
            for (int i = 1; i < gl.length; ++i) {
                double tmp;
                if (gl[i] instanceof RectangularShape) {
                    rs = (RectangularShape)((Object)gl[i]);
                    tmp = gl[i].vx - rs.getWidth() / 2.0;
                    if (tmp < res[0]) {
                        res[0] = tmp;
                    }
                    if ((tmp = gl[i].vy + rs.getHeight() / 2.0) > res[1]) {
                        res[1] = tmp;
                    }
                    if ((tmp = gl[i].vx + rs.getWidth() / 2.0) > res[2]) {
                        res[2] = tmp;
                    }
                    if (!((tmp = gl[i].vy - rs.getHeight() / 2.0) < res[3])) continue;
                    res[3] = tmp;
                    continue;
                }
                size = gl[i].getSize() / 2.0;
                tmp = gl[i].vx - size;
                if (tmp < res[0]) {
                    res[0] = tmp;
                }
                if ((tmp = gl[i].vy + size) > res[1]) {
                    res[1] = tmp;
                }
                if ((tmp = gl[i].vx + size) > res[2]) {
                    res[2] = tmp;
                }
                if (!((tmp = gl[i].vy - size) < res[3])) continue;
                res[3] = tmp;
            }
            return res;
        }
        Arrays.fill(res, 0.0);
        return res;
    }

    public boolean registerPicker(Picker p) {
        if (!this.externalPickers.contains(p)) {
            this.externalPickers.add(p);
            return true;
        }
        return false;
    }

    public boolean unregisterPicker(Picker p) {
        return this.externalPickers.remove(p);
    }

    protected synchronized void addGlyphToDrawingList(Glyph g) {
        int zindex = g.getZindex();
        int insertAt = 0;
        for (int i = this.drawingList.length - 1; i >= 0; --i) {
            if (this.drawingList[i].getZindex() > zindex) continue;
            insertAt = i + 1;
            break;
        }
        this.insertGlyphInDrawingList(g, insertAt);
    }

    protected synchronized void addGlyphsToDrawingList(Glyph[] glyphs) {
        Glyph[] newDrawingList = new Glyph[this.drawingList.length + glyphs.length];
        System.arraycopy(this.drawingList, 0, newDrawingList, 0, this.drawingList.length);
        System.arraycopy(glyphs, 0, newDrawingList, this.drawingList.length, glyphs.length);
        Arrays.sort(newDrawingList, new Comparator<Glyph>(){

            @Override
            public int compare(Glyph g1, Glyph g2) {
                if (g1.getZindex() < g2.getZindex()) {
                    return -1;
                }
                if (g1.getZindex() > g2.getZindex()) {
                    return 1;
                }
                return 0;
            }
        });
        this.drawingList = newDrawingList;
    }

    protected synchronized void insertGlyphInDrawingList(Glyph g, int index) {
        Glyph[] newDrawingList = new Glyph[this.drawingList.length + 1];
        System.arraycopy(this.drawingList, 0, newDrawingList, 0, index);
        newDrawingList[index] = g;
        System.arraycopy(this.drawingList, index, newDrawingList, index + 1, this.drawingList.length - index);
        this.drawingList = newDrawingList;
    }

    protected synchronized void removeGlyphFromDrawingList(Glyph g) {
        for (int i = 0; i < this.drawingList.length; ++i) {
            if (this.drawingList[i] != g) continue;
            Glyph[] newDrawingList = new Glyph[this.drawingList.length - 1];
            System.arraycopy(this.drawingList, 0, newDrawingList, 0, i);
            System.arraycopy(this.drawingList, i + 1, newDrawingList, i, this.drawingList.length - i - 1);
            this.drawingList = newDrawingList;
            break;
        }
    }

    protected synchronized void removeGlyphsFromDrawingList(Glyph[] glyphs) {
        Glyph[] newDrawingList = new Glyph[this.drawingList.length - glyphs.length];
        int k = 0;
        boolean success = true;
        for (int i = 0; i < this.drawingList.length; ++i) {
            boolean remove = false;
            for (int j = 0; j < glyphs.length; ++j) {
                if (this.drawingList[i] != glyphs[j]) continue;
                remove = true;
                break;
            }
            if (remove) continue;
            if (k < newDrawingList.length) {
                newDrawingList[k++] = this.drawingList[i];
                continue;
            }
            Glyph[] largerDrawingList = new Glyph[newDrawingList.length + 1];
            System.arraycopy(newDrawingList, 0, largerDrawingList, 0, newDrawingList.length);
            largerDrawingList[newDrawingList.length] = this.drawingList[i];
            newDrawingList = largerDrawingList;
        }
        this.drawingList = newDrawingList;
    }

    protected synchronized int glyphIndexInDrawingList(Glyph g) {
        for (int i = 0; i < this.drawingList.length; ++i) {
            if (this.drawingList[i] != g) continue;
            return i;
        }
        return -1;
    }
}

