/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.EndAction;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.glyphs.VTextOr;

public abstract class PieMenu {
    boolean orientText = false;
    ClosedShape[] items;
    Glyph boundary;
    VTextOr[] labels;
    VirtualSpace vs;

    public void destroy() {
        this.destroy(0);
    }

    public void destroy(int animLength) {
        int i;
        this.vs.removeGlyph(this.boundary);
        for (i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] == null) continue;
            this.vs.removeGlyph(this.labels[i]);
        }
        if (animLength > 0) {
            for (i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                Animation sizeAnim = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createGlyphSizeAnim(animLength, this.items[i], 0.1f, false, IdentityInterpolator.getInstance(), new EndAction(){

                    public void execute(Object subject, Animation.Dimension dimension) {
                        PieMenu.this.vs.removeGlyph((Glyph)subject);
                    }
                });
                VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(sizeAnim, false);
            }
        } else {
            for (i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.vs.removeGlyph(this.items[i]);
            }
        }
    }

    public Glyph[] getItems() {
        return this.items;
    }

    public VText[] getLabels() {
        return this.labels;
    }

    public Glyph getBoundary() {
        return this.boundary;
    }

    public int getItemIndex(Glyph g) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != g) continue;
            return i;
        }
        return -1;
    }

    public Glyph getItem(int i) {
        if (i < this.items.length) {
            return this.items[i];
        }
        return null;
    }

    public Glyph getItem(String label) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.labels[i].getText().equals(label)) continue;
            return this.items[i];
        }
        return null;
    }

    public void setSensitivity(boolean b) {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].setSensitivity(b);
        }
        this.boundary.setSensitivity(b);
    }

    public boolean getSensitivity() {
        return this.boundary.isSensitive();
    }
}

