/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.Location;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.RepaintListener;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.lens.Lens;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;

public abstract class ViewPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ComponentListener {
    static final int DEFAULT_DELAY = 20;
    public static final short NONE = 0;
    public static final short OVAL = 1;
    public static final short CIRCLE = 2;
    GraphicsConfiguration gconf;
    protected Graphics2D stableRefToBackBufferGraphics = null;
    public Camera[] cams;
    public int activeLayer = 0;
    public View parent;
    boolean cursor_inside = false;
    boolean repaintable = true;
    ViewListener[] evHs;
    volatile boolean repaintASAP = true;
    RepaintListener repaintListener;
    boolean updateCursorOnly = false;
    boolean notBlank = true;
    Color blankColor = null;
    Color backColor = Color.BLACK;
    Stroke standardStroke;
    AffineTransform standardTransform;
    int[][] visibilityPadding;
    Dimension size;
    int camIndex;
    int beginAt = 0;
    Vector drawnGlyphs;
    Glyph gl;
    Glyph[] gll;
    boolean updateFont = false;
    boolean updateAntialias = true;
    boolean antialias = false;
    protected int oldX = 0;
    protected int oldY = 0;
    protected int origDragx;
    protected int origDragy;
    protected int curDragx;
    protected int curDragy;
    boolean drawDrag = false;
    boolean drawRect = false;
    boolean drawOval = false;
    boolean circleOnly = false;
    protected Image FIRST_ORDER_PAN_WIDGET = new ImageIcon(ViewPanel.class.getResource("/images/1st-order.png")).getImage();
    boolean sfopw = false;
    int fopw_x;
    int fopw_y = 0;
    protected boolean drawVTMcursor = true;
    protected Cursor awtCursor;
    boolean autoRequestFocusOnMouseEnter = false;
    protected Lens lens;
    int cursorInsidePortals = 0;
    public static final int NO_COORDS = -1;
    int ix;
    int iy = -1;
    long delay;
    long lastRepaint = 0L;
    long lastButOneRepaint = 0L;
    Timer timer = new Timer(true);
    int currentTaskID = 0;
    long resizeDelay = 200L;

    abstract void stop();

    void setListener(ViewListener eh, int layer) {
        this.evHs[layer] = eh;
    }

    public ViewListener[] getListeners() {
        return this.evHs;
    }

    public abstract Component getComponent();

    void resetCursorInsidePortals() {
        this.cursorInsidePortals = 0;
        for (int i = 0; i < this.parent.portals.length; ++i) {
            if (!this.parent.portals[i].coordInside(this.oldX, this.oldY)) continue;
            ++this.cursorInsidePortals;
        }
    }

    void updateCursorInsidePortals(int x, int y) {
        for (int i = 0; i < this.parent.portals.length; ++i) {
            this.cursorInsidePortals += this.parent.portals[i].cursorInOut(x, y);
        }
    }

    protected void setAWTCursor(int cursorType) {
        block6: {
            if (cursorType == -1) {
                BufferedImage cImage = new BufferedImage(1, 1, 2);
                try {
                    this.awtCursor = Toolkit.getDefaultToolkit().createCustomCursor(cImage, new Point(0, 0), "zvtmCursor");
                    this.drawVTMcursor = true;
                }
                catch (IndexOutOfBoundsException e) {
                    if (VirtualSpaceManager.debugModeON()) {
                        System.err.println("Error while creating custom cursor " + e);
                        this.awtCursor = new Cursor(1);
                        this.drawVTMcursor = false;
                    }
                    break block6;
                }
            }
            this.drawVTMcursor = false;
            try {
                this.awtCursor = Cursor.getPredefinedCursor(cursorType);
            }
            catch (IndexOutOfBoundsException e) {
                if (!VirtualSpaceManager.debugModeON()) break block6;
                System.err.println("Error while creating AWT cursor " + e);
                this.awtCursor = new Cursor(0);
            }
        }
        this.getComponent().setCursor(this.awtCursor);
    }

    public void setDrawCursor(boolean b) {
        this.drawVTMcursor = b;
    }

    protected void setAWTCursor(Cursor c) {
        this.awtCursor = c;
        this.drawVTMcursor = false;
        this.getComponent().setCursor(this.awtCursor);
    }

    public Point2D.Double viewToSpaceCoords(Camera c, int jpx, int jpy) {
        Location camLoc = c.getLocation();
        double focal = c.getFocal();
        double altCoef = (focal + camLoc.alt) / focal;
        Dimension viewSize = this.getComponent().getSize();
        double viewOrigX = camLoc.vx - 0.5 * (double)viewSize.width * altCoef;
        double viewOrigY = camLoc.vy + 0.5 * (double)viewSize.height * altCoef;
        return new Point2D.Double(viewOrigX + altCoef * (double)jpx, viewOrigY - altCoef * (double)jpy);
    }

    public Point spaceToViewCoords(Camera c, double vx, double vy) {
        double coef = c.focal / (c.focal + c.altitude);
        Dimension d = this.getComponent().getSize();
        return new Point((int)Math.round((double)(d.width / 2) + (vx - c.vx) * coef), (int)Math.round((double)(d.height / 2) - (vy - c.vy) * coef));
    }

    public void setDrawDrag(boolean b) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawDrag = b;
        this.parent.repaint();
    }

    public void setDrawSegment(boolean b) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawDrag = b;
        this.parent.repaint();
    }

    public void setDrawRect(boolean b) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawRect = b;
        this.parent.repaint();
    }

    public void setDrawOval(short s) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        if (s == 1) {
            this.drawOval = true;
            this.circleOnly = false;
        } else if (s == 2) {
            this.drawOval = true;
            this.circleOnly = true;
        } else if (s == 0) {
            this.drawOval = false;
        }
        this.parent.repaint();
    }

    public void showFirstOrderPanWidget(int jpx, int jpy) {
        this.fopw_x = jpx - this.FIRST_ORDER_PAN_WIDGET.getWidth(null) / 2;
        this.fopw_y = jpy - this.FIRST_ORDER_PAN_WIDGET.getHeight(null) / 2;
        this.sfopw = true;
        this.parent.repaint();
    }

    public void hideFirstOrderPanWidget() {
        this.sfopw = false;
        this.parent.repaint();
    }

    public void setFirstOrderPanWidget(Image icon) {
        this.FIRST_ORDER_PAN_WIDGET = icon;
    }

    public boolean isShowingFirstOrderPanWidget() {
        return this.sfopw;
    }

    public void mousePressed(MouseEvent e) {
        if (this.evHs[this.activeLayer] == null) {
            return;
        }
        int whichButton = e.getModifiers();
        this.origDragx = e.getX();
        this.origDragy = e.getY();
        if ((whichButton & 0x10) == 16) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].press1(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].press1(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].press1(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].press1(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].press1(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].press1(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].press1(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].press1(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 8) == 8) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].press2(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].press2(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].press2(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].press2(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].press2(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].press2(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].press2(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].press2(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 4) == 4) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].press3(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].press3(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].press3(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].press3(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].press3(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].press3(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].press3(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].press3(this, 0, e.getX(), e.getY(), e);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.evHs[this.activeLayer] == null) {
            return;
        }
        int whichButton = e.getModifiers();
        if ((whichButton & 0x10) == 16) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].click1(this, 3, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].click1(this, 5, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].click1(this, 7, e.getX(), e.getY(), e.getClickCount(), e);
                } else {
                    this.evHs[this.activeLayer].click1(this, 1, e.getX(), e.getY(), e.getClickCount(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].click1(this, 2, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].click1(this, 4, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].click1(this, 6, e.getX(), e.getY(), e.getClickCount(), e);
            } else {
                this.evHs[this.activeLayer].click1(this, 0, e.getX(), e.getY(), e.getClickCount(), e);
            }
        } else if ((whichButton & 8) == 8) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].click2(this, 3, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].click2(this, 5, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].click2(this, 7, e.getX(), e.getY(), e.getClickCount(), e);
                } else {
                    this.evHs[this.activeLayer].click2(this, 1, e.getX(), e.getY(), e.getClickCount(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].click2(this, 2, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].click2(this, 4, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].click2(this, 6, e.getX(), e.getY(), e.getClickCount(), e);
            } else {
                this.evHs[this.activeLayer].click2(this, 0, e.getX(), e.getY(), e.getClickCount(), e);
            }
        } else if ((whichButton & 4) == 4) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].click3(this, 3, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].click3(this, 5, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].click3(this, 7, e.getX(), e.getY(), e.getClickCount(), e);
                } else {
                    this.evHs[this.activeLayer].click3(this, 1, e.getX(), e.getY(), e.getClickCount(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].click3(this, 2, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].click3(this, 4, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].click3(this, 6, e.getX(), e.getY(), e.getClickCount(), e);
            } else {
                this.evHs[this.activeLayer].click3(this, 0, e.getX(), e.getY(), e.getClickCount(), e);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.evHs[this.activeLayer] == null) {
            return;
        }
        int whichButton = e.getModifiers();
        if ((whichButton & 0x10) == 16) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].release1(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].release1(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].release1(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].release1(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].release1(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release1(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].release1(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].release1(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 8) == 8) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].release2(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].release2(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].release2(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].release2(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].release2(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release2(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].release2(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].release2(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 4) == 4) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].release3(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].release3(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].release3(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].release3(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].release3(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release3(this, 4, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release3(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].release3(this, 0, e.getX(), e.getY(), e);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.repaintable = true;
        this.cursor_inside = true;
        VirtualSpaceManager.INSTANCE.setActiveView(this.parent);
        if (this.autoRequestFocusOnMouseEnter) {
            this.getComponent().requestFocus();
        }
        if (this.parent.mouse.sync) {
            this.parent.mouse.setJPanelCoordinates(e.getX(), e.getY());
            this.updateCursorOnly = true;
            this.parent.mouse.propagateMove();
            this.updateCursorInsidePortals(e.getX(), e.getY());
            if (this.evHs[this.activeLayer] != null && this.parent.notifyCursorMoved) {
                this.evHs[this.activeLayer].mouseMoved(this, e.getX(), e.getY(), e);
            }
        }
        this.repaintASAP = true;
    }

    public void mouseExited(MouseEvent e) {
        this.cursor_inside = false;
        this.eraseCursor();
    }

    void eraseCursor() {
    }

    public void setAutoRequestFocusOnMouseEnter(boolean b) {
        this.autoRequestFocusOnMouseEnter = b;
    }

    public boolean getAutoRequestFocusOnMouseEnter() {
        return this.autoRequestFocusOnMouseEnter;
    }

    public void setNoEventCoordinates(int x, int y) {
        this.ix = x;
        this.iy = y;
    }

    public Point getNoEventCoordinates() {
        return this.ix != -1 && this.iy != -1 ? new Point(this.ix, this.iy) : null;
    }

    public void mouseMoved(MouseEvent e) {
        block6: {
            try {
                if (this.parent.mouse.sync && (e.getX() != this.ix || e.getY() != this.iy)) {
                    this.parent.mouse.setJPanelCoordinates(e.getX(), e.getY());
                    this.updateCursorOnly = true;
                    this.parent.mouse.propagateMove();
                    this.updateCursorInsidePortals(e.getX(), e.getY());
                    if (this.evHs[this.activeLayer] != null) {
                        if (this.parent.notifyCursorMoved) {
                            this.evHs[this.activeLayer].mouseMoved(this, e.getX(), e.getY(), e);
                        }
                        if (this.parent.mouse.isSensitive() && this.parent.mouse.getPicker().computePickedGlyphList(this.evHs[this.activeLayer], this.cams[this.activeLayer], this)) {
                            this.parent.repaint();
                        }
                    }
                }
            }
            catch (NullPointerException ex) {
                if (!VirtualSpaceManager.debugModeON()) break block6;
                System.err.println("viewpanel.mousemoved " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        block24: {
            try {
                if (this.parent.mouse.sync && (e.getX() != this.ix || e.getY() != this.iy)) {
                    int whichButton = e.getModifiers();
                    int buttonNumber = 0;
                    this.parent.mouse.setJPanelCoordinates(e.getX(), e.getY());
                    this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                    this.parent.mouse.propagateMove();
                    this.updateCursorInsidePortals(e.getX(), e.getY());
                    if (this.evHs[this.activeLayer] != null) {
                        if ((whichButton & 0x10) == 16) {
                            buttonNumber = 1;
                        } else if ((whichButton & 8) == 8) {
                            buttonNumber = 2;
                        } else if ((whichButton & 4) == 4) {
                            buttonNumber = 3;
                        }
                        if (e.isShiftDown()) {
                            if (e.isControlDown()) {
                                this.evHs[this.activeLayer].mouseDragged(this, 3, buttonNumber, e.getX(), e.getY(), e);
                            } else if (e.isMetaDown()) {
                                this.evHs[this.activeLayer].mouseDragged(this, 5, buttonNumber, e.getX(), e.getY(), e);
                            } else if (e.isAltDown()) {
                                this.evHs[this.activeLayer].mouseDragged(this, 7, buttonNumber, e.getX(), e.getY(), e);
                            } else {
                                this.evHs[this.activeLayer].mouseDragged(this, 1, buttonNumber, e.getX(), e.getY(), e);
                            }
                        } else if (e.isControlDown()) {
                            this.evHs[this.activeLayer].mouseDragged(this, 2, buttonNumber, e.getX(), e.getY(), e);
                        } else if (e.isMetaDown()) {
                            this.evHs[this.activeLayer].mouseDragged(this, 4, buttonNumber, e.getX(), e.getY(), e);
                        } else if (e.isAltDown()) {
                            this.evHs[this.activeLayer].mouseDragged(this, 6, buttonNumber, e.getX(), e.getY(), e);
                        } else {
                            this.evHs[this.activeLayer].mouseDragged(this, 0, buttonNumber, e.getX(), e.getY(), e);
                        }
                    }
                    this.curDragx = e.getX();
                    this.curDragy = e.getY();
                    this.parent.repaint();
                    if (this.parent.mouse.isSensitive()) {
                        this.parent.mouse.getPicker().computePickedGlyphList(this.evHs[this.activeLayer], this.cams[this.activeLayer], this);
                    }
                }
            }
            catch (NullPointerException ex) {
                if (!VirtualSpaceManager.INSTANCE.debugModeON()) break block24;
                System.err.println("viewpanel.mousedragged " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        block3: {
            if (this.evHs[this.activeLayer] != null) {
                try {
                    this.evHs[this.activeLayer].mouseWheelMoved(this, e.getWheelRotation() < 0 ? (short)0 : 1, e.getX(), e.getY(), e);
                }
                catch (NullPointerException ex) {
                    if (!VirtualSpaceManager.INSTANCE.debugModeON()) break block3;
                    System.err.println("viewpanel.mousewheelmoved " + ex);
                }
            }
        }
    }

    public VCursor getVCursor() {
        return this.parent.getCursor();
    }

    public Glyph lastGlyphEntered() {
        return this.parent.mouse.getPicker().lastGlyphEntered();
    }

    public Glyph[] getGlyphsUnderCursorList() {
        return this.parent.mouse.getPicker().getPickedGlyphList();
    }

    public abstract BufferedImage getImage();

    public abstract void setRefreshRate(int var1);

    public abstract int getRefreshRate();

    public long getDelay() {
        return this.delay;
    }

    protected Lens setLens(Lens l) {
        if (l != null) {
            this.lens = l;
            this.lens.setLensBuffer(this);
            this.parent.repaint();
            return this.lens;
        }
        if (this.lens != null) {
            this.lens = null;
            this.parent.repaint();
        }
        return null;
    }

    protected Lens getLens() {
        return this.lens;
    }

    protected void setVisibilityPadding(int[] wnesPadding, int layer) {
        if (layer < this.visibilityPadding.length) {
            this.visibilityPadding[layer] = wnesPadding;
        }
    }

    protected int[] getVisibilityPadding(int layer) {
        if (layer < this.visibilityPadding.length) {
            return this.visibilityPadding[layer];
        }
        return null;
    }

    public void componentResized(ComponentEvent e) {
        ResizeTask task = new ResizeTask(++this.currentTaskID);
        this.timer.schedule((TimerTask)task, this.resizeDelay);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    protected final void drawPortals() {
        for (int i = 0; i < this.parent.portals.length; ++i) {
            this.parent.portals[i].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
        }
    }

    protected final void portalsHook() {
        if (this.parent.painters[3] != null) {
            this.parent.painters[3].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
        }
    }

    protected final void backgroundHook() {
        if (this.parent.painters[0] != null) {
            this.parent.painters[0].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
        }
    }

    protected final void foregroundHook() {
        if (this.parent.painters[1] != null) {
            this.parent.painters[1].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
        }
    }

    protected final void afterLensHook() {
        if (this.parent.painters[2] != null) {
            this.parent.painters[2].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
        }
    }

    private class ResizeTask
    extends TimerTask {
        private int id;

        public ResizeTask(int id) {
            this.id = id;
        }

        public void run() {
            if (this.id == ViewPanel.this.currentTaskID) {
                ViewPanel.this.parent.repaint();
                ViewPanel.this.currentTaskID = 0;
            }
        }
    }
}

