/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer.dot;

import java.awt.Color;
import net.claribole.zgrviewer.dot.Cluster;
import net.claribole.zgrviewer.dot.DotUtils;
import net.claribole.zgrviewer.dot.Edge;
import net.claribole.zgrviewer.dot.Graph;
import net.claribole.zgrviewer.dot.Style;
import net.claribole.zgrviewer.dot.SubGraph;
import net.claribole.zgrviewer.dot.SubRecord;

public abstract class Node {
    private Edge[] in;
    private Edge[] out;
    String id;
    Object root;
    String label;
    String URL;
    String target;
    String fontname = "Times-Roman";
    Color fontcolor = Color.black;
    Color color;
    Color fillcolor;
    double fontsize = 14.0;
    int peripheries = 1;
    boolean nojustify = false;
    protected Style style = new Style();

    public Node(Object root, String id) throws Exception {
        if (id.equals("") && !(this instanceof SubRecord)) {
            throw new Exception("No ID");
        }
        this.id = id;
        this.root = root;
    }

    protected Node(Object root) throws Exception {
        this.root = root;
    }

    public Edge[] getIn() {
        return this.in;
    }

    public Edge[] getOut() {
        return this.out;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    protected void addInEdge(Edge edge) {
        if (this.in == null) {
            this.in = new Edge[1];
            this.in[0] = edge;
        } else {
            Edge[] tmp = new Edge[this.in.length + 1];
            System.arraycopy(this.in, 0, tmp, 0, this.in.length);
            tmp[tmp.length - 1] = edge;
            this.in = tmp;
        }
    }

    protected void addOutEdge(Edge edge) {
        if (this.out == null) {
            this.out = new Edge[1];
            this.out[0] = edge;
        } else {
            Edge[] tmp = new Edge[this.out.length + 1];
            System.arraycopy(this.out, 0, tmp, 0, this.out.length);
            tmp[tmp.length - 1] = edge;
            this.out = tmp;
        }
    }

    protected void removeInEdge(Edge edge) {
        if (this.in != null) {
            for (int i = 0; i < this.in.length; ++i) {
                if (this.in[i] != edge) continue;
                Edge[] tmp = new Edge[this.in.length - 1];
                System.arraycopy(this.in, 0, tmp, 0, i);
                System.arraycopy(this.in, i + 1, tmp, i, this.in.length - i - 1);
                this.in = tmp;
                break;
            }
            if (this.in.length == 0) {
                this.in = null;
            }
        }
    }

    protected void removeOutEdge(Edge edge) {
        if (this.out != null) {
            for (int i = 0; i < this.out.length; ++i) {
                if (this.out[i] != edge) continue;
                Edge[] tmp = new Edge[this.out.length - 1];
                System.arraycopy(this.out, 0, tmp, 0, i);
                System.arraycopy(this.out, i + 1, tmp, i, this.out.length - i - 1);
                this.out = tmp;
                break;
            }
            if (this.out.length == 0) {
                this.out = null;
            }
        }
    }

    protected void changeOption(String name, String value) throws Exception {
        String v = value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value;
        v = v.replaceAll("\\\\\\n", "");
        if (name.equals("color")) {
            this.color = DotUtils.readColor(v);
        } else if (name.equals("fillcolor")) {
            this.fillcolor = DotUtils.readColor(v);
        } else if (name.equals("fontcolor")) {
            this.fontcolor = DotUtils.readColor(v);
        } else if (name.equals("fontname")) {
            this.fontname = v;
        } else if (name.equals("fontsize")) {
            this.fontsize = DotUtils.readDouble(v);
        } else if (name.equals("label")) {
            this.label = v.equals("\\N") ? this.id : v;
        } else if (name.equals("nojustify")) {
            this.nojustify = DotUtils.readBoolean(v);
        } else if (name.equals("peripheries")) {
            this.peripheries = DotUtils.readInteger(v);
        } else if (name.equals("style")) {
            DotUtils.readStyle(this.style, v);
        } else if (name.equals("target")) {
            this.target = v;
        } else if (name.equals("URL") || name.equals("href")) {
            this.URL = v;
        } else {
            throw new Exception("Node attribute \"" + name + "\" does not exist");
        }
    }

    public String toString() {
        String o = this.nodeOptions();
        String i = (this instanceof Cluster ? "cluster" : "") + this.id;
        if (!o.equals(" ")) {
            i = i + " [" + o + "]";
        }
        return i + ";\n";
    }

    protected String nodeOptions() {
        String o = " ";
        if (this.label != null && !this.label.equals("") && !this.label.equals(this.id)) {
            o = o + this.printOption("label", this.label);
        }
        if (this.URL != null) {
            o = o + this.printOption("URL", this.URL);
        }
        if (this.target != null) {
            o = o + this.printOption("target", this.target);
        }
        if (!this.fontname.equals("Times-Roman")) {
            o = o + this.printOption("fontname", this.fontname);
        }
        if (!this.fontcolor.equals(Color.black)) {
            o = o + this.printOption("fontcolor", this.fontcolor);
        }
        if (this.color != null) {
            o = o + this.printOption("color", this.color);
        }
        if (this.fontsize != 14.0) {
            o = o + this.printOption("fontsize", this.fontsize);
        }
        if (this.peripheries != 1) {
            o = o + this.printOption("peripheries", this.peripheries);
        }
        if (this.nojustify) {
            o = o + this.printOption("nojustify", this.nojustify);
        }
        if (this.style != null) {
            o = o + this.printOption("style", this.style);
        }
        return o;
    }

    private String printOption(String attribute, Style value) {
        String o = value.toString();
        if (o.equals("")) {
            return "";
        }
        return attribute + "=" + value + " ";
    }

    protected String printOption(String attribute, boolean value) {
        return attribute + "=\"" + value + "\" ";
    }

    protected String printOption(String attribute, Color value) {
        if (value != null) {
            String r = Integer.toHexString(value.getRed());
            String g = Integer.toHexString(value.getGreen());
            String b = Integer.toHexString(value.getBlue());
            String a = Integer.toHexString(value.getAlpha());
            if (r.length() == 1) {
                r = "0" + r;
            }
            if (g.length() == 1) {
                g = "0" + g;
            }
            if (b.length() == 1) {
                b = "0" + b;
            }
            if (a.length() == 1) {
                a = "0" + a;
            }
            return attribute + "=\"#" + r + g + b + a + "\" ";
        }
        return "";
    }

    protected String printOption(String attribute, double value) {
        return attribute + "=" + value + " ";
    }

    protected String printOption(String attribute, int value) {
        return attribute + "=" + value + " ";
    }

    protected String printOption(String attribute, String value) {
        return attribute + "=\"" + value + "\" ";
    }

    public Graph getRootGraph() {
        if (this.root instanceof Graph) {
            return (Graph)this.root;
        }
        return ((SubGraph)this.root).getRootGraph();
    }
}

