/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Utils {
    static final String SVG_OUTPUT_ENCODING = "UTF-8";
    static Font smallFont = new Font("Dialog", 0, 10);
    static Color pastelBlue = new Color(156, 154, 206);
    static Color darkerPastelBlue = new Color(125, 123, 165);

    public static void initLookAndFeel() {
        Enumeration e = UIManager.getLookAndFeelDefaults().keys();
        while (e.hasMoreElements()) {
            Object okey = e.nextElement();
            String key = okey.toString();
            if (!key.endsWith(".font") && !key.endsWith("Font")) continue;
            UIManager.put(okey, smallFont);
        }
        UIManager.put("ProgressBar.foreground", pastelBlue);
        UIManager.put("ProgressBar.background", Color.lightGray);
        UIManager.put("Label.foreground", Color.black);
    }

    public static boolean osIsWindows() {
        return fr.inria.zvtm.engine.Utils.osIsWindows();
    }

    public static boolean osIsMacOS() {
        return fr.inria.zvtm.engine.Utils.osIsMacOS();
    }

    public static boolean javaVersionIs140OrLater() {
        String version = System.getProperty("java.vm.version");
        float numVer = new Float(version.substring(0, 3)).floatValue();
        return numVer >= 1.4f;
    }

    public static File createTempFile(String directory, String prefix, String suffix) {
        File f;
        try {
            File d = new File(directory);
            f = File.createTempFile(prefix, suffix, d);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return f;
    }

    public static Document parse(File f, boolean validation) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validation);
            if (!validation) {
                factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
            }
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document res = builder.parse(f);
            return res;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parse(InputStream is, boolean validation) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validation);
            if (!validation) {
                factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
            }
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document res = builder.parse(is);
            return res;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parse(String uri, boolean validation) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validation);
            if (!validation) {
                factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
            }
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document res = builder.parse(uri);
            return res;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void serialize(Document d, File f) {
        OutputFormat format = new OutputFormat(d, SVG_OUTPUT_ENCODING, true);
        format.setLineSeparator("\n");
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), SVG_OUTPUT_ENCODING);
            DOMSerializer serializer = new XMLSerializer((Writer)osw, format).asDOMSerializer();
            serializer.serialize(d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte incByte(byte b) {
        int res;
        if (b < 122) {
            if (b == 57) {
                res = 65;
            } else if (b == 90) {
                res = 97;
            } else {
                b = (byte)(b + 1);
                res = b;
            }
        } else {
            res = 48;
        }
        return (byte)res;
    }

    public static String replaceString(String input, String key, String replacement) {
        String res = "";
        int keyLength = key.length();
        int index = input.indexOf(key);
        int lastIndex = 0;
        while (index >= 0) {
            res = res + input.substring(lastIndex, index) + replacement;
            lastIndex = index + keyLength;
            index = input.indexOf(key, lastIndex);
        }
        res = res + input.substring(lastIndex, input.length());
        return res;
    }

    public static String rankString(int number) {
        String res = Integer.toString(number);
        if (res.endsWith("1")) {
            return res.endsWith("11") ? res + "th" : res + "st";
        }
        if (res.endsWith("2")) {
            return res.endsWith("12") ? res + "th" : res + "nd";
        }
        if (res.endsWith("3")) {
            return res.endsWith("13") ? res + "th" : res + "rd";
        }
        return res + "th";
    }

    public static String join(String[] strings, String sep) {
        if (strings.length > 0) {
            String res = strings[0];
            for (int i = 1; i < strings.length; ++i) {
                res = res + sep + strings[i];
            }
            return res;
        }
        return "";
    }

    public static String getTextContent(URL url, int maxBufferSize) throws IOException {
        Object content = url.getContent();
        String text = null;
        if (content instanceof String) {
            text = (String)content;
        } else if (content instanceof InputStream || content instanceof Reader) {
            int ch;
            int index;
            BufferedReader in = content instanceof InputStream ? new BufferedReader(new InputStreamReader((InputStream)content)) : (content instanceof BufferedReader ? (BufferedReader)content : new BufferedReader((Reader)content));
            char[] data = new char[maxBufferSize];
            for (index = 0; index != maxBufferSize && (ch = in.read()) != -1; ++index) {
                data[index] = (char)ch;
            }
            text = index == 0 ? null : new String(data, 0, index);
            in.close();
        }
        return text;
    }

    static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

