/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.EndAction;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Utils;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VText;
import java.awt.geom.Point2D;
import net.claribole.zgrviewer.BroughtElement;
import net.claribole.zgrviewer.LNode;

class BroughtNode
extends BroughtElement {
    double[] previousSize;

    BroughtNode(LNode n) {
        this.glyphs = n.getGlyphs();
        this.previousLocations = new Point2D.Double[this.glyphs.length];
        this.previousSize = new double[this.glyphs.length];
        for (int i = 0; i < this.glyphs.length; ++i) {
            this.previousLocations[i] = this.glyphs[i].getLocation();
            this.previousSize[i] = this.glyphs[i] instanceof VText ? (double)((VText)this.glyphs[i]).getScale() : this.glyphs[i].getSize();
        }
    }

    @Override
    Point2D.Double restorePreviousState(int duration, Glyph g) {
        int i;
        for (i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphs[i] instanceof VText) {
                final VText t = (VText)this.glyphs[i];
                final double sz = this.previousSize[i];
                Animation a = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createGlyphTranslation(duration, this.glyphs[i], this.previousLocations[i], false, SlowInSlowOutInterpolator.getInstance(), new EndAction(){

                    public void execute(Object subject, Animation.Dimension dimension) {
                        t.setScale((float)sz);
                    }
                });
                VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(a, true);
                continue;
            }
            Animation a = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createGlyphTranslation(duration, this.glyphs[i], this.previousLocations[i], false, SlowInSlowOutInterpolator.getInstance(), null);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(a, true);
            if (this.previousSize[i] == this.glyphs[i].getSize()) continue;
            a = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createGlyphSizeAnim(duration, this.glyphs[i], this.previousSize[i], false, SlowInSlowOutInterpolator.getInstance(), null);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(a, true);
        }
        i = Utils.indexOfGlyph((Glyph[])this.glyphs, (Glyph)g);
        return i != -1 ? this.previousLocations[i] : null;
    }
}

