/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.editors.table;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.table.TraceElementTableConfigProvider;
import org.eclipse.efm.execution.core.workflow.common.TraceElement;
import org.eclipse.efm.execution.core.workflow.common.TraceElementCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.ui.utils.ImageResources;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;

public class TraceElementTableViewer2 {
    private final Image IMG_CHECKED = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/checked.gif");
    private final Image IMG_UNCHECKED = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/unchecked.gif");
    private final Image IMG_ADD = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/add.gif");
    private final Image IMG_LIST_ADD = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-add.gif");
    private final Image IMG_COPY = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/duplicate.png");
    private final Image IMG_LIST_EDIT = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-edit.gif");
    private final Image IMG_LIST_DELETE = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-delete.gif");
    private final Image IMG_LIST_MOVE_UP = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-moveup.gif");
    private final Image IMG_LIST_MOVE_DOWN = ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-movedown.gif");
    private TableViewer fTableViewer;
    private final TraceElementTableConfigProvider fTableConfig;
    protected Button fAddButton;
    protected Button fCopyButton;
    protected Button fEditButton;
    protected Button fRemoveButton;
    protected Button fMovedDownButton;
    protected Button fMovedUpButton;
    protected Action fAddAction;
    protected Action fCopyAction;
    protected Action fEditAction;
    protected Action fRemoveAction;
    protected Action fMovedDownAction;
    protected Action fMovedUpAction;
    protected final AbstractConfigurationProfile fConfigurationProfile;

    public TraceElementTableViewer2(AbstractConfigurationProfile configurationProfile, Composite parent, IWidgetToolkit widgetToolkit, TraceElementTableConfigProvider tableConfig) {
        this.fConfigurationProfile = configurationProfile;
        this.fTableConfig = tableConfig;
        this.createControl(parent, widgetToolkit);
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public TraceElementTableConfigProvider getTableConfig() {
        return this.fTableConfig;
    }

    public void setInput(TraceElement[] traceElements) {
        this.fTableViewer.setInput((Object)traceElements);
        this.addNewElementItemForDoubleClick();
    }

    public void setFocus() {
        this.fTableViewer.getControl().setFocus();
    }

    public TraceElement[] getTraceElements() {
        ArrayList<TraceElement> traceElements = new ArrayList<TraceElement>();
        TableItem[] tableItemArray = this.fTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceElement traceElement;
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getData() instanceof TraceElement && (traceElement = (TraceElement)tableItem.getData()).getNature() != TraceElementKind.UNDEFINED) {
                traceElements.add(traceElement);
            }
            ++n2;
        }
        return traceElements.toArray(new TraceElement[traceElements.size()]);
    }

    protected void createControl(Composite parent, IWidgetToolkit widgetToolkit) {
        Font font = parent.getFont();
        Composite tableComposite = widgetToolkit.createComposite(parent, font, 1, 1, 1808, 0, 0);
        ViewForm viewForm = widgetToolkit.createViewForm(tableComposite, 0x800800);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)viewForm);
        toolBar.setBackground(parent.getBackground());
        viewForm.setTopRight((Control)toolBar);
        this.createToolbarActions(toolBarManager);
        Composite viewFormContents = widgetToolkit.createComposite((Composite)viewForm, font, 1, 1, 1808, 5, 5);
        this.createTableViewer(viewFormContents, widgetToolkit);
        viewForm.setContent((Control)viewFormContents);
    }

    protected void createToolbarActions(ToolBarManager tmanager) {
        tmanager.add((IAction)this.getAddAction());
        tmanager.add((IAction)this.getCopyAction());
        tmanager.add((IAction)this.getEditAction());
        tmanager.add((IAction)this.getRemoveAction());
        tmanager.add((IContributionItem)new Separator());
        tmanager.add((IAction)this.getMovedUpAction());
        tmanager.add((IAction)this.getMovedDownAction());
        tmanager.update(true);
    }

    protected void createTableButtons(Composite parent, IWidgetToolkit widgetToolkit) {
        Composite buttonComposite = widgetToolkit.createComposite(parent, parent.getFont(), 1, 1, 130, 0, 0);
        this.fAddButton = widgetToolkit.createPushButton(buttonComposite, null, this.IMG_LIST_ADD);
        this.fAddButton.setToolTipText("Add new element");
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceElementTableViewer2.this.handleAddButtonSelected();
            }
        });
        this.fCopyButton = widgetToolkit.createPushButton(buttonComposite, null, this.IMG_COPY);
        this.fCopyButton.setToolTipText("Copy selected elements");
        this.fCopyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceElementTableViewer2.this.handleCopyButtonSelected();
            }
        });
        this.fEditButton = widgetToolkit.createPushButton(buttonComposite, null, this.IMG_LIST_EDIT);
        this.fEditButton.setToolTipText("Edit selected element");
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceElementTableViewer2.this.handleEditButtonSelected();
            }
        });
        this.fEditButton.setEnabled(false);
        this.fRemoveButton = widgetToolkit.createPushButton(buttonComposite, null, this.IMG_LIST_DELETE);
        this.fRemoveButton.setToolTipText("Remove selected elements");
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceElementTableViewer2.this.handleRemoveButtonSelected();
            }
        });
        this.fMovedDownButton = widgetToolkit.createPushButton(buttonComposite, null, this.IMG_LIST_MOVE_UP);
        this.fMovedDownButton.setToolTipText("Moved Down selected element");
        this.fMovedDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceElementTableViewer2.this.handleMovedUpButtonSelected();
            }
        });
        this.fMovedUpButton = widgetToolkit.createPushButton(buttonComposite, null, this.IMG_LIST_MOVE_DOWN);
        this.fMovedUpButton.setToolTipText("Moved Up selected element");
        this.fMovedUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceElementTableViewer2.this.handleMovedDownButtonSelected();
            }
        });
    }

    protected void createTableViewer(Composite tableContainer, IWidgetToolkit widgetToolkit) {
        this.fTableViewer = new TableViewer(tableContainer, 68354);
        this.addMoveableRowSupport();
        this.createColumns(tableContainer, tableContainer.getFont());
        Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.fTableViewer.getControl().setLayoutData((Object)gridData);
        this.fTableViewer.getControl().setToolTipText(this.fTableConfig.TOOLTIP_TEXT);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TraceElementTableViewer2.this.handleDoubleClickEvent(event);
            }
        });
    }

    private void createColumns(Composite composite, Font font) {
        throw new Error("Unresolved compilation problems: \n\tSEL_TITLES cannot be resolved or is not a field\n\tSEL_WIDTH cannot be resolved or is not a field\n\tThe constructor TraceElementSelectionEditingSupport(TraceElementTableViewer2) is undefined\n\tCOLUMN_TITLES cannot be resolved or is not a field\n\tCOLUMN_WIDTHS cannot be resolved or is not a field\n\tThe constructor TraceElementNatureEditingSupport(TraceElementTableViewer2) is undefined\n\tCOLUMN_TITLES cannot be resolved or is not a field\n\tCOLUMN_WIDTHS cannot be resolved or is not a field\n\tThe constructor TraceElementValueEditingSupport(TraceElementTableViewer2) is undefined\n");
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, boolean resizable, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setWidth(bound);
        column.setResizable(resizable);
        column.setMoveable(false);
        return viewerColumn;
    }

    public void addNewElementItemForDoubleClick() {
        this.fTableViewer.add((Object)new TraceElementCustomImpl(TraceElementKind.UNDEFINED, (Object)"Add new element"));
    }

    private void addNewfreshElementItem(TraceElement newTraceElement) {
        TraceElementKind nature = this.fTableConfig.DEFAULT_TRACE;
        TableItem[] tableItems = this.fTableViewer.getTable().getItems();
        int index = tableItems.length - 1;
        while (index >= 0) {
            TraceElement traceElement = (TraceElement)tableItems[index].getData();
            switch (traceElement.getNature()) {
                case UNDEFINED: 
                case COMMENT: {
                    break;
                }
                default: {
                    nature = traceElement.getNature();
                    index = -1;
                }
            }
            --index;
        }
        newTraceElement.setNature(nature);
        newTraceElement.setValue((Object)("new " + nature.getLiteral()));
        this.addNewElementItemForDoubleClick();
        this.fTableViewer.update((Object)newTraceElement, null);
    }

    private void handleDoubleClickEvent(DoubleClickEvent event) {
        TraceElement selTraceElement;
        Object selection;
        if (event.getSelection().isEmpty()) {
            this.fTableViewer.add((Object)new TraceElementCustomImpl(TraceElementKind.VARIABLE, (Object)"new variable element"));
        } else if (event.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof TraceElement && (selTraceElement = (TraceElement)selection).getNature() == TraceElementKind.UNDEFINED) {
            this.addNewfreshElementItem(selTraceElement);
        }
    }

    private void addMoveableRowSupport() {
        final Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.fTableViewer.addDragSupport(3, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                if (transferTypes[0].isSupportedType(event.dataType)) {
                    TableItem[] selection;
                    TableItem[] tableItemArray = selection = TraceElementTableViewer2.this.fTableViewer.getTable().getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        System.out.println("drag: " + item.getData());
                        event.data = item.getData();
                        ++n2;
                    }
                }
            }
        });
        this.fTableViewer.addDropSupport(3, transferTypes, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fTableViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return target instanceof TraceElement;
            }

            public void drop(DropTargetEvent event) {
                int location = this.determineLocation(event);
                TraceElement target = (TraceElement)this.determineTarget(event);
                String translatedLocation = "";
                switch (location) {
                    case 1: {
                        translatedLocation = "Dropped before the target: ";
                        break;
                    }
                    case 2: {
                        translatedLocation = "Dropped after the target: ";
                        break;
                    }
                    case 3: {
                        translatedLocation = "Dropped on the target: ";
                        break;
                    }
                    case 4: {
                        translatedLocation = "Dropped into nothing: ";
                    }
                }
                System.out.print(translatedLocation);
                System.out.println("the drop was done on the element: " + target);
                super.drop(event);
            }

            public boolean performDrop(Object data) {
                TableItem[] selection;
                TableItem[] tableItemArray = selection = TraceElementTableViewer2.this.fTableViewer.getTable().getSelection();
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    TraceElementTableViewer2.this.fTableViewer.add(item.getData());
                    System.out.println("drop: " + item.getData());
                    ++n2;
                }
                return false;
            }
        });
    }

    protected Action getAddAction() {
        if (this.fAddAction == null) {
            this.fAddAction = new Action(){

                public void run() {
                    int selectionIndex = TraceElementTableViewer2.this.fTableViewer.getTable().getSelectionIndex();
                    System.out.println("Add:>selectionIndex: " + selectionIndex);
                    if (selectionIndex >= 0) {
                        TraceElement selTraceElement = (TraceElement)TraceElementTableViewer2.this.fTableViewer.getTable().getItem(selectionIndex).getData();
                        if (selTraceElement.getNature() != TraceElementKind.UNDEFINED) {
                            selTraceElement = null;
                            TableItem[] tableItemArray = TraceElementTableViewer2.this.fTableViewer.getTable().getItems();
                            int n = tableItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableItem item = tableItemArray[n2];
                                if (((TraceElement)item.getData()).getNature() == TraceElementKind.UNDEFINED) {
                                    selTraceElement = (TraceElement)item.getData();
                                }
                                ++n2;
                            }
                        }
                        if (selTraceElement != null) {
                            TraceElementTableViewer2.this.addNewfreshElementItem(selTraceElement);
                        } else {
                            TraceElementTableViewer2.this.fTableViewer.add((Object)new TraceElementCustomImpl(TraceElementKind.UNDEFINED, (Object)"Add new element"));
                        }
                    }
                }
            };
            this.fAddAction.setText("Add");
            this.fAddAction.setToolTipText("Add new element");
            this.fAddAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-add.gif"));
            this.fAddAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-add.gif"));
        }
        return this.fAddAction;
    }

    protected void handleAddButtonSelected() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        System.out.println("Add:>selectionIndex: " + selectionIndex);
        if (selectionIndex >= 0) {
            TraceElement selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData();
            if (selTraceElement.getNature() != TraceElementKind.UNDEFINED) {
                selTraceElement = null;
                TableItem[] tableItemArray = this.fTableViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (((TraceElement)item.getData()).getNature() == TraceElementKind.UNDEFINED) {
                        selTraceElement = (TraceElement)item.getData();
                    }
                    ++n2;
                }
            }
            if (selTraceElement != null) {
                this.addNewfreshElementItem(selTraceElement);
            } else {
                this.fTableViewer.add((Object)new TraceElementCustomImpl(TraceElementKind.UNDEFINED, (Object)"Add new element"));
            }
        }
    }

    protected Action getCopyAction() {
        if (this.fCopyAction == null) {
            this.fCopyAction = new Action(){

                public void run() {
                    int selectionIndex = TraceElementTableViewer2.this.fTableViewer.getTable().getSelectionIndex();
                    System.out.println("Add:>selectionIndex: " + selectionIndex);
                    if (selectionIndex >= 0) {
                        TraceElement selTraceElement = (TraceElement)TraceElementTableViewer2.this.fTableViewer.getTable().getItem(selectionIndex).getData();
                        if (selTraceElement.getNature() == TraceElementKind.UNDEFINED) {
                            TraceElementTableViewer2.this.addNewfreshElementItem(selTraceElement);
                        } else {
                            TableItem[] tableItemArray = TraceElementTableViewer2.this.fTableViewer.getTable().getSelection();
                            int n = tableItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableItem selection = tableItemArray[n2];
                                selTraceElement = (TraceElement)selection.getData();
                                TraceElementTableViewer2.this.fTableViewer.insert((Object)new TraceElementCustomImpl(selTraceElement.getNature(), (Object)(String.valueOf(selTraceElement.getValue().toString()) + "_copy")), selectionIndex + 1);
                                ++n2;
                            }
                        }
                    }
                }
            };
            this.fCopyAction.setText("Copy");
            this.fCopyAction.setToolTipText("Copy selected elements");
            this.fCopyAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/duplicate.png"));
            this.fCopyAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/duplicate.png"));
        }
        return this.fCopyAction;
    }

    protected void handleCopyButtonSelected() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        System.out.println("Add:>selectionIndex: " + selectionIndex);
        if (selectionIndex >= 0) {
            TraceElement selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData();
            if (selTraceElement.getNature() == TraceElementKind.UNDEFINED) {
                this.addNewfreshElementItem(selTraceElement);
            } else {
                TableItem[] tableItemArray = this.fTableViewer.getTable().getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selection = tableItemArray[n2];
                    selTraceElement = (TraceElement)selection.getData();
                    this.fTableViewer.insert((Object)new TraceElementCustomImpl(selTraceElement.getNature(), (Object)(String.valueOf(selTraceElement.getValue().toString()) + "_copy")), selectionIndex + 1);
                    ++n2;
                }
            }
        }
    }

    protected Action getEditAction() {
        if (this.fEditAction == null) {
            this.fEditAction = new Action(){

                public void run() {
                    int selectionIndex = TraceElementTableViewer2.this.fTableViewer.getTable().getSelectionIndex();
                    System.out.println("Edit:>selectionIndex: " + selectionIndex);
                }
            };
            this.fEditAction.setText("Edit");
            this.fEditAction.setToolTipText("Edit new element");
            this.fEditAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-edit.gif"));
            this.fEditAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-edit.gif"));
            this.fEditAction.setEnabled(false);
        }
        return this.fEditAction;
    }

    protected void handleEditButtonSelected() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        System.out.println("Edit:>selectionIndex: " + selectionIndex);
    }

    protected Action getRemoveAction() {
        if (this.fRemoveAction == null) {
            this.fRemoveAction = new Action(){

                public void run() {
                    int selectionIndex = TraceElementTableViewer2.this.fTableViewer.getTable().getSelectionIndex();
                    System.out.println("Remove:>selectionIndex: " + selectionIndex);
                    if (selectionIndex >= 0) {
                        TableItem[] tableItemArray = TraceElementTableViewer2.this.fTableViewer.getTable().getSelection();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem selection = tableItemArray[n2];
                            TraceElementTableViewer2.this.fTableViewer.remove(selection.getData());
                            ++n2;
                        }
                    }
                }
            };
            this.fRemoveAction.setText("Remove");
            this.fRemoveAction.setToolTipText("Remove selected elements");
            this.fRemoveAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-delete.gif"));
            this.fRemoveAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-delete.gif"));
        }
        return this.fRemoveAction;
    }

    protected void handleRemoveButtonSelected() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        System.out.println("Remove:>selectionIndex: " + selectionIndex);
        if (selectionIndex >= 0) {
            TableItem[] tableItemArray = this.fTableViewer.getTable().getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem selection = tableItemArray[n2];
                this.fTableViewer.remove(selection.getData());
                ++n2;
            }
        }
    }

    protected Action getMovedUpAction() {
        if (this.fMovedUpAction == null) {
            this.fMovedUpAction = new Action(){

                public void run() {
                    int selectionIndex = TraceElementTableViewer2.this.fTableViewer.getTable().getSelectionIndex();
                    System.out.println("MovedUp:>selectionIndex: " + selectionIndex);
                    if (selectionIndex > 0) {
                        TraceElement selTraceElement = (TraceElement)TraceElementTableViewer2.this.fTableViewer.getTable().getItem(selectionIndex).getData();
                        TraceElementTableViewer2.this.fTableViewer.remove((Object)selTraceElement);
                        TraceElementTableViewer2.this.fTableViewer.insert((Object)selTraceElement, selectionIndex - 1);
                    }
                }
            };
            this.fMovedUpAction.setText("MovedUp");
            this.fMovedUpAction.setToolTipText("MovedUp selected element");
            this.fMovedUpAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-moveup.gif"));
            this.fMovedUpAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-moveup.gif"));
        }
        return this.fMovedUpAction;
    }

    protected void handleMovedUpButtonSelected() {
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        System.out.println("MovedUp:>selectionIndex: " + selectionIndex);
        if (selectionIndex > 0) {
            TraceElement selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData();
            this.fTableViewer.remove((Object)selTraceElement);
            this.fTableViewer.insert((Object)selTraceElement, selectionIndex - 1);
        }
    }

    protected Action getMovedDownAction() {
        if (this.fMovedDownAction == null) {
            this.fMovedDownAction = new Action(){

                public void run() {
                    TraceElement selTraceElement;
                    int selectionIndex = TraceElementTableViewer2.this.fTableViewer.getTable().getSelectionIndex();
                    System.out.println("MovedDown:>selectionIndex: " + selectionIndex);
                    if (selectionIndex >= 0 && (selTraceElement = (TraceElement)TraceElementTableViewer2.this.fTableViewer.getTable().getItem(selectionIndex).getData()).getNature() != TraceElementKind.UNDEFINED && selectionIndex < TraceElementTableViewer2.this.fTableViewer.getTable().getItemCount() - 2) {
                        TraceElementTableViewer2.this.fTableViewer.remove((Object)selTraceElement);
                        TraceElementTableViewer2.this.fTableViewer.insert((Object)selTraceElement, selectionIndex + 1);
                    }
                }
            };
            this.fMovedDownAction.setText("MovedDown");
            this.fMovedDownAction.setToolTipText("MovedDown selected element");
            this.fMovedDownAction.setImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/elcl16/list-movedown.gif"));
            this.fMovedDownAction.setDisabledImageDescriptor(ImageResources.getImageDescriptor((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/dlcl16/list-movedown.gif"));
        }
        return this.fMovedDownAction;
    }

    protected void handleMovedDownButtonSelected() {
        TraceElement selTraceElement;
        int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
        System.out.println("MovedDown:>selectionIndex: " + selectionIndex);
        if (selectionIndex >= 0 && (selTraceElement = (TraceElement)this.fTableViewer.getTable().getItem(selectionIndex).getData()).getNature() != TraceElementKind.UNDEFINED && selectionIndex < this.fTableViewer.getTable().getItemCount() - 2) {
            this.fTableViewer.remove((Object)selTraceElement);
            this.fTableViewer.insert((Object)selTraceElement, selectionIndex + 1);
        }
    }

    public void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.fTableConfig.STORE_KEY, this.fTableConfig.DEFAULT_ATTRIBUTE_VALUE);
    }

    public void initializeFromImpl(ILaunchConfiguration configuration) {
        String specification;
        try {
            specification = configuration.getAttribute(this.fTableConfig.STORE_KEY, "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            specification = null;
        }
        if (specification != null && !specification.isEmpty()) {
            TraceSpecificationCustomImpl traceSpecification = TraceSpecificationCustomImpl.create((String)"trace", (String)specification);
            Predicate<TraceElement> tracePredicate = te -> te.getNature() == TraceElementKind.UNDEFINED;
            traceSpecification.getElement().removeIf(tracePredicate);
            TraceElement[] traceElements = new TraceElement[]{};
            traceElements = new TraceElement[traceSpecification.getElement().size()];
            traceSpecification.getElement().toArray(traceElements);
            this.setInput(traceElements);
        }
    }

    public void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        TraceElement[] traceElementArray = this.getTraceElements();
        int n = traceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceElement traceElement = traceElementArray[n2];
            System.out.print(traceElement.isSelected() ? " + " : " - ");
            System.out.print(traceElement.getNature().getLiteral());
            System.out.print(" = ");
            System.out.println(traceElement.getValue());
            ++n2;
        }
    }

    public boolean isValidImpl(ILaunchConfiguration launchConfig) {
        return true;
    }
}

