/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.overview;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.BooleanFieldEditor;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewAnalysisProfileSection;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class OverviewTransitionCoverageConfigurationProfile
extends AbstractConfigurationProfile {
    public BooleanFieldEditor fEnabledDetailedSelectionBooleanField;
    public Composite fCompDetailedSelection;
    private Table fModelTransitionsTable;
    private TableColumn fModelTransitionsTableColumn;
    private Table fSelectedTransitionsTable;
    private TableColumn fSelectedTransitionsTableColumn;
    private List<String> fAllTransitionsList;
    private List<String> fSelectedTransitionsList;
    private String fModelFilePath;
    private OverviewAnalysisProfileSection fOverviewAnalysisProfileSection;

    public OverviewTransitionCoverageConfigurationProfile(AbstractConfigurationPage configurationPage, OverviewAnalysisProfileSection overviewAnalysisProfileSection) {
        super(configurationPage);
        this.fOverviewAnalysisProfileSection = overviewAnalysisProfileSection;
        this.fModelFilePath = null;
    }

    @Override
    public String getSectionTitle() {
        return "Transition Coverage";
    }

    @Override
    public String getSectionDescription() {
        return "Transition Coverage, configuration section";
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        this.fEnabledDetailedSelectionBooleanField = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_ENABLED_TRANSITION_COVERAGE_DETAILS_SELECTION", "&Enable Transitions Selection", parent, false);
        this.addField(this.fEnabledDetailedSelectionBooleanField);
        this.fEnabledDetailedSelectionBooleanField.setPropertyChangeListener(this.fConfigurationPage);
        this.fEnabledDetailedSelectionBooleanField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewTransitionCoverageConfigurationProfile.this.handleEnablingDetailedSelection();
            }
        });
        this.fCompDetailedSelection = widgetToolkit.createComposite(parent, 2, 1, 768);
        this.fModelTransitionsTable = new Table(this.fCompDetailedSelection, 2080);
        this.fModelTransitionsTableColumn = new TableColumn(this.fModelTransitionsTable, 0);
        this.fModelTransitionsTableColumn.setText("Model Transitions");
        this.fModelTransitionsTable.setHeaderVisible(true);
        this.fSelectedTransitionsTable = new Table(this.fCompDetailedSelection, 2048);
        this.fSelectedTransitionsTableColumn = new TableColumn(this.fSelectedTransitionsTable, 0);
        this.fSelectedTransitionsTableColumn.setText("Selected transitions");
        this.fSelectedTransitionsTable.setHeaderVisible(true);
        int listHeight = this.fModelTransitionsTable.getItemHeight() * 10;
        Rectangle trim = this.fModelTransitionsTable.computeTrim(0, 0, 0, listHeight);
        GridData gridDataLeft = new GridData(4, 4, true, true);
        gridDataLeft.heightHint = trim.height;
        gridDataLeft.horizontalIndent = 0;
        gridDataLeft.verticalIndent = 10;
        this.fModelTransitionsTable.setLayoutData((Object)gridDataLeft);
        GridData gridDataRight = new GridData(4, 4, true, true);
        gridDataRight.heightHint = trim.height;
        gridDataRight.horizontalIndent = 0;
        gridDataRight.verticalIndent = 10;
        this.fSelectedTransitionsTable.setLayoutData((Object)gridDataRight);
        this.fModelTransitionsTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean refresh = false;
                if (e.item instanceof TableItem) {
                    TableItem selectedItem = (TableItem)e.item;
                    String strItem = selectedItem.getText();
                    if (selectedItem.getChecked()) {
                        if (!OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.contains(strItem)) {
                            OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.add(strItem);
                            refresh = true;
                        }
                    } else if (OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.contains(strItem)) {
                        OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.remove(strItem);
                        refresh = true;
                    }
                }
                if (refresh) {
                    OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.sort(null);
                    OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsTable.removeAll();
                    int i = 0;
                    while (i < OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.size()) {
                        TableItem item = new TableItem(OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsTable, 0);
                        item.setText((String)OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.get(i));
                        ++i;
                    }
                }
                OverviewTransitionCoverageConfigurationProfile.this.fConfigurationPage.propagateGUIupdate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                OverviewTransitionCoverageConfigurationProfile.this.fConfigurationPage.propagateGUIupdate();
            }
        });
        this.fSelectedTransitionsTable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                int[] nArray = OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsTable.getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    String strItem2 = OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsTable.getItem(index).getText();
                    TableItem[] tableItemArray = OverviewTransitionCoverageConfigurationProfile.this.fModelTransitionsTable.getItems();
                    int n3 = tableItemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TableItem tableItem1 = tableItemArray[n4];
                        if (tableItem1.getText().equals(strItem2)) {
                            OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsList.remove(strItem2);
                            tableItem1.setChecked(false);
                            OverviewTransitionCoverageConfigurationProfile.this.fSelectedTransitionsTable.remove(index);
                            OverviewTransitionCoverageConfigurationProfile.this.fConfigurationPage.propagateGUIupdate();
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    private void handleEnablingDetailedSelection() {
        this.fConfigurationPage.propagateVisibility(this.fCompDetailedSelection, this.fEnabledDetailedSelectionBooleanField.getBooleanValue());
    }

    private void initTransitionTable() {
        this.loadTransitionListToBeSelected();
        this.fModelTransitionsTable.removeAll();
        int i = 0;
        while (i < this.fAllTransitionsList.size()) {
            TableItem item = new TableItem(this.fModelTransitionsTable, 0);
            item.setChecked(false);
            item.setText(this.fAllTransitionsList.get(i));
            ++i;
        }
    }

    public void handleModelFilePathChanged(String modelFilePath) {
        this.fModelFilePath = modelFilePath;
        this.fAllTransitionsList = null;
        this.updateTransitionTables();
    }

    public void updateTransitionTables() {
        this.fSelectedTransitionsTable.removeAll();
        if (this.fAllTransitionsList == null || this.fAllTransitionsList.isEmpty()) {
            this.initTransitionTable();
        }
        if (this.fAllTransitionsList != null && this.fSelectedTransitionsList != null && !this.fAllTransitionsList.isEmpty() && !this.fSelectedTransitionsList.isEmpty()) {
            int i = 0;
            while (i < this.fSelectedTransitionsList.size()) {
                TableItem item = new TableItem(this.fSelectedTransitionsTable, 0);
                item.setText(this.fSelectedTransitionsList.get(i));
                ++i;
            }
            i = 0;
            while (i < this.fAllTransitionsList.size()) {
                if (this.fSelectedTransitionsList.contains(this.fAllTransitionsList.get(i))) {
                    this.fModelTransitionsTable.getItem(i).setChecked(true);
                }
                ++i;
            }
        }
    }

    private void loadTransitionListToBeSelected() {
        if (this.fAllTransitionsList == null) {
            this.fAllTransitionsList = new ArrayList<String>();
        } else {
            this.fAllTransitionsList.clear();
        }
        File modelFile = this.fModelFilePath == null || this.fModelFilePath.isEmpty() ? null : new File(this.fModelFilePath);
        try {
            if (modelFile != null && modelFile.isFile()) {
                String ligne;
                FileInputStream ips = new FileInputStream(modelFile);
                InputStreamReader ipsr = new InputStreamReader(ips);
                BufferedReader br = new BufferedReader(ipsr);
                String transitionName = "";
                int maxSizetransitionName = 0;
                while ((ligne = br.readLine()) != null) {
                    int pos = ligne.indexOf("transition");
                    if (pos >= 0) {
                        transitionName = (ligne = ligne.substring(pos + "transition".length())).replaceAll("\\s*(<[^>]*>\\s*)?([^\\s-{]*).*", "$2");
                        if (transitionName.isEmpty()) continue;
                        this.fAllTransitionsList.add(transitionName);
                        maxSizetransitionName = Math.max(maxSizetransitionName, transitionName.length());
                        continue;
                    }
                    if (!ligne.contains("-->") || ligne.contains("}") || ligne.contains("output ") || ligne.contains("procedure ") || ligne.contains("call ")) continue;
                    ligne = ligne.replaceAll("\t", "");
                    ligne = ligne.substring(0, ligne.indexOf("-->"));
                    transitionName = (ligne = ligne.replaceAll(" ", "")).replaceFirst("@", "");
                    if (transitionName.length() == 0) continue;
                    this.fAllTransitionsList.add(transitionName);
                    maxSizetransitionName = Math.max(maxSizetransitionName, transitionName.length());
                }
                br.close();
                this.fAllTransitionsList.sort(null);
                if (maxSizetransitionName <= 30) {
                    this.fModelTransitionsTableColumn.setWidth(200);
                    this.fSelectedTransitionsTableColumn.setWidth(200);
                } else {
                    this.fModelTransitionsTableColumn.setWidth(maxSizetransitionName * 9 + 30);
                    this.fSelectedTransitionsTableColumn.setWidth(maxSizetransitionName * 9 + 10);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_TRANSITION_COVERAGE_DETAILS_SELECTION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SELECTION", new ArrayList());
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
        try {
            this.fModelFilePath = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "<spec-model-file-location>");
        }
        catch (CoreException e2) {
            this.fModelFilePath = null;
            e2.printStackTrace();
        }
        this.handleEnablingDetailedSelection();
        try {
            this.fSelectedTransitionsList = new ArrayList<String>();
            this.fSelectedTransitionsList.addAll(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SELECTION", new ArrayList()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.fSelectedTransitionsList = new ArrayList<String>();
        }
        this.updateTransitionTables();
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SELECTION", this.fSelectedTransitionsList);
        if (this.fOverviewAnalysisProfileSection.isTransitionCoverage()) {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_ANALYZE_STRATEGY", "WEIGHT_BFS");
        }
    }

    @Override
    protected boolean isValidImpl(ILaunchConfiguration launchConfig) {
        if (this.fEnabledDetailedSelectionBooleanField.getBooleanValue() && this.fSelectedTransitionsList.size() == 0) {
            this.setErrorMessage("You must select at least one transition");
            return false;
        }
        return true;
    }

    @Override
    public void handleConfigurationPropertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION": {
                this.handleModelFilePathChanged(event.getNewValue().toString());
                break;
            }
        }
    }
}

