/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map<ITextEditor, PartListenerGroup> fListenerGroups = new HashMap<ITextEditor, PartListenerGroup>();

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener == null) {
                partListener = new PartListenerGroup(part);
                this.fListenerGroups.put(part, partListener);
            }
            partListener.install(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener != null) {
                partListener.uninstall(listener);
                if (partListener.isEmpty()) {
                    this.fListenerGroups.remove(part);
                }
            }
        }
    }

    private static final class PartListenerGroup {
        private ITextEditor fPart;
        private ISelectionListener fPostSelectionListener;
        private ISelectionChangedListener fSelectionListener;
        private Job fCurrentJob;
        private ListenerList<ISelectionListenerWithAST> fAstListeners;
        private final Object fJobLock = new Object();

        public PartListenerGroup(ITextEditor editorPart) {
            this.fPart = editorPart;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList(1);
            this.fSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        this.fireSelectionChanged((ITextSelection)selection);
                    }
                }
            };
            this.fPostSelectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (part == fPart && selection instanceof ITextSelection) {
                        this.firePostSelectionChanged((ITextSelection)selection);
                    }
                }
            };
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST listener) {
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().addPostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.addSelectionChangedListener(this.fSelectionListener);
                }
            }
            this.fAstListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithAST listener) {
            this.fAstListeners.remove((Object)listener);
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().removePostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
                }
            }
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(final ITextSelection selection) {
            ITypeRoot input;
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
            if (!((input = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fPart, false)) instanceof ITypeRoot)) {
                return;
            }
            final ITypeRoot typeRoot = input;
            this.fCurrentJob = new Job(JavaUIMessages.SelectionListenerWithASTManager_job_title){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    Object object = fJobLock;
                    synchronized (object) {
                        return this.calculateASTandInform(typeRoot, selection, monitor);
                    }
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.setSystem(true);
            this.fCurrentJob.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected final IStatus calculateASTandInform(ITypeRoot input, ITextSelection selection, IProgressMonitor monitor) {
            block7: {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    astRoot = SharedASTProvider.getAST(input, SharedASTProvider.WAIT_ACTIVE_ONLY, monitor);
                    if (astRoot == null || monitor.isCanceled()) break block7;
                    var6_5 = this;
                    synchronized (var6_5) {
                        listeners = this.fAstListeners.iterator();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var6_5
                        if (true) ** GOTO lbl19
                    }
                    do {
                        listener = (ISelectionListenerWithAST)listeners.next();
                        listener.selectionChanged((IEditorPart)this.fPart, selection, astRoot);
                        if (!monitor.isCanceled()) continue;
                        return Status.CANCEL_STATUS;
lbl19:
                        // 2 sources

                    } while (listeners.hasNext());
                    return Status.OK_STATUS;
                }
                catch (OperationCanceledException v1) {}
            }
            return Status.CANCEL_STATUS;
        }
    }
}

