/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.datatype.impl;

import org.eclipse.efm.ecore.formalml.datatype.ChoiceType;
import org.eclipse.efm.ecore.formalml.datatype.CollectionKind;
import org.eclipse.efm.ecore.formalml.datatype.CollectionType;
import org.eclipse.efm.ecore.formalml.datatype.DataTypeReference;
import org.eclipse.efm.ecore.formalml.datatype.DatatypeFactory;
import org.eclipse.efm.ecore.formalml.datatype.DatatypePackage;
import org.eclipse.efm.ecore.formalml.datatype.EnumerationLiteral;
import org.eclipse.efm.ecore.formalml.datatype.EnumerationType;
import org.eclipse.efm.ecore.formalml.datatype.IntervalType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveBooleanType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveCharacterType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveFloatType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveInstanceKind;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveInstanceType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveIntegerType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveNumberSign;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveRationalType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveRealType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveStringType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveTimeType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveTypeKind;
import org.eclipse.efm.ecore.formalml.datatype.StructureType;
import org.eclipse.efm.ecore.formalml.datatype.UnionType;
import org.eclipse.efm.ecore.formalml.datatype.impl.ChoiceTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.CollectionTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.DataTypeReferenceImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.EnumerationLiteralImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.EnumerationTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.IntervalTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveBooleanTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveCharacterTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveFloatTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveInstanceTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveIntegerTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveRationalTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveRealTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveStringTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.PrimitiveTimeTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.StructureTypeImpl;
import org.eclipse.efm.ecore.formalml.datatype.impl.UnionTypeImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DatatypeFactoryImpl
extends EFactoryImpl
implements DatatypeFactory {
    public static DatatypeFactory init() {
        try {
            DatatypeFactory theDatatypeFactory = (DatatypeFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/efm/FormalML/DataType");
            if (theDatatypeFactory != null) {
                return theDatatypeFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DatatypeFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createDataTypeReference();
            }
            case 2: {
                return this.createEnumerationLiteral();
            }
            case 3: {
                return this.createEnumerationType();
            }
            case 5: {
                return this.createStructureType();
            }
            case 6: {
                return this.createUnionType();
            }
            case 7: {
                return this.createChoiceType();
            }
            case 9: {
                return this.createIntervalType();
            }
            case 10: {
                return this.createCollectionType();
            }
            case 12: {
                return this.createPrimitiveBooleanType();
            }
            case 14: {
                return this.createPrimitiveIntegerType();
            }
            case 15: {
                return this.createPrimitiveRationalType();
            }
            case 16: {
                return this.createPrimitiveFloatType();
            }
            case 17: {
                return this.createPrimitiveRealType();
            }
            case 18: {
                return this.createPrimitiveTimeType();
            }
            case 19: {
                return this.createPrimitiveCharacterType();
            }
            case 20: {
                return this.createPrimitiveStringType();
            }
            case 21: {
                return this.createPrimitiveInstanceType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 22: {
                return this.createPrimitiveTypeKindFromString(eDataType, initialValue);
            }
            case 23: {
                return this.createCollectionKindFromString(eDataType, initialValue);
            }
            case 24: {
                return this.createPrimitiveNumberSignFromString(eDataType, initialValue);
            }
            case 25: {
                return this.createPrimitiveInstanceKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 22: {
                return this.convertPrimitiveTypeKindToString(eDataType, instanceValue);
            }
            case 23: {
                return this.convertCollectionKindToString(eDataType, instanceValue);
            }
            case 24: {
                return this.convertPrimitiveNumberSignToString(eDataType, instanceValue);
            }
            case 25: {
                return this.convertPrimitiveInstanceKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public DataTypeReference createDataTypeReference() {
        DataTypeReferenceImpl dataTypeReference = new DataTypeReferenceImpl();
        return dataTypeReference;
    }

    @Override
    public EnumerationLiteral createEnumerationLiteral() {
        EnumerationLiteralImpl enumerationLiteral = new EnumerationLiteralImpl();
        return enumerationLiteral;
    }

    @Override
    public EnumerationType createEnumerationType() {
        EnumerationTypeImpl enumerationType = new EnumerationTypeImpl();
        return enumerationType;
    }

    @Override
    public StructureType createStructureType() {
        StructureTypeImpl structureType = new StructureTypeImpl();
        return structureType;
    }

    @Override
    public UnionType createUnionType() {
        UnionTypeImpl unionType = new UnionTypeImpl();
        return unionType;
    }

    @Override
    public ChoiceType createChoiceType() {
        ChoiceTypeImpl choiceType = new ChoiceTypeImpl();
        return choiceType;
    }

    @Override
    public IntervalType createIntervalType() {
        IntervalTypeImpl intervalType = new IntervalTypeImpl();
        return intervalType;
    }

    @Override
    public CollectionType createCollectionType() {
        CollectionTypeImpl collectionType = new CollectionTypeImpl();
        return collectionType;
    }

    @Override
    public PrimitiveBooleanType createPrimitiveBooleanType() {
        PrimitiveBooleanTypeImpl primitiveBooleanType = new PrimitiveBooleanTypeImpl();
        return primitiveBooleanType;
    }

    @Override
    public PrimitiveIntegerType createPrimitiveIntegerType() {
        PrimitiveIntegerTypeImpl primitiveIntegerType = new PrimitiveIntegerTypeImpl();
        return primitiveIntegerType;
    }

    @Override
    public PrimitiveRationalType createPrimitiveRationalType() {
        PrimitiveRationalTypeImpl primitiveRationalType = new PrimitiveRationalTypeImpl();
        return primitiveRationalType;
    }

    @Override
    public PrimitiveFloatType createPrimitiveFloatType() {
        PrimitiveFloatTypeImpl primitiveFloatType = new PrimitiveFloatTypeImpl();
        return primitiveFloatType;
    }

    @Override
    public PrimitiveRealType createPrimitiveRealType() {
        PrimitiveRealTypeImpl primitiveRealType = new PrimitiveRealTypeImpl();
        return primitiveRealType;
    }

    @Override
    public PrimitiveTimeType createPrimitiveTimeType() {
        PrimitiveTimeTypeImpl primitiveTimeType = new PrimitiveTimeTypeImpl();
        return primitiveTimeType;
    }

    @Override
    public PrimitiveCharacterType createPrimitiveCharacterType() {
        PrimitiveCharacterTypeImpl primitiveCharacterType = new PrimitiveCharacterTypeImpl();
        return primitiveCharacterType;
    }

    @Override
    public PrimitiveStringType createPrimitiveStringType() {
        PrimitiveStringTypeImpl primitiveStringType = new PrimitiveStringTypeImpl();
        return primitiveStringType;
    }

    @Override
    public PrimitiveInstanceType createPrimitiveInstanceType() {
        PrimitiveInstanceTypeImpl primitiveInstanceType = new PrimitiveInstanceTypeImpl();
        return primitiveInstanceType;
    }

    public PrimitiveTypeKind createPrimitiveTypeKindFromString(EDataType eDataType, String initialValue) {
        PrimitiveTypeKind result = PrimitiveTypeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertPrimitiveTypeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public CollectionKind createCollectionKindFromString(EDataType eDataType, String initialValue) {
        CollectionKind result = CollectionKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCollectionKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public PrimitiveNumberSign createPrimitiveNumberSignFromString(EDataType eDataType, String initialValue) {
        PrimitiveNumberSign result = PrimitiveNumberSign.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertPrimitiveNumberSignToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public PrimitiveInstanceKind createPrimitiveInstanceKindFromString(EDataType eDataType, String initialValue) {
        PrimitiveInstanceKind result = PrimitiveInstanceKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertPrimitiveInstanceKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DatatypePackage getDatatypePackage() {
        return (DatatypePackage)this.getEPackage();
    }

    @Deprecated
    public static DatatypePackage getPackage() {
        return DatatypePackage.eINSTANCE;
    }
}

