/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.annotations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.osgi.resource.Resource;

public class OSGiAnnotationsClasspathContributor
implements IClasspathContributor {
    private static final Collection<String> OSGI_ANNOTATIONS = List.of("org.osgi.annotation.versioning", "org.osgi.annotation.bundle", "org.osgi.service.component.annotations", "org.osgi.service.metatype.annotations");

    @Override
    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IPluginModelBase projectModel = PluginRegistry.findModel((Resource)project);
        if (projectModel != null) {
            return ClasspathUtilCore.classpathEntries(OSGiAnnotationsClasspathContributor.annotations().filter(model -> !model.equals(projectModel))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Stream<IPluginModelBase> annotations() {
        return OSGI_ANNOTATIONS.stream().map(PluginRegistry::findModel).filter(Objects::nonNull).filter(IPluginModelBase::isEnabled);
    }

    @Override
    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }
}

