/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.commands.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;

public final class Util {
    public static final String ZERO_LENGTH_STRING = "";

    public static final void assertInstance(Object object, Class<?> c, boolean allowNull) {
        if (object == null && allowNull) {
            return;
        }
        if (object == null || c == null) {
            throw new NullPointerException();
        }
        if (!c.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static final int compare(boolean left, boolean right) {
        return !left ? (right ? -1 : 0) : (right ? 0 : 1);
    }

    public static final <T extends Comparable<? super T>> int compare(T left, T right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public static final int compare(int left, int right) {
        return left - right;
    }

    public static final int compare(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.toString().compareTo(right.toString());
    }

    public static final <K, V> Map<K, V> safeCopy(Map<K, V> map, Class<K> keyClass, Class<V> valueClass, boolean allowNullKeys, boolean allowNullValues) {
        if (map == null || keyClass == null || valueClass == null) {
            throw new NullPointerException();
        }
        Map<K, V> copy = Collections.unmodifiableMap(new HashMap<K, V>(map));
        for (Map.Entry<K, V> entry : copy.entrySet()) {
            Util.assertInstance(entry.getKey(), keyClass, allowNullKeys);
            Util.assertInstance(entry.getValue(), valueClass, allowNullValues);
        }
        return copy;
    }

    public static final <T> Set<T> safeCopy(Set<T> set, Class<T> c) {
        return Util.safeCopy(set, c, false);
    }

    public static final <T> Set<T> safeCopy(Set<T> set, Class<T> c, boolean allowNullElements) {
        if (set == null || c == null) {
            throw new NullPointerException();
        }
        Set<T> copy = Collections.unmodifiableSet(new HashSet<T>(set));
        Iterator<T> iterator = copy.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), c, allowNullElements);
        }
        return copy;
    }

    public static final String getHelpContextId(Command command) {
        Method method = null;
        try {
            method = Command.class.getDeclaredMethod("getHelpContextId", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String contextId = null;
        if (method != null) {
            boolean accessible = method.isAccessible();
            method.setAccessible(true);
            try {
                contextId = (String)method.invoke((Object)command, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            method.setAccessible(accessible);
        }
        return contextId;
    }

    private Util() {
    }
}

