/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaInclude;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaOverviewPage;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SchemaIncludesSection
extends TableSection {
    private TableViewer fViewer;

    public SchemaIncludesSection(SchemaOverviewPage page, Composite parent) {
        super((PDEFormPage)page, parent, 128, new String[]{PDEUIMessages.SchemaIncludesSection_addButton, PDEUIMessages.SchemaIncludesSection_removeButton});
        this.getSection().setText(PDEUIMessages.SchemaIncludesSection_title);
        this.getSection().setDescription(PDEUIMessages.SchemaIncludesSection_description);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fViewer = tablePart.getTableViewer();
        this.fViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.getSchema().addModelChangedListener((IModelChangedListener)this);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayoutData((Object)new GridData(1808));
        this.initialize();
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNewInclude();
        } else {
            this.handleRemoveInclude();
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)selection);
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        if (!this.getSchema().isEditable()) {
            return;
        }
        Object object = this.fViewer.getStructuredSelection().getFirstElement();
        this.getTablePart().setButtonEnabled(1, object instanceof ISchemaInclude);
    }

    public void dispose() {
        ISchema schema = this.getSchema();
        if (schema != null) {
            schema.removeModelChangedListener((IModelChangedListener)this);
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        Object[] objects;
        int changeType = e.getChangeType();
        if (changeType == 99) {
            this.markStale();
            return;
        }
        Object[] objectArray = objects = e.getChangedObjects();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object changedObject = objectArray[n2];
            if (changedObject instanceof ISchemaInclude) {
                if (changeType == 1) {
                    this.fViewer.add(changedObject);
                } else if (changeType == 2) {
                    this.fViewer.remove(changedObject);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemoveInclude();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    private ISchema getSchema() {
        return (ISchema)this.getPage().getModel();
    }

    protected void handleRemoveInclude() {
        IStructuredSelection selection = this.fViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] selected = selection.toArray();
        Schema schema = (Schema)this.getSchema();
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            schema.removeInclude((ISchemaInclude)selectedObject);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleNewInclude() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.ProductExportWizardPage_fileSelection);
        dialog.setMessage(PDEUIMessages.SchemaIncludesSection_dialogMessage);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("exsd"));
        dialog.addFilter((ViewerFilter)new PDEProjectFilter());
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            void newInclude;
            Object result = dialog.getFirstResult();
            Object object = result;
            if (!(object instanceof IFile)) {
                return;
            }
            IFile iFile = (IFile)object;
            IFile cfr_ignored_0 = (IFile)object;
            String location = this.getIncludeLocation((IFile)newInclude);
            SchemaInclude include = new SchemaInclude((ISchemaObject)this.getSchema(), location, false);
            ISchema schema = this.getSchema();
            if (schema instanceof Schema) {
                ((Schema)schema).addInclude((ISchemaInclude)include);
            }
        }
    }

    private void initialize() {
        this.refresh();
    }

    private String getIncludeLocation(IFile file) {
        IPath currPath;
        IEditorInput input = this.getPage().getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        IPath schemaPath = ((IFileEditorInput)input).getFile().getFullPath();
        int matchinSegments = schemaPath.matchingFirstSegments(currPath = file.getFullPath());
        if (matchinSegments > 0) {
            schemaPath = schemaPath.removeFirstSegments(matchinSegments);
            currPath = currPath.removeFirstSegments(matchinSegments);
            if (schemaPath.segmentCount() == 1) {
                return currPath.toString();
            }
            StringBuilder sb = new StringBuilder();
            while (schemaPath.segmentCount() > 1) {
                sb.append("../");
                schemaPath = schemaPath.removeFirstSegments(1);
            }
            String location = sb.toString() + currPath.toString();
            return location.trim().length() > 0 ? location : null;
        }
        IPluginModelBase model = PluginRegistry.findModel((IProject)file.getProject());
        String id = model.getPluginBase().getId();
        if (id != null) {
            return "schema://" + id + "/" + file.getProjectRelativePath().toString();
        }
        return null;
    }

    private boolean isUnlistedInclude(IFile file) {
        ISchemaInclude[] includes;
        String location = this.getIncludeLocation(file);
        if (location == null) {
            return false;
        }
        boolean unlisted = true;
        ISchemaInclude[] iSchemaIncludeArray = includes = this.getSchema().getIncludes();
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            ISchemaInclude include = iSchemaIncludeArray[n2];
            if (include.getLocation().equals(location)) {
                unlisted = false;
                break;
            }
            ++n2;
        }
        return unlisted;
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof ISchemaInclude) {
            IEditorInput edinput = this.getPage().getEditorInput();
            if (!(edinput instanceof IFileEditorInput)) {
                return;
            }
            String path = ((ISchemaInclude)object).getLocation();
            IPath includePath = IPath.fromOSString((String)((ISchemaInclude)object).getLocation());
            boolean result = false;
            if (path.startsWith("schema:")) {
                result = SchemaEditor.openSchema(includePath);
            } else {
                IFile currSchemaFile = ((IFileEditorInput)edinput).getFile();
                IProject project = currSchemaFile.getProject();
                IPath currSchemaPath = currSchemaFile.getProjectRelativePath();
                IFile file = project.getFile(currSchemaPath.removeLastSegments(1).append(includePath));
                result = SchemaEditor.openSchema(file);
            }
            if (!result) {
                MessageDialog.openWarning((Shell)this.getPage().getSite().getShell(), (String)PDEUIMessages.SchemaIncludesSection_missingWarningTitle, (String)NLS.bind((String)PDEUIMessages.SchemaIncludesSection_missingWarningMessage, (Object)includePath.toString()));
            }
        }
    }

    public void refresh() {
        this.getTablePart().setButtonEnabled(0, this.getSchema().isEditable());
        this.getTablePart().setButtonEnabled(1, false);
        this.fViewer.setInput((Object)this.getSchema().getIncludes());
        super.refresh();
    }

    class PDEProjectFilter
    extends ViewerFilter {
        PDEProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                try {
                    return ((IProject)element).hasNature("org.eclipse.pde.PluginNature");
                }
                catch (CoreException coreException) {
                }
            } else if (element instanceof IFile) {
                return SchemaIncludesSection.this.isUnlistedInclude((IFile)element);
            }
            return true;
        }
    }
}

