/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassCreator;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHint;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSPropertyFileModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSourceModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.osgi.util.NLS;

public class NLSRefactoring
extends Refactoring {
    public static final String BUNDLE_NAME_FIELD = "BUNDLE_NAME";
    public static final String PROPERTY_FILE_EXT = ".properties";
    public static final String DEFAULT_ACCESSOR_CLASSNAME = "Messages";
    public static final String KEY = "${key}";
    public static final String DEFAULT_SUBST_PATTERN = "getString(${key})";
    public static final String DEFAULT_PROPERTY_FILENAME = "messages";
    private String fAccessorClassName;
    private IPackageFragment fAccessorClassPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private String fSubstitutionPattern;
    private ICompilationUnit fCu;
    private NLSSubstitution[] fSubstitutions;
    private String fPrefix;
    private boolean fIsEclipseNLS;

    private NLSRefactoring(ICompilationUnit cu) {
        Assert.isNotNull((Object)cu);
        this.fCu = cu;
        CompilationUnit astRoot = SharedASTProviderCore.getAST((ITypeRoot)this.fCu, SharedASTProviderCore.WAIT_YES, null);
        NLSHint nlsHint = new NLSHint(this.fCu, astRoot);
        this.fSubstitutions = nlsHint.getSubstitutions();
        this.setAccessorClassName(nlsHint.getAccessorClassName());
        this.setAccessorClassPackage(nlsHint.getAccessorClassPackage());
        this.setIsEclipseNLS(this.detectIsEclipseNLS());
        this.setResourceBundleName(nlsHint.getResourceBundleName());
        this.setResourceBundlePackage(nlsHint.getResourceBundlePackage());
        this.setSubstitutionPattern(DEFAULT_SUBST_PATTERN);
        String cuName = this.fCu.getElementName();
        if (this.fIsEclipseNLS) {
            this.setPrefix(cuName.substring(0, cuName.length() - 5) + "_");
        } else {
            this.setPrefix(cuName.substring(0, cuName.length() - 4));
        }
    }

    public static NLSRefactoring create(ICompilationUnit cu) {
        if (cu == null || !cu.exists()) {
            return null;
        }
        return new NLSRefactoring(cu);
    }

    public boolean isEclipseNLSAvailable() {
        if (this.getCu() == null) {
            return false;
        }
        IJavaProject javaProject = this.getCu().getJavaProject();
        if (javaProject == null || !javaProject.exists()) {
            return false;
        }
        try {
            return javaProject.findType("org.eclipse.osgi.util.NLS") != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public void setSubstitutionPattern(String pattern) {
        Assert.isNotNull((Object)pattern);
        this.fSubstitutionPattern = pattern;
    }

    public String getSubstitutionPattern() {
        if (this.fIsEclipseNLS) {
            return KEY;
        }
        return this.fSubstitutionPattern;
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public String getName() {
        return Messages.format(NLSMessages.NLSRefactoring_compilation_unit, BasicElementLabels.getFileName((ITypeRoot)this.fCu));
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fSubstitutions.length == 0) {
            String message = Messages.format(NLSMessages.NLSRefactoring_no_strings, BasicElementLabels.getFileName((ITypeRoot)this.fCu));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        this.checkParameters();
        try {
            pm.beginTask(NLSMessages.NLSRefactoring_checking, 5);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkIfAnythingToDo());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.validateModifiesFiles(pm));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkSubstitutionPattern());
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkKeys());
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!this.propertyFileExists() && this.willModifyPropertyFile()) {
                String msg = Messages.format(NLSMessages.NLSRefactoring_will_be_created, BasicElementLabels.getPathLabel(this.getPropertyFilePath(), false));
                result.addInfo(msg);
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            this.checkParameters();
            pm.beginTask("", 3);
            DynamicValidationStateChange result = new DynamicValidationStateChange(NLSMessages.NLSRefactoring_change_name);
            boolean createAccessorClass = this.willCreateAccessorClass();
            if (NLSSubstitution.countItems(this.fSubstitutions, 0) == 0) {
                createAccessorClass = false;
            }
            if (createAccessorClass) {
                result.add(AccessorClassCreator.create(this.fCu, this.fAccessorClassName, this.getAccessorCUPath(), this.fAccessorClassPackage, this.getPropertyFilePath(), this.fIsEclipseNLS, this.fSubstitutions, this.getSubstitutionPattern(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
            pm.worked(1);
            if (this.willModifySource()) {
                result.add(NLSSourceModifier.create(this.getCu(), this.fSubstitutions, this.getSubstitutionPattern(), this.fAccessorClassPackage, this.fAccessorClassName, this.fIsEclipseNLS));
            }
            pm.worked(1);
            if (this.willModifyPropertyFile()) {
                Change change;
                result.add(NLSPropertyFileModifier.create(this.fSubstitutions, this.getPropertyFilePath()));
                if (this.isEclipseNLS() && !createAccessorClass && (change = AccessorClassModifier.create(this.getAccessorCu(), this.fSubstitutions)) != null) {
                    result.add(change);
                }
            }
            pm.worked(1);
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private void checkParameters() {
        Assert.isNotNull((Object)this.fSubstitutions);
        Assert.isNotNull((Object)this.fAccessorClassPackage);
        Assert.isNotNull((Object)this.fAccessorClassName);
        Assert.isNotNull((Object)this.getSubstitutionPattern());
    }

    private IFile[] getAllFilesToModify() {
        IFile file;
        IResource resource;
        ArrayList<Object> files = new ArrayList<Object>(2);
        if (this.willModifySource() && (resource = this.fCu.getResource()).exists()) {
            files.add(resource);
        }
        if (this.willModifyPropertyFile() && (file = this.getPropertyFileHandle()).exists()) {
            files.add(file);
        }
        if (this.willModifyAccessorClass() && (file = this.getAccessorClassFileHandle()).exists()) {
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    public IFile getPropertyFileHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getPropertyFilePath());
    }

    public IPath getPropertyFilePath() {
        return this.fResourceBundlePackage.getPath().append(this.fResourceBundleName);
    }

    public IFile getAccessorClassFileHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getAccessorClassFilePath());
    }

    public IPath getAccessorClassFilePath() {
        return this.getAccessorCUPath();
    }

    private RefactoringStatus validateModifiesFiles(IProgressMonitor pm) throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext(), pm);
    }

    private RefactoringStatus checkIfAnythingToDo() throws JavaModelException {
        if (NLSSubstitution.countItems(this.fSubstitutions, 0) != 0 && this.willCreateAccessorClass()) {
            return null;
        }
        if (this.willModifyPropertyFile()) {
            return null;
        }
        if (this.willModifySource()) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        result.addFatalError(NLSMessages.NLSRefactoring_nothing_to_do);
        return result;
    }

    private boolean propertyFileExists() {
        return this.getPropertyFileHandle().exists();
    }

    private RefactoringStatus checkSubstitutionPattern() {
        String msg;
        String pattern = this.getSubstitutionPattern();
        RefactoringStatus result = new RefactoringStatus();
        if (pattern.trim().length() == 0) {
            result.addError(NLSMessages.NLSRefactoring_pattern_empty);
        }
        if (!pattern.contains(KEY)) {
            msg = Messages.format(NLSMessages.NLSRefactoring_pattern_does_not_contain, KEY);
            result.addWarning(msg);
        }
        if (pattern.indexOf(KEY) != pattern.lastIndexOf(KEY)) {
            msg = Messages.format(NLSMessages.NLSRefactoring_Only_the_first_occurrence_of, KEY);
            result.addWarning(msg);
        }
        return result;
    }

    private RefactoringStatus checkKeys() {
        RefactoringStatus result = new RefactoringStatus();
        NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
        int n = this.fSubstitutions.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution substitution = nLSSubstitutionArray[n2];
            if (substitution.getState() == 0 && substitution.hasStateChanged()) {
                result.merge(NLSRefactoring.checkKey(substitution.getKey()));
            }
            ++n2;
        }
        return result;
    }

    private static RefactoringStatus checkKey(String key) {
        String[] UNWANTED_STRINGS;
        RefactoringStatus result = new RefactoringStatus();
        if (key == null) {
            result.addFatalError(NLSMessages.NLSRefactoring_null);
        }
        if (key.startsWith("!") || key.startsWith("#")) {
            JavaStringStatusContext context = new JavaStringStatusContext(key, (ISourceRange)new SourceRange(0, 0));
            result.addWarning(NLSMessages.NLSRefactoring_warning, (RefactoringStatusContext)context);
        }
        if ("".equals(key.trim())) {
            result.addFatalError(NLSMessages.NLSRefactoring_empty);
        }
        String[] stringArray = UNWANTED_STRINGS = new String[]{" ", ":", "\"", "\\", "'", "?", "="};
        int n = UNWANTED_STRINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (key.contains(s)) {
                Object[] args = new String[]{key, s};
                String msg = Messages.format(NLSMessages.NLSRefactoring_should_not_contain, args);
                result.addError(msg);
            }
            ++n2;
        }
        return result;
    }

    public boolean willCreateAccessorClass() throws JavaModelException {
        ICompilationUnit compilationUnit = this.getAccessorCu();
        if (compilationUnit.exists()) {
            return false;
        }
        if (this.typeNameExistsInPackage(this.fAccessorClassPackage, this.fAccessorClassName)) {
            return false;
        }
        return !Checks.resourceExists(this.getAccessorCUPath());
    }

    private ICompilationUnit getAccessorCu() {
        return this.fAccessorClassPackage.getCompilationUnit(this.getAccessorCUName());
    }

    private boolean willModifySource() {
        NLSSubstitution[] subs;
        NLSSubstitution[] nLSSubstitutionArray = subs = this.fSubstitutions;
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution sub = nLSSubstitutionArray[n2];
            if (sub.hasSourceChange()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean willModifyPropertyFile() {
        NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
        int n = this.fSubstitutions.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution substitution = nLSSubstitutionArray[n2];
            if (substitution.hasPropertyFileChange()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean willModifyAccessorClass() {
        if (!this.isEclipseNLS()) {
            return false;
        }
        NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
        int n = this.fSubstitutions.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution substitution = nLSSubstitutionArray[n2];
            if (substitution.hasAccessorClassChange()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean typeNameExistsInPackage(IPackageFragment pack, String name) throws JavaModelException {
        return Checks.findTypeInPackage(pack, name) != null;
    }

    private String getAccessorCUName() {
        return this.getAccessorClassName() + ".java";
    }

    private IPath getAccessorCUPath() {
        return this.fAccessorClassPackage.getPath().append(this.getAccessorCUName());
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
        if (this.fSubstitutions != null) {
            NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
            int n = this.fSubstitutions.length;
            int n2 = 0;
            while (n2 < n) {
                NLSSubstitution fSubstitution = nLSSubstitutionArray[n2];
                fSubstitution.setPrefix(prefix);
                ++n2;
            }
        }
    }

    public void setAccessorClassName(String name) {
        Assert.isNotNull((Object)name);
        this.fAccessorClassName = name;
    }

    public void setAccessorClassPackage(IPackageFragment packageFragment) {
        Assert.isNotNull((Object)packageFragment);
        this.fAccessorClassPackage = packageFragment;
    }

    public void setIsEclipseNLS(boolean isEclipseNLS) {
        this.fIsEclipseNLS = isEclipseNLS;
    }

    public void setResourceBundlePackage(IPackageFragment resourceBundlePackage) {
        Assert.isNotNull((Object)resourceBundlePackage);
        this.fResourceBundlePackage = resourceBundlePackage;
    }

    public void setResourceBundleName(String resourceBundleName) {
        Assert.isNotNull((Object)resourceBundleName);
        this.fResourceBundleName = resourceBundleName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorClassPackage;
    }

    public boolean detectIsEclipseNLS() {
        ICompilationUnit accessorCU = this.getAccessorClassPackage().getCompilationUnit(this.getAccessorCUName());
        IType type = accessorCU.getType(this.getAccessorClassName());
        if (type.exists()) {
            block4: {
                try {
                    String superclassName = type.getSuperclassName();
                    if ("NLS".equals(superclassName) || NLS.class.getName().equals(superclassName)) break block4;
                    return false;
                }
                catch (JavaModelException javaModelException) {}
            }
            IType superclass = type.newSupertypeHierarchy(null).getSuperclass(type);
            return superclass != null && NLS.class.getName().equals(superclass.getFullyQualifiedName());
        }
        return this.isEclipseNLSAvailable();
    }

    public boolean isEclipseNLS() {
        return this.fIsEclipseNLS;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public String getAccessorClassName() {
        return this.fAccessorClassName;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }
}

