/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.controller.smcubes.component.importexport.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.efbt.controller.smcubes.access_dependencies_plugin.access.api.AccessRow;
import org.eclipse.efbt.controller.smcubes.access_dependencies_plugin.access.api.AccessUtils;
import org.eclipse.efbt.controller.smcubes.component.access.provider.AccessUtilProvider;
import org.eclipse.efbt.controller.smcubes.component.importexport.impl.Importer;
import org.eclipse.efbt.openregspecs.model.open_reg_specs.DOMAIN;
import org.eclipse.efbt.openregspecs.model.open_reg_specs.FACET_VALUE_TYPE;
import org.eclipse.efbt.openregspecs.model.open_reg_specs.MEMBER;
import org.eclipse.efbt.openregspecs.model.open_reg_specs.Open_reg_specsFactory;
import org.eclipse.efbt.openregspecs.model.open_reg_specs.SUBDOMAIN;
import org.eclipse.efbt.openregspecs.model.open_reg_specs.SUBDOMAIN_ENUMERATION;
import org.eclipse.efbt.openregspecs.model.open_reg_specs.VARIABLE;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class BIRDImporterImpl
extends Importer {
    @Override
    public void doImport(String theFilepath, String theOutputFilepath) {
        super.doImport(theFilepath, theOutputFilepath);
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    private String replaceDots(String string) {
        return string.replace('.', '_');
    }

    private MEMBER findMemberWithID(String elementID) {
        EList memberList = this.members.getMembers();
        MEMBER returnMember = null;
        for (MEMBER mem : memberList) {
            if (!elementID.equals(mem.getName())) continue;
            returnMember = mem;
        }
        return returnMember;
    }

    private VARIABLE findVariableWithID(String elementID) {
        EList variableList = this.variables.getVariables();
        VARIABLE returnVariable = null;
        for (VARIABLE var : variableList) {
            if (!elementID.equals(var.getName())) continue;
            returnVariable = var;
        }
        return returnVariable;
    }

    @Override
    public void createAllDomains() {
        AccessUtils accessUtils = AccessUtilProvider.getAccessUtils();
        try {
            List list = accessUtils.getRowsForTable(this.filepath, "DOMAIN");
            for (AccessRow row : list) {
                DOMAIN domain = Open_reg_specsFactory.eINSTANCE.createDOMAIN();
                domain.setCode(row.getString("CODE"));
                domain.setDescription(row.getString("DESCRIPTION"));
                String dataTypeString = row.getString("DATA_TYPE");
                if (dataTypeString != null) {
                    FACET_VALUE_TYPE valueType;
                    if (dataTypeString.contains("tring")) {
                        valueType = FACET_VALUE_TYPE.STRING;
                        domain.setData_type(valueType);
                    }
                    if (dataTypeString.contains("nteger")) {
                        valueType = FACET_VALUE_TYPE.BIG_INTEGER;
                        domain.setData_type(valueType);
                    }
                    if (dataTypeString.contains("ate")) {
                        valueType = FACET_VALUE_TYPE.DATE_TIME;
                        domain.setData_type(valueType);
                    }
                    if (dataTypeString.contains("umber") || dataTypeString.contains("onetary")) {
                        valueType = FACET_VALUE_TYPE.DECIMAL;
                        domain.setData_type(valueType);
                    }
                    if (dataTypeString.contains("oolean")) {
                        valueType = FACET_VALUE_TYPE.BOOLEAN;
                        domain.setData_type(valueType);
                    }
                }
                domain.setName(this.replaceDots(row.getString("DOMAIN_ID")));
                domain.setDisplayName(row.getString("NAME"));
                boolean is_enumerated = false;
                if (row.getBoolean("IS_ENUMERATED").booleanValue()) {
                    is_enumerated = true;
                }
                domain.setIs_enumerated(is_enumerated);
                boolean is_referenced = false;
                if (row.getBoolean("IS_REFERENCE").booleanValue()) {
                    is_referenced = true;
                }
                domain.setIs_reference(is_referenced);
                this.domains.getDomains().add((Object)domain);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createAllSubdomains() {
        AccessUtils accessUtils = AccessUtilProvider.getAccessUtils();
        try {
            List list = accessUtils.getRowsForTable(this.filepath, "SUBDOMAIN");
            for (AccessRow row : list) {
                SUBDOMAIN subDomain = Open_reg_specsFactory.eINSTANCE.createSUBDOMAIN();
                subDomain.setCode(row.getString("CODE"));
                subDomain.setName(this.replaceDots(row.getString("SUBDOMAIN_ID")));
                subDomain.setDescription(row.getString("DESCRIPTION"));
                String domainIDString = row.getString("DOMAIN_ID");
                DOMAIN domain = this.getDomainWithID(domainIDString);
                subDomain.setDomain_id(domain);
                this.subdomains.getSubdomains().add((Object)subDomain);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createAllSubdomainEnumerarions() {
        AccessUtils accessUtils = AccessUtilProvider.getAccessUtils();
        try {
            List list = accessUtils.getRowsForTable(this.filepath, "SUBDOMAIN_ENUMERATION");
            for (AccessRow row : list) {
                String subdomainIDString = row.getString("SUBDOMAIN_ID");
                SUBDOMAIN subdomain = this.getSubdomainWithID(subdomainIDString);
                String memberID = row.getString("MEMBER_ID");
                DOMAIN domain = subdomain.getDomain_id();
                MEMBER member = this.getMemberWithIDAndDomain(memberID, domain);
                SUBDOMAIN_ENUMERATION subDomainEnum = Open_reg_specsFactory.eINSTANCE.createSUBDOMAIN_ENUMERATION();
                subDomainEnum.setMember_id(member);
                try {
                    subDomainEnum.setOrder(Integer.parseInt(row.getString("ORDER")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                subdomain.getItems().add((Object)subDomainEnum);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createAllMembers() {
        AccessUtils accessUtils = AccessUtilProvider.getAccessUtils();
        try {
            List list = accessUtils.getRowsForTable(this.filepath, "MEMBER");
            for (AccessRow row : list) {
                MEMBER member = Open_reg_specsFactory.eINSTANCE.createMEMBER();
                member.setCode(row.getString("CODE"));
                member.setDescription(row.getString("DESCRIPTION"));
                member.setName(this.replaceDots(row.getString("MEMBER_ID")));
                member.setDisplayName(row.getString("NAME"));
                String domainIDString = row.getString("DOMAIN_ID");
                DOMAIN domain = this.getDomainWithID(domainIDString);
                member.setDomain_id(domain);
                this.members.getMembers().add((Object)member);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private DOMAIN getDomainWithID(String domainIDString) {
        EList domainList = this.domains.getDomains();
        DOMAIN returnDomain = null;
        for (DOMAIN dom : domainList) {
            if (!domainIDString.equals(dom.getName())) continue;
            returnDomain = dom;
        }
        return returnDomain;
    }

    private SUBDOMAIN getSubdomainWithID(String subDomainIDString) {
        EList subdomainList = this.subdomains.getSubdomains();
        SUBDOMAIN returnSubDomain = null;
        for (SUBDOMAIN subdom : subdomainList) {
            if (!subDomainIDString.equals(subdom.getName())) continue;
            returnSubDomain = subdom;
        }
        return returnSubDomain;
    }

    private MEMBER getMemberWithIDAndDomain(String memberID, DOMAIN domain) {
        EList memberList = this.members.getMembers();
        MEMBER returnMember = null;
        for (MEMBER member : memberList) {
            if (!memberID.equals(member.getName()) || !member.getDomain_id().equals(domain)) continue;
            returnMember = member;
        }
        return returnMember;
    }

    @Override
    public void createAllVariables() {
        AccessUtils accessUtils = AccessUtilProvider.getAccessUtils();
        try {
            List list = accessUtils.getRowsForTable(this.filepath, "VARIABLE");
            for (AccessRow row : list) {
                VARIABLE variable = Open_reg_specsFactory.eINSTANCE.createVARIABLE();
                variable.setCode(row.getString("CODE"));
                variable.setDescription(row.getString("DESCRIPTION"));
                variable.setName(this.replaceDots(row.getString("VARIABLE_ID")));
                variable.setDisplayName(row.getString("NAME"));
                String domainIDString = row.getString("DOMAIN_ID");
                DOMAIN domain = this.getDomainWithID(domainIDString);
                variable.setDomain_id(domain);
                this.variables.getVariables().add((Object)variable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private EList<MEMBER> getDomainMembers(DOMAIN domain) {
        BasicEList returnMembers = new BasicEList();
        EList allMembers = this.members.getMembers();
        for (MEMBER member : allMembers) {
            if (!member.getDomain_id().equals(domain)) continue;
            returnMembers.add((Object)member);
        }
        return returnMembers;
    }

    private static List<CSVRecord> getCSVRowsFromFile(String fileName) throws IOException {
        File csvData = new File(fileName);
        CSVParser parser = CSVParser.parse((File)csvData, (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.EXCEL);
        ArrayList<CSVRecord> list = new ArrayList<CSVRecord>();
        for (CSVRecord csvRecord : parser) {
            list.add(csvRecord);
        }
        return list;
    }

    public static void main(String[] args) {
        BIRDImporterImpl importer = new BIRDImporterImpl();
        String filepath = args[0];
        String outputFilepath = args[1];
        importer.doImport(filepath, outputFilepath);
    }
}

