/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.annotation.inheritance;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.spec.annotation.inheritance.AnnotatedClientEndpointSubclassWithOverrideAndAnnotations;
import com.sun.ts.tests.websocket.spec.annotation.inheritance.AnnotatedClientEndpointWithMultipleOnCloseAnnotations;
import com.sun.ts.tests.websocket.spec.annotation.inheritance.AnnotatedClientEndpointWithMultipleOnErrorAnnotations;
import com.sun.ts.tests.websocket.spec.annotation.inheritance.AnnotatedClientEndpointWithMultipleOnMessageAnnotations;
import com.sun.ts.tests.websocket.spec.annotation.inheritance.AnnotatedClientEndpointWithMultipleOnOpenAnnotations;
import com.sun.ts.tests.websocket.spec.annotation.inheritance.AnnotatedSubclassEndpointWithoutAnnotations;
import com.sun.ts.tests.websocket.spec.annotation.inheritance.EchoServer;
import jakarta.websocket.DeploymentException;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 3037319902828702665L;
    protected static final String MESSAGE = "message";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_spec_annotation_inheritance_web.war");
        archive.addClasses(new Class[]{EchoServer.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_spec_annotation_inheritance_web");
    }

    @Test
    public void annotationOnMethodIsInheritedTest() throws Exception {
        this.setAnnotatedClientEndpointInstance(new AnnotatedSubclassEndpointWithoutAnnotations());
        this.invoke("echo", MESSAGE, new String[]{MESSAGE});
        WSCClientIT.logMsg((Object[])new Object[]{"Annotations have been inherited as expected"});
    }

    @Test
    public void annotationOnMethodIsOverridenTest() throws Exception {
        this.setAnnotatedClientEndpointInstance(new AnnotatedClientEndpointSubclassWithOverrideAndAnnotations());
        this.invoke("echo", MESSAGE, new String[]{MESSAGE});
        WSCClientIT.logMsg((Object[])new Object[]{"Annotations have been overridden as expected"});
    }

    @Test
    public void annotationOnMessageIsTwiceTest() throws Exception {
        try {
            this.setAnnotatedClientEndpointInstance(new AnnotatedClientEndpointWithMultipleOnMessageAnnotations());
            this.logExceptionOnInvocation(false);
            this.invoke("echo", MESSAGE, new String[]{MESSAGE});
            new Exception("No exception has been thrown when multiple @OnMessage annotations defined");
        }
        catch (Exception e) {
            DeploymentException deploymentException = (DeploymentException)WSCClientIT.assertCause((Throwable)e, DeploymentException.class, (Object[])new Object[]{"DeploymentException has not been thrown when multiple @OnMessage annotations"});
        }
    }

    @Test
    public void annotationOnOpenIsTwiceTest() throws Exception {
        try {
            this.setAnnotatedClientEndpointInstance(new AnnotatedClientEndpointWithMultipleOnOpenAnnotations());
            this.logExceptionOnInvocation(false);
            this.invoke("echo", MESSAGE, new String[]{MESSAGE});
            new Exception("No exception has been thrown when multiple @OnOpen annotations defined");
        }
        catch (Exception e) {
            DeploymentException de = (DeploymentException)WSCClientIT.assertCause((Throwable)e, DeploymentException.class, (Object[])new Object[]{"DeploymentException has not been thrown when multiple @OnOpen annotations"});
            WSCClientIT.logMsg((Object[])new Object[]{"DeploymentException has been thrown as expected:", de});
        }
    }

    @Test
    public void annotationOnCloseIsTwiceTest() throws Exception {
        try {
            this.setAnnotatedClientEndpointInstance(new AnnotatedClientEndpointWithMultipleOnCloseAnnotations());
            this.logExceptionOnInvocation(false);
            this.invoke("echo", MESSAGE, new String[]{MESSAGE});
            new Exception("No exception has been thrown when multiple @OnClose annotations defined");
        }
        catch (Exception e) {
            DeploymentException deploymentException = (DeploymentException)WSCClientIT.assertCause((Throwable)e, DeploymentException.class, (Object[])new Object[]{"DeploymentException has not been thrown when multiple @OnClose annotations"});
        }
    }

    @Test
    public void annotationOnErrorIsTwiceTest() throws Exception {
        try {
            this.setAnnotatedClientEndpointInstance(new AnnotatedClientEndpointWithMultipleOnErrorAnnotations());
            this.logExceptionOnInvocation(false);
            this.invoke("echo", MESSAGE, new String[]{MESSAGE});
            new Exception("No exception has been thrown when multiple @OnError annotations defined");
        }
        catch (Exception e) {
            DeploymentException deploymentException = (DeploymentException)WSCClientIT.assertCause((Throwable)e, DeploymentException.class, (Object[])new Object[]{"DeploymentException has not been thrown when multiple @OnError annotations"});
        }
    }
}

