/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.servercontainer.upgradehttptowebsocket;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_TEXT = "TCK upgrade test message";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_spec_upgradehttp_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.spec.servercontainer.upgradehttptowebsocket"});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_spec_upgradehttp_web");
    }

    @Test
    public void upgradeHttpToWebSocketTest() throws Exception {
        boolean passed = false;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            CountDownLatch messageLatch = new CountDownLatch(1);
            StringBuffer receivedMessageString = new StringBuffer();
            config.getUserProperties().put("messageLatch", messageLatch);
            config.getUserProperties().put("receivedMessageString", receivedMessageString);
            Session session = clientContainer.connectToServer(TCKUpgradeEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/" + this.getContextRoot() + "/TCKTestServlet"));
            session.getBasicRemote().sendText(MESSAGE_TEXT);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            if (!receivedMessageString.toString().equals(MESSAGE_TEXT)) {
                throw new Exception("Received: [" + receivedMessageString.toString() + "] but should have been [TCK upgrade test message]");
            }
            passed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    public static final class TCKUpgradeEndpoint
    extends Endpoint {
        private CountDownLatch messageLatch;
        private StringBuffer receivedMessageString;

        public void onOpen(Session session, EndpointConfig config) {
            this.messageLatch = (CountDownLatch)config.getUserProperties().get("messageLatch");
            this.receivedMessageString = (StringBuffer)config.getUserProperties().get("receivedMessageString");
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    receivedMessageString.append(message);
                    messageLatch.countDown();
                }
            });
        }
    }
}

