/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointconfig;

import com.sun.ts.tests.websocket.common.TCKExtension;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.BooleanDecoder;
import com.sun.ts.tests.websocket.common.util.BooleanEncoder;
import com.sun.ts.tests.websocket.common.util.ByteDecoder;
import com.sun.ts.tests.websocket.common.util.ErrorEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.MessageValidator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointconfig.WSTestServer;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());
    private static final String CONTEXT_ROOT = "/ws_ee_clientendpointconfig_web";
    private static StringBuffer receivedMessageString = new StringBuffer();
    static volatile CountDownLatch messageLatch;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_ee_clientendpointconfig_web.war");
        archive.addClasses(new Class[]{WSTestServer.class});
        archive.addClasses(new Class[]{IOUtil.class});
        archive.addAsWebInfResource(WSClientIT.class.getPackage(), "web.xml", "web.xml");
        return archive;
    }

    @Test
    public void constructortest() throws Exception {
        boolean passed = true;
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"Extension size=0|TCKTestServer received String:Dummy String Test|TCKTestServer: Extension size=0", (String)receivedMessageString.toString());
            if (receivedMessageString.indexOf("subProtocol=|") > -1) {
                receivedMessageString.append("Correct subProtocol received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect subProtocol received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: subProtocol==|") > -1) {
                receivedMessageString.append("========Correct subProtocol received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect subProtocol received from server side");
            }
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    @Test
    public void preferredSubprotocolsTest() throws Exception {
        boolean passed = true;
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"Extension size=0|TCKTestServer received String:Dummy String Test|TCKTestServer: Extension size=0", (String)receivedMessageString.toString());
            if (receivedMessageString.indexOf("subProtocol=|") > -1) {
                receivedMessageString.append("Correct subProtocol received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect subProtocol received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: subProtocol==|") > -1) {
                receivedMessageString.append("========Correct subProtocol received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect subProtocol received from server side");
            }
        }
        catch (IOException ioex) {
            passed = false;
            ioex.printStackTrace();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    @Test
    public void extensionsTest() throws Exception {
        boolean passed = true;
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List)extension1));
        extensions.add(new TCKExtension("ext2", (List)extension2));
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().extensions(extensions).build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"TCKTestServer received String:Dummy String Test", (String)receivedMessageString.toString());
            if (receivedMessageString.indexOf("Extension size=0") > -1 || receivedMessageString.indexOf("Extension size=1") > -1 || receivedMessageString.indexOf("Extension size=2") > -1) {
                receivedMessageString.append("Correct Extensions received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect Extensions received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: Extension size=0") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=1") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=2") > -1) {
                receivedMessageString.append("========Correct Extensions received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect Extensions received from server side");
            }
        }
        catch (IOException ioex) {
            passed = false;
            ioex.printStackTrace();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    @Test
    public void constructorTest1() throws Exception {
        boolean passed = true;
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List)extension1));
        extensions.add(new TCKExtension("ext2", (List)extension2));
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).extensions(extensions).build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"TCKTestServer received String:Dummy String Test", (String)receivedMessageString.toString());
            if (receivedMessageString.indexOf("subProtocol=|") > -1) {
                receivedMessageString.append("Correct subProtocol received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect subProtocol received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: subProtocol==|") > -1) {
                receivedMessageString.append("========Correct subProtocol received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect subProtocol received from server side");
            }
            if (receivedMessageString.indexOf("Extension size=0") > -1 || receivedMessageString.indexOf("Extension size=1") > -1 || receivedMessageString.indexOf("Extension size=2") > -1) {
                receivedMessageString.append("Correct Extensions received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect Extensions received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: Extension size=0") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=1") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=2") > -1) {
                receivedMessageString.append("========Correct Extensions received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect Extensions received from server side");
            }
        }
        catch (IOException ioex) {
            passed = false;
            ioex.printStackTrace();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    @Test
    public void encodersTest() throws Exception {
        boolean passed = true;
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().encoders(expected_encoders).build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"EndpointConfig.getEncoders() returned encoders size=2|com.sun.ts.tests.websocket.common.util.ErrorEncoder|com.sun.ts.tests.websocket.common.util.BooleanEncoder|TCKTestServer received String:Dummy String Test", (String)receivedMessageString.toString());
        }
        catch (IOException ioex) {
            passed = false;
            ioex.printStackTrace();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    @Test
    public void decodersTest() throws Exception {
        boolean passed = true;
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().decoders(expected_decoders).build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"EndpointConfig.getDecoders() returned decoders size=|com.sun.ts.tests.websocket.common.util.ByteDecoder|com.sun.ts.tests.websocket.common.util.BooleanDecoder|TCKTestServer received String:Dummy String Test", (String)receivedMessageString.toString());
        }
        catch (IOException ioex) {
            passed = false;
            ioex.printStackTrace();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    @Test
    public void constructorTest2() throws Exception {
        boolean passed = true;
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List)extension1));
        extensions.add(new TCKExtension("ext2", (List)extension2));
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"EndpointConfig.getDecoders() returned decoders size=|com.sun.ts.tests.websocket.common.util.ByteDecoder|com.sun.ts.tests.websocket.common.util.BooleanDecoder|TCKTestServer received String:Dummy String Test", (String)receivedMessageString.toString());
            if (receivedMessageString.indexOf("Extension size=0") > -1 || receivedMessageString.indexOf("Extension size=1") > -1 || receivedMessageString.indexOf("Extension size=2") > -1) {
                receivedMessageString.append("Correct Extensions received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect Extensions received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: Extension size=0") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=1") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=2") > -1) {
                receivedMessageString.append("========Correct Extensions received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect Extensions received from server side");
            }
            if (receivedMessageString.indexOf("subProtocol=|") > -1) {
                receivedMessageString.append("Correct subProtocol received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect subProtocol received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: subProtocol==|") > -1) {
                receivedMessageString.append("========Correct subProtocol received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect subProtocol received from server side");
            }
        }
        catch (IOException ioex) {
            passed = false;
            ioex.printStackTrace();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    @Test
    public void constructorTest3() throws Exception {
        boolean passed = true;
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List)extension1));
        extensions.add(new TCKExtension("ext2", (List)extension2));
        try {
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).encoders(expected_encoders).build();
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, cec, new URI("ws://" + this._hostname + ":" + this._port + "/ws_ee_clientendpointconfig_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(5);
            session.getBasicRemote().sendText("Dummy String Test");
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            passed = MessageValidator.checkSearchStrings((String)"EndpointConfig.getEncoders() returned encoders size=2|com.sun.ts.tests.websocket.common.util.ErrorEncoder|com.sun.ts.tests.websocket.common.util.BooleanEncoder|EndpointConfig.getDecoders() returned decoders size=|com.sun.ts.tests.websocket.common.util.ByteDecoder|com.sun.ts.tests.websocket.common.util.BooleanDecoder|TCKTestServer received String:Dummy String Test", (String)receivedMessageString.toString());
            if (receivedMessageString.indexOf("Extension size=0") > -1 || receivedMessageString.indexOf("Extension size=1") > -1 || receivedMessageString.indexOf("Extension size=2") > -1) {
                receivedMessageString.append("Correct Extensions received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect Extensions received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: Extension size=0") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=1") > -1 || receivedMessageString.indexOf("TCKTestServer: Extension size=2") > -1) {
                receivedMessageString.append("========Correct Extensions received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect Extensions received from server side");
            }
            if (receivedMessageString.indexOf("subProtocol=|") > -1) {
                receivedMessageString.append("Correct subProtocol received from client side");
            } else {
                passed = false;
                receivedMessageString.append("Incorrect subProtocol received from client side");
            }
            if (receivedMessageString.indexOf("TCKTestServer: subProtocol==|") > -1) {
                receivedMessageString.append("========Correct subProtocol received from server side");
            } else {
                passed = false;
                receivedMessageString.append("========Incorrect subProtocol received from server side");
            }
        }
        catch (IOException ioex) {
            passed = false;
            ioex.printStackTrace();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect values, " + receivedMessageString);
        }
    }

    public void cleanup() throws Exception {
        super.cleanup();
    }

    public static final class TCKBasicEndpoint
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            String subprotocol = session.getNegotiatedSubprotocol();
            receivedMessageString.append("subProtocol=" + subprotocol + "|");
            List extensions = session.getNegotiatedExtensions();
            receivedMessageString.append("Extension size=" + extensions.size() + "|");
            for (Extension extension : extensions) {
                receivedMessageString.append(extension.getName() + "|");
            }
            List encoders = config.getEncoders();
            int size = encoders.size();
            receivedMessageString.append("EndpointConfig.getEncoders() returned encoders size=" + size + "|");
            for (Class encoder : encoders) {
                receivedMessageString.append("Encoder " + encoder + " found ");
            }
            List decoders = config.getDecoders();
            size = decoders.size();
            receivedMessageString.append("EndpointConfig.getDecoders() returned decoders size=" + size + "|");
            for (Class decoder : decoders) {
                receivedMessageString.append("Decoder " + decoder + " found ");
            }
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    receivedMessageString.append("========Basic String MessageHander received=" + message);
                    messageLatch.countDown();
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer data) {
                    byte[] data1 = new byte[data.remaining()];
                    data.get(data1);
                    receivedMessageString.append("========Basic ByteBuffer MessageHander received=" + new String(data1));
                    messageLatch.countDown();
                }
            });
        }

        public void onClose(Session session, CloseReason closeReason) {
            receivedMessageString.append("CloseCode=" + closeReason.getCloseCode());
            receivedMessageString.append("ReasonPhrase=" + closeReason.getReasonPhrase());
        }
    }

    class TCKConfigurator
    extends ClientEndpointConfig.Configurator {
        TCKConfigurator() {
        }

        public void beforeRequest(Map<String, List<String>> headers) {
        }

        public void afterResponse(HandshakeResponse hr) {
        }
    }
}

