/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.response;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import servlet.tck.common.response.ResponseTests;

public class ResponseTestServlet
extends GenericServlet {
    private static final String TEST_HEADER = "testname";
    private static final Class<?>[] TEST_ARGS = new Class[]{ServletRequest.class, ServletResponse.class};

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        String test = servletRequest.getParameter(TEST_HEADER).trim();
        try {
            Method method = ResponseTests.class.getMethod(test, TEST_ARGS);
            method.invoke(null, servletRequest, servletResponse);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        }
        catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        }
        catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }
}

